#version 430


vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}
vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  return rotateXY(vec4(p, 0.0), a).xyz;
}
vec3 rotateYZ3(vec3 p, float a) {
  return rotateYZ(vec4(p, 0.0), a).xyz;
}
vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


layout(points) in;
layout(triangle_strip, max_vertices = 8) out;
//layout(line_strip, max_vertices = 15) out;

in vec2 uv[];


out vec3 posG;
out vec2 uvG;
out vec2 uvOrig;
out float sharpnessG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;

uniform float g_pikselos = 0.0;

uniform float g_partSize = 0.15;



void main(void) {
//    if (gl_in.length()<1) {
//        return;
//    }

    mat4 mvp = projectionMatrix * modelViewMatrix;
    vec4 pos = gl_in[0].gl_Position*1.0;

    pos.w = 1.0;

  //  pos.z += sin(pos.x*10.4+g_time)*0.1+cos(pos.y*12.2*sin(pos.x*3.4)+g_time)*0.1+2.0;

    pos = rotateYZ(pos, 0.9*0.5*3.141592);
    pos = rotateXZ(pos, 3.6);

    pos.xyz *= 150.0;


    pos.y += 10.0;

    pos.z += 1.0;
   // pos.x *= 16.0/9.0;

    vec4 posO = modelViewMatrix*pos;

    vec4 result = texture2D(tex, uv[0]+vec2(0.0, 0.0));

    if (result.r < 0.00) {
        return;
    }

    int primID = gl_PrimitiveIDIn;


    float dofSharpArea = 1.0;
    float dofStrength = 32.0;
    float sharpness = clamp(10.0-clamp(abs(pos.z*0.007*dofStrength)-dofSharpArea, 0.0, 100000.0), 0.50, 4.0);

    //sharpness = .0;

    float sharpnessComp = clamp(sharpness, 0.50, 2.0);
    float pSize = g_partSize*(1.0+1.0*pow(sharpnessComp, 0.01)); // *(0.50+0.2*sin(primID));
    float sizeX = pSize; // /posO.z; // 100.0/windowWidth;
    float sizeY = pSize*16.0/9.0; // /posO.z; // 100.0/windowHeight;

    gl_PrimitiveID = gl_PrimitiveIDIn;
    sharpnessG = sharpness;
    gl_Position = mvp*pos+vec4(-sizeX, -sizeY, 0.0, 0.0);
    posG = gl_Position.xyz;
   // uvG = uv[0];
    uvG = vec2(0.0, 0.0);
    uvOrig = uv[0];
    EmitVertex();

    gl_Position = mvp*pos+vec4(sizeX, -sizeY, 0.0, 0.0);
    posG = gl_Position.xyz;
   // uvG = uv[0];
    uvOrig = uv[0];
    uvG = vec2(1.0, 0.0);
    EmitVertex();

    gl_Position = mvp*pos+vec4(-sizeX, sizeY, 0.0, 0.0);
    posG = gl_Position.xyz;
   // uvG = uv[0];
    uvOrig = uv[0];
    uvG = vec2(0.0, 1.0);
    EmitVertex();

    gl_Position = mvp*pos+vec4(sizeX, sizeY, 0.0, 0.0);
    posG = gl_Position.xyz;
    uvOrig = uv[0];
    uvG = vec2(1.0, 1.0);
    EmitVertex();

    EndPrimitive();

}
