import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0
import QtMultimedia 5.0

RocketScene {

    Audio {
        id: explosionSound
        property real playExplosionSound: sync("playExplosionSound")
        source: "../../explode1.wav"
        volume: 1.0
        onPlayExplosionSoundChanged: {
            if (playExplosionSound >=0.99) {
                explosionSound.stop();
                explosionSound.play();
            }

        }
    }

//    Timer {
//        running:true
//        interval: 20
//        repeat: true
//        onTriggered: {

//        }
//    }

    DemoCamera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: sync("camera.upX")
        upY: sync("camera.upY")
        upZ: sync("camera.upZ")
    }
/*
    Shader {
        file: sceneDir+"/sh_bg/shader"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva1
        Image {
            id: kuva1
            visible: false
            source: "mist_kivi.png"
        }
    }
    Texture {
        textureUnit: 1
        textureItem: kuva2
        Image {
            id: kuva2
            visible: false
            source: "mist_kivi_normal.png"
        }
    }
    */
    SetMaterial {
        shader: sceneDir+"sh_bg"
        texture0: sceneDir+"mist_kivi.png"
        texture1: sceneDir+"mist_kivi_normal.png"
    }

    DrawMesh {
        property string name: "bg"
        file: "mesh/aivob.x"
        depthTest: true
        depthWrite: false
        Rot { d: 1.0; ax: 0.0; ay: 1.0; az: 0.0 }
        Sca { s: 40.50; y: 1.0; }
        ShaderParam {
            paramName: "g_uvOfsX"
            paramValue: sync("uvOfsX")+rocket.time*0.0
        }
    }


    Texture {
        textureUnit: 0
        textureItem: particleTexture
        Image {
            id: particleTexture
            visible: false
            //source: "../../images/stars2_blue.png"
            source: "bokeh5.png"
            //source: "../../images/apo-mist-9090724-357_2.png"
        }
    }
    Texture {
        textureUnit: 1
        textureItem: particleNoise
        Image {
            id: particleNoise
            visible: false
            source: "random16.png"
        }
    }
    Texture {
        textureUnit: 2
        textureItem: particleEmitShape
        Image {
            id: particleEmitShape
            visible: false
            source: "Levikset.png"
            //source: "bokeh5.png"
        }
    }
    Texture {
        textureUnit: 3
        textureItem: particleEnv
        Image {
            id: particleEnv
            visible: false
            //source: "area_lights.jpg"
            source: "Bright-roof-multi.jpg"
            //source: "PeaceGardens_01_LDR.jpg"
            //source: "bokeh5.png"
        }
    }



    // --------------------------------------
    // ADVANCE PARTICLE SIMULATIONS
    // --------------------------------------

    property string shaderVaryings: "vec3 posG; vec2 uvG;"

    Shader {
        file: sceneDir+"/sh_partTrans/shader"
        tfVaryings: shaderVaryings
    }

    DrawVB {
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"partSim15"
        property string name: vboId
        reset: sync(name+"reset")
        tfVaryings: shaderVaryings
        gridWidth: 256
        gridHeight: 256
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
    }



    // --------------------------------------
    // RENDER PARTICLES
    // --------------------------------------
    Shader {
        file: sceneDir+"/sh_partDraw/shader"
    }
    DrawVB {
        enabled: true
        type: "pointGridDraw"
        vboId: sceneName+"partSim15"
        depthTest: true
        depthWrite: false
        ShaderParam {
            paramName: "g_pikselos"
            paramValue: sync("pikselos")
        }
        ShaderParam {
            paramName: "g_partSize"
            paramValue: 1.50
        }
    }



    GodRay {

    }

}
