#version 430



vec4 rotateXZ(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.z;
r.z = sin(a)*p.x + cos(a)*p.z;
return r;
}

vec3 rotateXZ3(vec3 p, float a) {
return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
vec4 r = p;
r.x = cos(a)*p.x - sin(a)*p.y;
r.y = sin(a)*p.x + cos(a)*p.y;
return r;
}

vec4 rotateYZ(vec4 p, float a) {
vec4 r = p;
r.y = cos(a)*p.y - sin(a)*p.z;
r.z = sin(a)*p.y + cos(a)*p.z;
return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(points) in;
layout(points) out;
layout(max_vertices = 4) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 vs_pos[];
in vec2 uv[];

out vec3 posG;
out vec2 uvG;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;
uniform float g_timeStep;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNoise;
layout(binding=2) uniform sampler2D texEmitShape;

uniform float g_pikselos = 0.0;



void main(void) {

   // mat4 mvp = projectionMatrix * modelViewMatrix;
    vec3 posNois = vec3(uv[0], 0.0);
    float tkk = 1.1;

    vec3 pos = vs_pos[0];

    float distFromOrig = dot(pos,pos);

    if (distFromOrig > 5.0) {
        pos.xyz = vec3(0.0);
    }

    float bScale = 2.4;

    vec4 emitShape = texture2D(texEmitShape, uv[0]);

    if (emitShape.r < 0.5 ) {
  //      return;
    }

    float myTime = g_time*1.0;
    float timeStepScale = 0.025;

    posNois.x += cos(myTime*tkk+bScale*pos.y*(2.2+2.0*sin(myTime))*sin(g_time*tkk*1.2+pos.y*10.3));
    posNois.y += sin(myTime*tkk*1.23-bScale*pos.x*(2.2+2.0*cos(0.3+myTime*0.7))*cos(myTime*tkk*0.912+pos.x*10.3));
    posNois.z += 2.5*sin(myTime*tkk*1.63-bScale*pos.y*(1.2+1.0*sin(0.45+myTime*0.32))*cos(myTime*tkk*1.312+pos.y*12.3-pos.z*10.3));
//    vec4 result = texture2D(texNoise, uvNois*0.10+vec2(0.0, 0.0));


//    pos.x += 0.1*sin(pos.y*24.4+myTime)*0.1;
//    pos.y += 0.1*cos(pos.y*24.2*sin(pos.x*23.4)+myTime)*0.1;
//    pos.z += 0.005*cos(pos.y*11.2*cos(pos.x*12.4)+myTime)*0.1;

    pos.xyz += g_timeStep*posNois.xyz*timeStepScale; // (0.2+0.15*sin(g_time*1.0));

    vec4 noiseValue = texture2D(tex, uv[0]+vec2(0.0, 0.0));
//    pos.xy += noiseValue.xy*1.1;


//    pos.z += abs(0.10*(result.r*1.0-0.5)*0.20);
//    pos.x += 0.0*(result.g*1.0-0.5)*0.20;
//    pos.y += 0.0*(result.b*1.0-0.5)*0.20;

//    pos.z += 0.0003;

//    float maxZ = 0.02;

//    if (pos.z > maxZ) {
//        pos.z = -maxZ;
//    }
// vec4 result = texture2D(tex, uv[0]+vec2(0.0, 0.0));

    //pos.x += 10.0*sin(g_time);
    //pos.y += 10.0*cos(g_time);

    posG = pos;
    uvG = uv[0];
    EmitVertex();
    EndPrimitive();
}
