uniform float u_passes;

uniform vec3 u_ls1;

uniform vec2 u_randpos;
uniform float u_focus;
uniform float u_xzdist;
uniform float u_day;

uniform vec3 u_campos;
uniform mat3 u_camdir;
uniform float u_focal_z_dist;

uniform vec4 u_logop;

uniform vec4 u_pl2;

uniform float u_saturnclip;

float ft;


mat3 rot_x(float ang) { return mat3(
			1.0, 0.0, 0.0,
			0.0, cos(ang), -sin(ang),
			0.0, sin(ang), cos(ang)); }
mat3 rot_y(float ang){ return mat3(
			cos(ang), 0.0, -sin(ang),
			0.0,      1.0, 0.0,
			sin(ang), 0.0, cos(ang)); }
mat3 rot_z(float ang) { return mat3(
			cos(ang), -sin(ang), 0.0,
			sin(ang), cos(ang), 0.0,
			0.0, 0.0, 1.0); }


struct ray_t 
{
	vec3 o;
	vec3 d;
};

void doplane(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;

		if (u_saturnclip < 1.f)
		{
			vec3 hp = ray.o + ray.d * curdist;
			if (sin(length(hp.xz)*0.3-ft*3.14159*(77.0/60.0)-0.2) > u_saturnclip)
				return;
		}

		if (det > 0.0) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0) { loc_max = curdist; }
	}
}

vec4 hlogo;

void doplane2(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o);
		float curdist=num/det;
		if (det > 0.0) {
			vec3 hp =ray.o + ray.d * curdist;
			vec2 uvc = hp.xy * u_logop.xy;
			uvc += u_logop.zw;
			uvc = clamp(uvc, vec2(0.0), vec2(1.0));

			hlogo = texture2D(iChannel1, uvc);
			if (hlogo.a > 0.5)
			{ loc_min = curdist; loc_obj_id=obj_id; }
		}
	}
}

#if 0
void doplane_csg(in ray_t ray, in vec4 plane, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	float det=dot(plane.xyz,ray.d); 
	if (abs(det) > 0.0000001)
	{
		float num=plane.w - dot(plane.xyz, ray.o); float curdist=num/det;
		if (det > 0.0 && curdist > loc_min) { loc_min = curdist; loc_obj_id=obj_id; }
		if (det < 0.0 && curdist < loc_max) { loc_max = curdist; }
	}
}
#endif

void dosphere(in ray_t ray, in vec4 sphere, in int obj_id, inout float loc_min, inout float loc_max, inout int loc_obj_id)
{
	vec3 d1 = ray.o - sphere.xyz;
	float b = 2.0 * dot(normalize(ray.d), d1);
	float c = dot(d1,d1) - sphere.w*sphere.w;

	float delta = b*b - 4.0*c;

	if (delta >= 0.0)
	{
		loc_min = (-b-sqrt(delta))/ (2.0);
		loc_max= (-b+sqrt(delta))/ (2.0);

		loc_obj_id = obj_id;
	}
	else
	{
		loc_min = 100000.0;
		loc_max = -100000.0;
	}
}

vec3 ls1, ls1j;

uniform vec4 ballposses[10] =
vec4[](
	vec4(6.0, -24.0, 0.0, 20.0),
	vec4(0.0, -1.0, 0.0, 6.0),
	vec4(12.0, -1.0, -9.0, 6.0),

	vec4(0.0, 7.0, 0.0, 3.0),
	vec4(0.0, 13.0, 0.0, 3.0),
	vec4(0.0, 17.0, 0.0, 4.0),

	vec4(-4.0, 13.0, 0.0, 2.0),
	vec4(-6.0, 11.0, 0.0, 2.0),
	vec4(4.0, 13.0, 0.0, 2.0),
	vec4(6.0, 11.0, 0.0, 2.0)

	);
uniform vec3 ballcolors[10]=
vec3[](
	vec3(1.0, 0.6, 0.2),
	vec3(1.0, 0.0, 0.7),
	vec3(1.0, 1.0, 0.0),
	vec3(0.1, 0.1, 0.1),
	vec3(0.9, 0.9, 0.9),
	vec3(0.1, 0.1, 0.1),

	vec3(0.9, 0.9, 0.9),
	vec3(0.1, 0.1, 0.1),
	vec3(0.9, 0.9, 0.9),
	vec3(0.1, 0.1, 0.1)
	);

vec4 pl1 = vec4(0.0,-1.0,0.0, 13.0);
vec4 pl2 = u_pl2;


float shoot(inout ray_t ray, out int obj_id)
{
	int loc_obj_id;
	float loc_min;
	float loc_max;

	float dist;

	obj_id = -1;
	dist = 100000.0;
	loc_min = -1000000.0;
	loc_max = 1000000.0;

#define homo(_n) 	dosphere(ray, ballposses[_n], _n, loc_min, loc_max, loc_obj_id); if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
	for (int i = 0;i < 10; i++)
	{
		homo(i);
	}

	doplane(ray, pl1, 100, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

	doplane2(ray, pl2, 101, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }

/*	dosphere(ray, ballposses[4], 4, loc_min, loc_max, loc_obj_id);
	if (loc_min < dist && loc_min > 0.0) { dist = loc_min; obj_id = loc_obj_id; }
*/
	return dist;
}

float snoise(vec3 co){
    return fract(sin(dot(co.xyz ,vec3(12.9898,78.233, 191.666))) * 43758.5453);
}


float shade(inout ray_t ray, in float dist, in int obj_id, inout vec3 outcol, inout vec3 refblendfac)
{

	if (obj_id == -1)
	{
		vec3 color;
		//color = mod(atan(ray.d.x / ray.d.z) * 5.9 +ray.d.y *5.2- ft * 0.4123, 1.0);
		//color = mod(atan(ray.d.x / ray.d.z) * 5.9 +ray.d.y *5.2- ft * 0.4123, 1.0);
		//color = vec3(ray.d.y * 4.0 + 1.0);
		//color.r *= 0.7 + sin(atan(ray.d.x / ray.d.z) * 10.0 + ft * 5.221+ray.d.y*49.2) * 0.3;
		//color *= vec3(0.51, 0.584, 0.98) * u_day;

		vec2 tuv;
		tuv.x = atan(ray.d.x / ray.d.z) * 4.0 / 3.14159;
		tuv.y = ray.d.y * 2.0;
		color = texture2D(iChannel2, tuv).rgb;

		color *= u_day;

		//color = vec3(0.0);
		outcol += color * refblendfac;


		return 0.0;
	}

	//outcol += vec3(0.0, 0.0, 1.0);
	//return 0.0;

	vec3 color;

	vec3 hp = ray.o + ray.d * dist;
	vec3 normal;
	vec3 thiscol = vec3(0.0);

	vec3 hprot = hp;

	hprot -= ballposses[obj_id].xyz;
	normal = normalize(hprot);

	//hprot = ballmtx[obj_id] * hprot;
	color = ballcolors[obj_id];

	if (obj_id == 100)
	{
		normal = vec3(0.0, 1.0, 0.0);

		float dor = length(hp.xz - ballposses[0].xz) - ft * 3.232;
		normal.x = sin(dor) * 0.2;
		normal.z = sin(dor) * 0.2;

		dor = length(hp.xz - ballposses[0].xz) * 2.2 - ft * 2.232;
		normal.x = sin(dor) * 0.1;
		normal.z = sin(dor) * 0.1;

		normal.x += sin(hp.z + ft * 2.32) * 0.04;
		normal = normalize(normal);
		color = vec3(0.4, 0.3, 0.7);
	}
	else if (obj_id == 101)
	{
		normal = pl2.xyz;
		color = hlogo.rgb;
		//color = vec3(1.0, 0.0, 0.0);
	}
	else
	{

	float da = length(normal.xz);
	float na = atan(normal.x, normal.z)/3.14159 + 4.0;

	const float joulureso = 9.0;

	na = floor(na * joulureso)/joulureso;
	na*=3.14159;

	normal.x = sin(na) * da;
	normal.z = cos(na) * da;


	da = length(normal.xy);
	na = atan(normal.x,normal.y)/3.14159 + 4.0;

	na = floor(na * joulureso)/joulureso;
	na*=3.14159;

	normal.x = sin(na) * da;
	normal.y = cos(na) * da;

	//normal += (texture2D(u_blurnoise, hprot.xy*0.01+hprot.z*0.01).rgb - vec3(0.5))*0.3;
	//normal = normalize(normal);

	normal = normalize(normal);
}

	vec3 ld = ls1j - hp;
	float lightdist = length(ld);

	ld /= lightdist;

	float ld_normal_dp = dot(ld, normal);

	float diffuse = max(0.0, ld_normal_dp);

	float specular_amount = 1.0;

	ray_t shadowray;
	shadowray.o = hp + ld * 0.001;
	shadowray.d = ld;

	int id_unused;
	if (shoot(shadowray, id_unused) < lightdist)
	{
		diffuse = 0.0;
		specular_amount = 0.0;
	}

	vec3 ref_ray_d = ray.d - 2.0*dot(ray.d, normal) * normal;
	float ref_fac = pow(max(-dot(normal, ray.d), 0.0), 1.0);

	//float atten = max(0.0, 1.0 - dist * 0.0006);
	vec3 reflection_amount = vec3(0.5) + color * 0.5;
	if (obj_id == 100)
	{
		reflection_amount = vec3(0.5);
	}
	else if (obj_id == 101)
		reflection_amount = vec3(0.0);

    vec3 new_refblendfac = ref_fac * refblendfac * reflection_amount;

 	// ambient
	thiscol += color * 0.1;
	// diffuse
	thiscol += color * diffuse * 0.7;
	// SMG lighting
	thiscol += vec3(pow(1.0 - ref_fac, 5.0) * 0.2);

	outcol += thiscol * refblendfac;
	outcol += vec3(0.8) * pow(max(dot(ref_ray_d, ld), 0.0), 10.0) * specular_amount;

	//if (obj_id == 100 && (sin(uvr.x*4231.6)+sin(uvr.y*9523.3)) > 0.0)
	//	ray.d = refract(ray.d, normal, 1.5);
	//else
	ray.d = ref_ray_d;


	ray.o = hp;
	refblendfac = new_refblendfac;

	return length(refblendfac);
}

void lights(in ray_t ray, inout vec3 outcol, in float dist, in vec3 refblendfac, in float pwrbase)
{
	vec3 lsv1 = (ls1 - ray.o);
	float light_dist = length(lsv1);
	float ld1 = pow(max(0.0, dot(normalize(lsv1), ray.d)), pwrbase * light_dist);
	if (light_dist < dist)
		outcol += vec3(5.0) * ld1 * refblendfac;
}


vec3 trace(in ray_t p_ray, out float primarydist)
{
	ray_t ray;

	int obj_id;
	float dist;
	vec3 refblendfac;
	float cont;

	vec3 outcol;

	outcol = vec3(0.0);
	refblendfac = vec3(1.0);
	ray = p_ray;

	dist = shoot(ray, obj_id);
	lights(ray, outcol, dist, refblendfac, 1000.0);
	cont = shade(ray, dist, obj_id, outcol, refblendfac);

	vec3 fuggol = vec3(0.0);

	primarydist = dist;

#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 0.0, 1.0);
	}
#endif
#if 1
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 10.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(0.0, 1.0, 0.0);
	}
#endif

#if 0
	if (cont > 0.05)
	{
		dist = shoot(ray, obj_id);
		//lights(ray, outcol, dist, refblendfac, 1.0);
		cont = shade(ray, dist, obj_id, outcol, refblendfac);

		fuggol = vec3(1.0, 1.0, 0.0);
	}
#endif
	//return fuggol;



/*	
	if (obj_id == 1)
		outcol = vec3(1.0, 0.0, 0.0);
	else if (obj_id == 2)
		outcol = vec3(0.0, 1.0, 0.0);
*/
	return outcol;
}

vec4 function()
{
	ft = motionblur(2.0);

	vec3 ls1 = u_ls1;
	ls1j = ls1 + (texture2D(u_blurnoise, uvr).rgb - vec3(0.5))*5.0;



/*
	camdir_mtx = rot_x(0.0) * camdir_mtx;
	camdir_mtx = rot_y(cos(ft*0.96)*-0.1) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*5.3)*0.01) * camdir_mtx;


	float sp = pow(u_shock/4.0,2.0)*4.0;
	camdir_mtx = rot_x(sin(ft*9.4772) * 0.01 * sp) * camdir_mtx;
	camdir_mtx = rot_z(sin(ft*9.57) * 0.02 * sp) * camdir_mtx;
	camdir_mtx = rot_y(sin(ft*8.8235) * 0.012 * sp) * camdir_mtx;
*/

// ray setup
	ray_t tr;

	tr.o = u_campos;
	tr.d = (vec3(uv2*1.0*vec2(1.0,0.8), 1.5));

	vec3 newd = u_camdir * tr.d;

	vec3 ray_target = tr.o + newd * abs(u_focal_z_dist / tr.d.z);

	// integration setup
	vec3 outcol = vec3(0.0);
	vec2 kpjit = vec2(0.0);
	kpjit += (texture2D(iChannel0, uvr*5.252).rg-vec2(0.5)) * 5.5;


	ray_t ray;
	vec2 nuv = uv2 * 0.0;

	#if 1
	nuv += kpjit;
	#endif

	// rotatointiin: tee vektorit up ja left, sitten kerro nuv.x ja nuv.y niillä

	ray.o = u_camdir * vec3(nuv, 0.0) + tr.o;
	ray.d = normalize(ray_target - ray.o);

	//ray.o = tr.o;
	//ray.d = normalize(newd);

	float primarydist;

	outcol += trace(ray, primarydist);

	#if 0

	float godray = 0.0;
	float stepmul = primarydist / 10.0;
	int st = 0;
	for (st = 0; st < 10; st++)
	{
		vec3 hp = ray.o + ray.d * st * stepmul;

		vec3 ld = ls1j - hp;
		float lightdist = length(ld);
		ld /= lightdist;

		ray_t shadowray;
		shadowray.o = hp;
		shadowray.d = ld;

		int id_unused;
		if (shoot(shadowray, id_unused) > lightdist)
			godray += 0.1;
	}

	outcol *= vec3(godray);
	#endif

//	outcol /= u_passes;

	//outcol = ballposses[8].xyz;

	//outcol = texture2D(iChannel0, uvr*5.252).rrr;
	//outcol = vec3(0.0);
	//outcol.b = mod(gl_FragCoord.x, 2.0);
	//outcol.b = mod(gl_FragCoord.y, 2.0);
	//outcol.gb = outcol.r;
	//outcol.r += -0.54;



	return vec4(outcol, 0.0);
}
