#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D skeneA;
uniform sampler2D skeneB;
uniform vec2 res;
uniform float blenderFxSkeneA;
uniform float blenderFxSkeneB;

const int Nsamples = 128;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
  color = vec4(0.0);
  vec2 pos = UV;
  float w = 1.0;
  float wsum = 0.0;
  for (int i = 0; i < Nsamples; i++) {
    color += w * texture(inputtex, pos);
    float aam = 3.0 * rand(pos + color.rb);
    pos -= alpha*aam * ray / res * vec2(res.x / res.y, 1.0);
    wsum += w;
    w *= 0.9;
  }
  color = texture(inputtex, UV) + addConst * color / wsum;
}
