#version 330 core
out vec4 outpColor;
in vec2 UV;
uniform sampler2D inputtex;

uniform float blurstep;
uniform vec2 blurdir;
uniform vec2 res;

#define BLURSTEPS 16

void main() {
	outpColor = vec4(0.0);
	vec2 blurpos = UV - blurdir * float(BLURSTEPS) / 2.0 * blurstep / res;

	for (int i = 0; i < BLURSTEPS; i++) {
		outpColor += texture(inputtex, blurpos);
		blurpos += blurdir * blurstep / res; // TODO: normalize blurstep to res idp quantity
	}

	outpColor /= float(BLURSTEPS);
}
