#version 330 core
in vec2 UV;
uniform float iGlobalTime;
uniform vec2 iResolution;
uniform sampler2D iChannel0;
out vec4 color;

uniform float MOD;
uniform float timecoef;
//const float MOD = 12.0;

// thickness [0.0, 2.0]
vec4 stripes(vec2 uv, float lscale, float dx, float thickness, float offset) {
    float coord = uv.y + dx * uv.x - float(uv.x > 0.5) * 2.0 * dx * (uv.x - 0.5);
    float c = float(mod(float(/*floor*/(coord / lscale + offset)), 2.0) > 2.0 - thickness);
    return texture2D(iChannel0, uv); //vec4(0.75*vec3(c), 1.0);
}

vec4 circles(vec2 uv) {
    return vec4(1.0);
}

mat2 rotationMatrix(float angle)
{
    float s = sin(angle);
    float c = cos(angle);    
    return mat2(c,  -s, 
                s,  c);
}

vec2 gale(vec2 inp) {
    vec2 dx = inp - vec2(0.5);
    float angle = atan(dx.y, dx.x) + 3.141/2.0;
    float r = length(dx);
    int idx = int(mod(floor(angle / (2.0 * 3.141 / MOD) + 0.0*0.5), 2.0));
    angle = timecoef*iGlobalTime + 2.0*3.141/MOD*float(idx == 0)
         + (1.0 - 2.0 * float(idx == 0))
         * mod(angle, 2.0 * 3.141 / MOD);
    return vec2(0.5) + r * vec2(cos(angle), sin(angle));
}

void main()
{
    vec2 coord = UV;
    vec2 uv = coord; // Time independent
    uv = gale(uv);
    uv = (1.0 + 0.2 * cos(timecoef*iGlobalTime)) * rotationMatrix(45.0 * 3.141/180.0 + timecoef*0.1*iGlobalTime) * uv; // Transform
    color = stripes(uv, 0.5 + 0.48 * sin(0.10*timecoef*iGlobalTime), sin(0.0 * iGlobalTime), 1.0 + 0.0*cos(0.7241 * iGlobalTime), -0.5 * timecoef * iGlobalTime);
}
