#version 330 core
layout(location=0) in vec3 deltaVertex; // corner vertices. center extracted with UV
layout(location=1) in vec2 locuv;
uniform mat4 V;
uniform mat4 P;
uniform float particlesize;

uniform sampler2D statebuffer;
out vec2 UV;
out vec3 pos;
out vec3 worldpos;
out float ccoef;

void main() {
	vec4 state = texture(statebuffer, locuv);
	vec3 radial = state.xyz;
	vec3 cu = vec3(V[0][0], V[1][0], V[2][0]);
	vec3 cr = vec3(V[0][1], V[1][1], V[2][1]);
	vec4 viewTfd = V * vec4(radial + 3.0 * particlesize*(deltaVertex.x * cu + deltaVertex.y * cr), 1.0);
	vec4 projd = P * viewTfd;
	gl_Position = projd;
	//gl_Position = vec4(deltaVertex.xy, 0.5, 1.0);
	UV = deltaVertex.xy + vec2(0.5);
	pos = projd.xyz;
	worldpos = radial;
	ccoef = state.a;
}
