#version 330 core
in vec2 UV;
uniform float iGlobalTime;
layout(location = 0) out vec4 color;

vec3 raytriangle(vec3 o, vec3 q, vec3 a, vec3 b, vec3 d) {
	vec3 ca = vec3( a.xy,  1.0);
	vec3 cb = vec3( b.xy, -1.0);
	vec3 cc = vec3(-d.xy,  0.0);
    mat3 eqn = mat3(ca, cb, cc);
    vec3 rhs = vec3((o-q).xy, 0.0);
    vec3 state = inverse(eqn) * rhs;
    return o + abs(state.z) * d;
}

void main()
{
	vec2 uv = UV - vec2(0.5);
    vec3 ray = normalize(vec3(5.0*uv, 1.25));
    float a = 30.0 * 3.141 / 180.0;
    float A = 60.0 * 3.141 / 180.0;
    vec3 hitp = raytriangle(vec3(0.0, 0.0, 1.2*iGlobalTime),
    	                    vec3(-0.5, -1.0 * 2.0 / tan(a), 0.0),
    	                    vec3(1.0, 0.0, 0.0),
    	                    vec3(-0.5, tan(A) / 2.0, 0.0),
    	                    ray);
	color = vec4(vec2(mod(hitp.z,1.0)),0.5+0.5*sin(iGlobalTime),1.0);
	color = vec4(vec3(floor(mod(hitp.z, 1.0) + 0.1)),1.0);
}