


varying vec4 position;
uniform sampler2D PositionTexture; 
varying vec4 thecolor;
uniform sampler2D OriginalColorTexture; 
uniform sampler2D ColorTexture; 
uniform float DeltaT;
uniform float ttime;
uniform float ResolutionMultiplier;


const float InverseMaxInt = 1.0 / 4294967295.0;


float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed,1.0)-0.5;
	float y=randhash (uint(seed+413),1.0)-0.5;
	float z=randhash (uint(seed*2+12),1.0)-0.5;
	return vec3(x,y,z);

};



void main()
{

	vec4 glVertex= gl_Vertex;
	int rnd=gl_VertexID;
	int MyIndex=rnd;
	int poss=int(rnd);
	int x=poss%1536;
	int y=poss/1536;

	// get current position from positionTexture
	glVertex.xyz=texture2D (PositionTexture,vec2 (float(x),float(y))/1536.0).xyz;


	vec3 GPUColors=texture2D (ColorTexture,vec2 (float(x),float(y))/1536.0).xyz;
	float SizeW=texture2D (PositionTexture,vec2 (float(x),float(y))/1536.0).w;
	//SizeW=1.0;
	vec3 OriginalColors=texture2D (OriginalColorTexture,vec2 (float(x),float(y))/1536.0).xyz;
	glVertex.w=1.0;
	gl_Position =  glVertex;
	position=gl_Position.xyzw;


	float fstop=clamp ((ttime-30.0)*0.12,0.0,1.0);



	gl_Position = gl_ModelViewProjectionMatrix *position;
	thecolor=vec4 (0.2,0.3,0.2,1.0);
	gl_PointSize=1.0;

	thecolor.xyz=OriginalColors.xyz*0.6*vec3 (0.2,0.4,0.5);

	thecolor.xyz=GPUColors;



	//if (ttime>1000)
	{ 


		if (poss%613==0){
			gl_PointSize=clamp (SizeW*0.5,0.0,1.0)*randhash (MyIndex,1.0)*30.0*(0.5+0.5*sin(ttime*2.0*randhash (MyIndex*3,1.0)));;
			//thecolor*=0;
			//			thecolor+=(2.0*vec4 (1.8,0.7,0.3,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (MyIndex*3,1.0)));

		}


		if (poss%212==0){
			gl_PointSize=2.0+1.1*clamp (0.0+SizeW*0.5,0.0,1.0)*randhash (MyIndex,1.0)*200.0*(0.5+0.5*sin(ttime*0.3*randhash (MyIndex*3,1.0)));;
			thecolor+=thecolor*(2.0*vec4 (1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*0.0*randhash (MyIndex*3,1.0)));
		}
	}






	if (poss%2112==0){
		gl_PointSize*=55.0*randhash (MyIndex*42,1.0);
	}

//gl_PointSize=clamp (gl_PointSize,0.0,18.0);
	//gl_PointSize*=0.5;
	//thecolor=vec4 (1.0);
	
	
	//thecolor*=vec4 (1.0-pow(gl_Position.z*0.09,1.0))*0.8*vec4 (1.0,1.1,1.2,1.0);
	
	//thecolor*=0.5+0.5*sin(float (MyIndex)*0.02);
	//thecolor*=vec4 (0.5+0.25*sin(15.0*(1.0-pow(gl_Position.z*0.07,1.0))));
	//thecolor*=1+SizeW*0.5;
	thecolor.w=texture2D (ColorTexture,vec2 (float(x),float(y))/1536.0).w;
//gl_PointSize=3.0;
	thecolor.w=1.0;
	
	//thecolor.xyzw=vec4 (0.05,0.1,0.2,1.0)+(vec4 (0.2,0.1,0.0,1.0)-vec4 (0.05,0.1,0.2,1.0))*(0.5+0.85*sin (ttime+float (MyIndex)*0.001));
	thecolor.xyzw=vec4 (0.05,0.1,0.2,1.0)+(vec4 (0.05,0.2,0.2,1.0)-vec4 (0.05,0.1,0.2,1.0))*(0.5+0.85*sin (0.1*ttime+float (MyIndex)*0.001));
	
	
	float fll=0.5+0.6*sin(ttime*0.7+float (MyIndex)*0.0001);
	fll=pow (fll,7.0);
	thecolor.xyzw*=fll;

	thecolor*=1.1;

	gl_PointSize*=1.0+0.3*(1.0-pow(gl_Position.z*0.07,2.0));
	if (gl_PointSize<2.0) {

		thecolor*=0.3+0.3*sin(ttime*0.4+float (MyIndex)*0.01);
		if (poss%10==0)
			thecolor*=10.0;
		//3+0.3*sin(ttime*1.4+float (MyIndex)*0.01);
		
	}



	if (MyIndex>65535) { 
		//gl_PointSize=2.0;
		thecolor=vec4 (1.0);
	};


	if (MyIndex%10==0) 
		gl_PointSize*=3.0;


	//if (gl_PointSize<3.0) 		thecolor*=0.0;

		gl_PointSize *=ResolutionMultiplier;
	thecolor*=clamp ((ttime-80.5-float (MyIndex)*0.00001)*0.08,0.0,1.0);
	//thecolor=vec4 (1.0);
		//gl_PointSize+=4;
	//thecolor=vec4 (1.0);
	//texture2D (PositionTexture,vec2 (float(x),float(y))/1024.0).w;
}