#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;

//uniform image2D destTexPos;
//uniform image2D destTexCol;

layout (binding=0) writeonly uniform image2D destTexPos;
//layout (binding=1) writeonly uniform image2D destTexVel;
layout (binding=2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture; 
//uniform sampler2D ColorTexture; 
uniform sampler3D CurlTexture; 

uniform sampler2D OriginalPositionTexture; 
uniform sampler2D OriginalColorTexture; 
uniform sampler2D OriginalPositionTexture_Bird; 
uniform sampler2D Swirl_Texture; 

uniform mat4 RotationMatrix;
uniform mat4 RotationMatrix3;

uniform float MegaRotate;

layout (local_size_x = 16, local_size_y = 16) in;

layout (std140, binding=4) buffer Pos { vec4 Positions[]; }; 
//layout (std140, binding=5) buffer Vel { vec4 Velocities[]; }; 
layout (std140, binding=6) buffer Col { vec4 Colors[]; }; 
float breaktime=18.0;

const float InverseMaxInt = 1.0 / 4294967295.0;



uint MyIndex=0;



mat3 RotateNow(float Phi, float Theta, float Psi) {
	mat3 Ret;
	float c1=cos(Phi);
	float s1=sin(Phi);
	float c2=cos(Theta);
	float s2=sin(Theta);
	float c3=cos(Psi);
	float s3=sin(Psi);
Ret[0]	= vec3 (c2*c3,-c2*s3, s2);
Ret[1]	= vec3 (s1*s2*c3+c1*s3,-s1*s2*s3+c1*c3, -s1*c2);
Ret[2]	= vec3 (-c1*s2*c3+s1*s3, c1*s2*s3+s1*c3, c1*c2);
return Ret;
	}





float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);

    float n = p.x + p.y*57.0 + 113.0*p.z;

    float res = mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                        mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
                    mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                        mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
    return res;
}


float fbm( vec3 p )
{
    float f;
	float fc=1.0;

	
    f  = 0.5000*noise( fc*p*1.0 +vec3 (ttime*0.33,ttime*0.1,ttime*0.5));
    return f;
}



vec3 Rotation (vec3 Input, mat4 RotationM) { 
	vec4 Inn=Input.xyzz;
	Inn.w=1.0;
	Inn=RotationM*Inn;

	float fc=1.0-clamp (pow (length (Input)*1.1,1.0)+0.0,0.3,1.0);
	fc=0.4+0.4*sin(1*length (Input)+ttime);
	fc*=clamp ((ttime-100)*0.5,0.0,1.0);
	fc=0;
	Inn.xyz+=(Input-Inn.xyz)*fc;

	return Inn.xyz;

};











float randhash(uint seed)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(1.0 * float (i)) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (seed)-0.5;
	float y=randhash (seed+413)-0.5;
	float z=randhash (seed*2+12)-0.5;
	return vec3(x,y,z);

};

vec3 GetCurl (vec3 Pos) { 

	return texture (CurlTexture,vec3 (-2.5)+Pos.xyz).xyz;
};



float SmoothCurve (float f) {

return (clamp (f,0.0,1.0));
};




#define INVOCATION_SIZE (1536)
void main() {




	MyIndex=gl_GlobalInvocationID.x+gl_GlobalInvocationID.y*INVOCATION_SIZE;
	float fMyIndex=float(MyIndex);

	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);



	vec3 OriginalPos=0.5*texture (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
vec3 OriginalPositionTexture_Bird=1.0*texture (OriginalPositionTexture_Bird,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;

	float fc=0.0;

	fc=0.0;


	vec3 Disturb=GetCurl (vec3 (ttime*0.00)+0.16*Positions[MyIndex].xyz)*0.1;
	Disturb+=GetCurl (vec3 (ttime*0.01)+0.11*Positions[MyIndex].xyz)*0.1;

if (ttime>52+float(MyIndex)*0.000001) 
{
	//Disturb+=GetCurl (vec3 (ttime*0.01)+0.04*Positions[MyIndex].xyz)*3.4;
Disturb+=vec3 (0.0,1.0,0.0);
}

if (ttime>56+fMyIndex*0.000003) 
{
	//Disturb+=GetCurl (vec3 (ttime*0.01)+0.04*Positions[MyIndex].xyz)*3.4;
Disturb+=vec3 (-4.0,0.0,0.0);
}


	//Disturb+=vec3 (0.0,13+2.5*pow(1.1*randhash (MyIndex*22,1.0),4.0),0.0)*0.3;
		//Disturb+=OriginalPositionTexture_Bird.xyz;
if (ttime<19)	
	Disturb+=vec3 (-1.2,0.0,0.0);
else{

//if (MyIndex%100<20)
	//Disturb+=vec3 (0,2.0*SmoothCurve (ttime-19),0.0);
}


//Disturb.x=+abs (Disturb.x)*1;
if (ttime<20)
			if (MyIndex%120000<20000) Disturb+=vec3 (3.2,0.0,0.0);



//if (randhash (MyIndex*3)<0.1) Disturb*=-1;
		//(1.1*randhash (MyIndex*22,1.0),4.0),0.0)*0.3;




	float recl;
	//=PosY-fMyIndex*0.000001;
	//0.5+0.4*sin(fMyIndex*0.0000000001+ttime*0.02)+PosY+OriginalPositionTexture_Bird.z*0;
	vec3 FlatPosition;

	//swirl
	float theta=2*3.1432626535*float(storePos.x)*(1.0/1536.0);
	float phi=0.45*float(storePos.y)*(1.0/1536.0);
	vec2 SUV=vec2 (sin(theta),cos(theta))*phi;
	vec2 SUV2=vec2 (cos(theta+ttime*0.0),sin(theta+ttime*0.0))*phi*vec2 (9.0/16.0,1)*1.4;
	FlatPosition=vec3 (0,SUV.x,SUV.y);
	vec3 TargetOP=randhash3 (MyIndex*52);
		TargetOP=normalize(TargetOP)*2.0;

	FlatPosition+=(TargetOP-FlatPosition)*SmoothCurve ((ttime-18-fMyIndex*0.00002)*0.4);
	
	
	mat3 C;


//	Disturb*=0;



	Disturb+=FlatPosition;

		Disturb+=FlatPosition*0.0*randhash (MyIndex)*SmoothCurve (ttime-24);



	Disturb*=0.4;
	//*(1+1.0*pow(randhash (MyIndex),60.0));
		float fttime=ttime*1.1;
	recl=0.5+0.5*sin(fMyIndex*0.001+fttime*0.15)-3+SmoothCurve ((fttime-1)*0.1)*1.5
		+((0.5*sin(fttime*0.3+SUV.x*6.0)))+SmoothCurve ((fttime-15)*0.1);
	


	float 	recl2=0.5+0.5*sin(fMyIndex*0.1+fttime*0.15)- 1.2-0.7*pow(clamp (sin(ttime*1.0+fMyIndex*0.0001),0.0,1.0),1.0); // <- wobble	
	//if (MyIndex%10<9) recl2=0.0;
	recl2=-5+11.3*sin(fMyIndex*0.1+fttime*0.25);
	recl2=0+1.1*sin(fMyIndex*0.1+fttime*0.25);
	recl2+=randhash (MyIndex)+PosY;

	recl2=0+3.1*sin(fMyIndex*0.0001+fttime*0.1)*randhash (MyIndex)*2.0;
	recl2+=13*SmoothCurve((ttime-44.25)*0.25);
	
	//recl2-=1.0;
	//recl2-=5.0*sin (clamp (ttime-28,0.0,1.0)*3.14159);
	//if (ttime>41) recl2+=clamp ((ttime-41)*0.6,0.0,100.0);
	
	//clamp (ttime-20,0.0,1.0);

recl2=clamp (recl2,0.0,1.0);
	//recl=recl2;
	//recl=recl2;
//	recl-=SmoothCurve ((fttime-20)*0.2)*1.0;
	recl+=pow(length (FlatPosition.xyz),1.0)*4;
		recl+=(recl2-recl)*	SmoothCurve ((ttime-22)*0.4);;

	
	recl=clamp (recl,0.0,1.0);
		recl=1-recl;


C=RotateNow (1.5*(1-recl),0,0);

if (MyIndex%120000<20000)
	FlatPosition.xyz=C*FlatPosition.xyz;


//Disturb*=0.0;
vec3 PlanetPos;


PlanetPos=vec3 (0.0,sin(theta),cos(theta))*0.3*0.7*float(int(phi*8.0));
PlanetPos=0.4*OriginalPositionTexture_Bird;


//if (MyIndex%1000==0) 	PlanetPos=randhash3 (MyIndex*5)*7.0;


//PlanetPos=randhash3 (MyIndex)*vec3 (1.0,1.0,1.0);
//PlanetPos=normalize(PlanetPos)*0.3;


//PlanetPos.y=abs(PlanetPos.y);
//PlanetPos*=5.0*fbm( PlanetPos*6.42 );
//PlanetPos+=vec3 (0,1.7,0);

	 
	 vec3 OriPos=PlanetPos;
//PlanetPos.xyz/=length (PlanetPos.xyz);
PlanetPos*=2.0;


float cccc=1.0;

//if (ttime>18) 
{ 
	float rotspeed=
		SmoothCurve ((ttime-26)*0.2);
	//rotspeed-=SmoothCurve ((ttime-40)*0.2);

	//rotspeed=1;

	float rotpos=(ttime-26)*4.0+float(MyIndex%15)*0.1;
// rotpos-=clamp ((ttime-41)*4.0+float(MyIndex%5)*0.01,0.0,10000.0);

	C=RotateNow (ttime*0,MegaRotate*2+float(MyIndex%350)*0.00,ttime*0.0);
	//if (ttime>40) C=RotateNow (0,0,0);
//PlanetPos=C*PlanetPos;

float TheDist=length (Positions[MyIndex].xyz-PlanetPos);


//C=RotateNow (0,(1-recl)*0+TheDist*5,0);
//if (MyIndex%10!=0) 
	PlanetPos=C*PlanetPos;


PlanetPos+=vec3 (5,0,0);



if (ttime>23)
if (MyIndex%10000<300)
	//if (ttime>36)
		//if (ttime<37)
{
		mat3 C2;
	C2=RotateNow (0,0.1,3.14159/2.0);
	C=RotateNow (ttime*0,MegaRotate*1+float(MyIndex%350)*0.0,ttime*0.0);
		FlatPosition=C2*FlatPosition.xyz;
			FlatPosition=C*FlatPosition.xyz;
	PlanetPos.xyz=FlatPosition.xyz*4+vec3 (5,0,0);
cccc=0.0;

		}

//if (ttime>33) PlanetPos+=vec3 (10,0,0);
//PlanetPos.y+=-5.0*randhash(MyIndex)*clamp ((ttime-25-randhash (MyIndex*4)*10.0),0.0,1000.0);

//C=RotateNow (0,ttime,0);
//PlanetPos=C*PlanetPos;
};



C=RotateNow (0.5*(1-recl),0,0);
float interp2;
 interp2=SmoothCurve ((fttime-18-10+phi*10.0)*0.2);
 interp2=1*SmoothCurve ((fttime-20+length (FlatPosition.xyz)*7.1)*0.8);
 interp2=1*SmoothCurve ((fttime-25-float(MyIndex%100)/100.0*0.0)*0.1);
 //interp2=SmoothCurve ((fttime-18-float(length (Positions[MyIndex].xzy))*3)*0.4);
 //interp2-=1*SmoothCurve ((fttime-43-float(MyIndex%10000)/10000.0*2.0)*0.5);
 
 interp2=clamp (interp2,0.0,1.0);

FlatPosition+=(PlanetPos-FlatPosition)*interp2;


//recl-=interp2*1.3;
/*
recl=1.0;
recl-=pow(clamp (float(int(length (OriPos.xyz)*8))/8.0-PosY,0.0,1.0),100.0);
Disturb.y+=1.0;
*/




//Disturb*=1+interp2*5.0;

//recl+=interp2*0.5;
	recl=clamp (recl,0.0,1.0);
	
	//recl=1;

	float fm=fMyIndex*0.000001;
	
	
	Disturb*=1-0.0*SmoothCurve ((ttime-49)*0.1);
	





	vec3 NewObject;

	NewObject=randhash3(MyIndex);
	NewObject=normalize (NewObject);
	NewObject=vec3 (0,SUV.x,SUV.y)*2.0;
	float fininter=SmoothCurve ((ttime-50-randhash (MyIndex)*0.0)*100000.25);
	fininter=0.0;
	//if (ttime>50) fininter=1.0;
	
	FlatPosition+=((NewObject+vec3 (6.0,0.0,0.0))-FlatPosition)*fininter;
//recl+=fininter;
//recl=clamp (recl,0.0,0.8);
//fininter;
	//fclmp2=1.0;
float	fclmp=1.0;



//fclmp*=ccc;
//fclmp+=fclmp2;

//if (ttime>53+length (SUV.xy)*3.0) {
if (ttime>1150) {

	float recl3=0.5+0.5*sin(fMyIndex*0.0005+fttime*0.02)-3+SmoothCurve ((fttime-1)*0.1)*1.5
		+((0.5*sin(fttime*0.3+SUV.x*2.0*SUV.y*3.0)))+5.0*(1-0.7*SmoothCurve((ttime-50)*0.3));
	//recl3*=0.1;
	//recl3-=1.2;
	//if (MyIndex%10000<8000) 		recl3=10;
	
	recl+=(recl3-recl)*SmoothCurve ((ttime-50)*0.3);
	
	if (length (SUV.xy)<0.41)
	recl=0.7;


 	Disturb=NewObject*1;
	//Disturb.y+=2.0;
Disturb+=GetCurl (vec3 (ttime*0.00)+0.06*Positions[MyIndex].xyz)*0.1;
	Disturb+=GetCurl (vec3 (ttime*0.01)+0.11*Positions[MyIndex].xyz)*0.2;

	Disturb.x=abs(Disturb.x);
	Disturb.x=+1.0;
	//Disturb.y=+4.0;
	
	//Disturb*=10.0;
	if (MyIndex%10000<300) 
	//if (length (SUV.xy)<0.5-0*SmoothCurve ((ttime-50)*0.005))
	{
	//recl=10.0;	
		Disturb*=0.0;
		fclmp=0;
	}
	


	
	recl=clamp (recl,0.0,1.0);


};





if (ttime>600) { 


	if (MyIndex%10000<7000) { 

		int ttm=int((ttime-55-fMyIndex*0.0000001)*1.0);
		
		C=RotateNow (0,ttime*2,0);
		vec3 SpP=OriginalPositionTexture_Bird*0.4;
		FlatPosition=SpP+vec3 (10+PosY,0,0);
		FlatPosition=C*FlatPosition;
		FlatPosition+=randhash3 (ttm+(MyIndex/(10+ttm))%ttm)*4.0;
	FlatPosition=vec3 (0,SUV.x,SUV.y)+vec3 (PosY,0,0);

recl=0.0+0.0*sin(fMyIndex*0.01);
recl=clamp ((ttime-60)*0.1,0.0,1.0);
//+0.1*sin(fMyIndex*0.001+ttime);
recl=clamp (recl,0.0,1.0);
	}

	//else		recl=0.0;

};




	//FlatPosition*=fbm( FlatPosition*2.0 )+fbm (FlatPosition*1.0);

	
	
	//recl=clamp (10.0*PosY-fm*5.0,0.0,1.0);
	
	//if (fMyIndex*0.000001>PosY) recl=0.0; else recl=1.0;


	//FlatPosition.xyz+=(FlatPosition.zyx-FlatPosition.xyz)*SmoothCurve ((ttime-20-fMyIndex*0.000001)*4.5);
	
	Positions[MyIndex].xyz+=Disturb*DeltaT;
	Positions[MyIndex].xyz+=(FlatPosition-Positions[MyIndex].xyz)*recl;

	float fz=1.0;
//C=RotateNow (0,-1.0*DeltaT*fz*SmoothCurve ((ttime-24)*0.1),-DeltaT*0.0*fz*SmoothCurve ((ttime-24)*0.0));

	
	float MegaRotate2=SmoothCurve ((ttime-24)*0.1);
	 MegaRotate2-=SmoothCurve ((ttime-44)*0.17);
	C=RotateNow (0,-1.0*DeltaT*MegaRotate2*0.5,0);
//fz*SmoothCurve ((ttime-24)*0.1),-DeltaT*0.0*fz*SmoothCurve ((ttime-24)*0.0));

	Positions[MyIndex].xyz=C*Positions[MyIndex].xyz;

	//+=vec3(100.0);
	//+=(FlatPosition-Positions[MyIndex].xyz)*recl;
	
		float fcolor=texture (Swirl_Texture,SUV2+vec2 (0.5)).x;
		 //fcolor+=texture (Swirl_Texture,vec2 (0.001,0.0)+SUV2+vec2 (0.5)).x;
		// fcolor+=texture (Swirl_Texture,vec2 (0.003,0.0.003)+SUV2+vec2 (0.5)).x;
		 //fcolor+=texture (Swirl_Texture,vec2 (0.0,0.0.003)+SUV2+vec2 (0.5)).x;
//		 fcolor*=0.5;

		 if (fcolor<0.5) fcolor=0.0; else fcolor=1.0;
		//if (fcolor<0.15) Positions[MyIndex].x=vec3 (2000.0);
		float fccx=1.0-recl;
		fccx=1.0-pow (abs(1.0-fccx),10.0);
		fccx*=0.7;		
		fcolor+=(randhash(MyIndex/100000)-fcolor)*fccx;
//		fcolor+=(1-fcolor)*fccx;
		//if (ttime>50)		fcolor=texture (Swirl_Texture,SUV2+vec2 (0.5)).x;
	//fcolor=0.0;
	Colors[MyIndex].x=(1-recl);
//vec3 OriginalPositionTexture_Bird=1.0*texture (OriginalPositionTexture_Bird,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	Positions[MyIndex].w=0.5*fcolor+0*(1-recl)*(0.5+0.5*sin(4.0*ttime+fMyIndex*0.00001))*pow (randhash (MyIndex),10.0);
	
fclmp*=cccc;

	Colors[MyIndex].x*=fclmp;

	//Positions[MyIndex].w=0.3;

	float fcc=SmoothCurve ((ttime-23)*0.5);
	Positions[MyIndex].w*=(1-0.5*recl*fcc)*(1+0*fcc);
	
	//Positions[MyIndex].w+=fcolor*SmoothCurve (ttime-50);

	
	//*recl;
	//	Positions[MyIndex].w+=(0.0+2.0*clamp (length (Disturb.xyz)/DeltaT*2.0,0.0,0.5))*clamp (ttime*0.1,0.0,1.0)*(1.0-fi);

	imageStore(destTexPos, storePos, Positions[MyIndex]);
	imageStore(destTexCol, storePos, Colors[MyIndex]);
}
