//#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;

//uniform image2D destTexPos;
//uniform image2D destTexCol;

layout (binding=0) writeonly uniform image2D destTexPos;
//layout (binding=1) writeonly uniform image2D destTexVel;
layout (binding=2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture; 
//uniform sampler2D ColorTexture; 
uniform sampler3D CurlTexture; 

uniform sampler2D OriginalPositionTexture; 
uniform sampler2D OriginalColorTexture; 
uniform sampler2D OriginalPositionTextureLogo;

uniform mat4 RotationMatrix;
uniform mat4 RotationMatrix2;

layout (local_size_x = 16, local_size_y = 16) in;

layout (std140, binding=4) buffer Pos { vec4 Positions[]; }; 
//layout (std140, binding=5) buffer Vel { vec4 Velocities[]; }; 
layout (std140, binding=6) buffer Col { vec4 Colors[]; }; 
float breaktime=18.0;

const float InverseMaxInt = 1.0 / 4294967295.0;


float randhash(uint seed, float b)
{
    uint i=(seed^12345391u)*2654435769u;
    i^=(i<<6u)^(i>>26u);
    i*=2654435769u;
    i+=(i<<5u)^(i>>12u);
    return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
float x=randhash (seed,1.0)-0.5;
float y=randhash (seed+413,1.0)-0.5;
float z=randhash (seed*2+12,1.0)-0.5;
return vec3(x,y,z);

};

vec3 GetCurl (vec3 Pos) { 

return texture3D (CurlTexture,vec3 (-2.5)+Pos.xyz).xyz;
};







#define INVOCATION_SIZE (512)
void main() {



	

	unsigned int MyIndex=gl_GlobalInvocationID.x+gl_GlobalInvocationID.y*INVOCATION_SIZE;

	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
		


		float _PosY=(ttime-5.0);
	_PosY=clamp (_PosY,0.0,10.0);
	_PosY=PosY;

	//Positions[MyIndex].xyz+=GetCurl (vec3 (ttime*0.01)+0.01*Positions[MyIndex].xyz)*10.0*DeltaT;
	
	vec3 OriginalPos=0.5*texture2D (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/1536.0)).xyz;
	vec4 OrPos=OriginalPos.xyzz;
	OrPos.w=1.0;
	
	//OrPos=(RotationMatrix*OrPos);
	

	//OriginalPos.y+=PosY;
	
	float original_posy=OriginalPos.y;
	
	//OriginalPos.y+=ttime*2.0;

	//OriginalPos.y-=3.5;
	//OriginalPos.xyz=vec3 (0,6.0,0);
	float fc;

	
	
	
	vec3 Disturb=GetCurl (vec3 (ttime*0.00)+0.23*Positions[MyIndex].xyz)*0.2*DeltaT;
	Disturb+=GetCurl (vec3 (ttime*0.0)+0.11*Positions[MyIndex].xyz)*0.2*DeltaT;
	Disturb+=vec3 (-2.0,0,0.0)*DeltaT*0.7;
//Disturb+=Positions[MyIndex].xyz*DeltaT*0.4;

	//Disturb*=0.0;
	



	vec3 FlatPosition;


	float _ftime=ttime*0.2;
		_ftime=clamp (ttime*1-1.0,0.0,80.0);
	float fi;
	

	
	float recl;
	vec3 OldDisturb=Disturb;
	float rff=randhash (MyIndex*5,1.0);
	

	vec3 LastPos=Positions[MyIndex].xyz;
			
	

	recl+=fi;

	Colors[MyIndex].z=0.0;

	//recl=1.0;

	
		 
		 
	vec3 	FlatPositionLogo=vec3 (0,1.0,0)+0.15*texture2D (OriginalPositionTextureLogo,vec2(storePos.x,storePos.y)*(1.0/512.0)).xyz;

	//FlatPositionLogo*=2.0;

	 	FlatPosition=0.25*texture2D (OriginalPositionTexture,vec2(storePos.x,storePos.y)*(1.0/512.0)).xyz;
	OrPos=FlatPosition.xyzz;
	OrPos.w=1.0;

	OrPos=(RotationMatrix*OrPos);
	OriginalPos.xyz=OrPos.xyz;


	vec4 OrPos2=FlatPosition.xyzz;
	OrPos2.w=1.0;
	OrPos2=(RotationMatrix2*OrPos2);
	float ftt=clamp (-FlatPosition.y*0.3,0.0,1.0);
	OriginalPos.xyz=(OrPos2+(OrPos-OrPos2)*ftt).xyz;
	
	//float fshow=clamp ((ttime-32)*0. ,0.0,1.0);

	FlatPosition.xyz=OriginalPos*vec3 ( 1.0,1.2,1.0)+vec3 (0.0,2.5,0.0);

	//FlatPosition.y-=clamp ((ttime-53)*0.1,0.0,10000.0);
	vec3 NowPos=Positions[MyIndex].xyz;
	
	recl=clamp(PosY*0.2+0.1*sin (ttime*0.1+float(MyIndex)*0.0001),0.0,1.0);
	Positions[MyIndex].xyz+=Disturb.xyz;
	float fxxx=pow (randhash (MyIndex*3,1.0),8.0);
	//+1.0;
	 
	//if (ttime>2.0) 
	float fcc=0.2+0.2*sin(float(FlatPosition.y)*1.1+3.0+ttime*0.0+float (MyIndex)*0.0000);
	 fcc=1.0-(float(FlatPosition.y-0.3)*1.3);
	//float fcc=1.0;
	fcc=clamp (fcc,0.0,1.0);
	//fcc+=1-clamp ((ttime-52)*0.5,0,1);
	//fcc=1-fcc;
//	fcc=0.02;
	
	float fcc2=clamp ((ttime-52-float(MyIndex)*0.00010+1.0*float(FlatPosition.y-0.3)*1.3)*0.6,0.0,1.0);
	fcc2=clamp ((ttime-60-float(MyIndex)*0.00000+1.0*float(FlatPositionLogo.y)*1.3)*0.6,0.0,1.0);
	//Positions[MyIndex].xyz+=

//	Positions[MyIndex].xyz+=(FlatPositionLogo.xyz-Positions[MyIndex].xyz)*fcc2;
 
	fcc=0.3+0.28*sin(float(MyIndex)*0.003+ttime*0.5+float (MyIndex)*0.0000);
	//fcc=0.0+0.0*sin(float(MyIndex)*0.03+ttime*0.5+float (MyIndex)*0.0000);
	//fcc*=fcc2;
	fcc=1.0;
	FlatPosition.y+=clamp ((ttime-56)*0.5,0.0,10000);
	fcc2=1.0;
	FlatPositionLogo.xyz=randhash3 (MyIndex)*10.0;
	//+vec3 (0,-50,0);
	//FlatPosition.xyz+=(FlatPositionLogo.xyz-FlatPosition.xyz)*fcc2;
	//fcc=PosY;
	//fcc+=clamp (1-fcc2*9.0,0.0,1.0);
	fcc=clamp (fcc,0.0,1.0);
	Positions[MyIndex].xyz+=(FlatPosition-Positions[MyIndex].xyz)*fcc;
	Positions[MyIndex].w=fcc;

	//Positions[MyIndex].xyz=FlatPosition.xyz;
	//-4.0*fcc;
	/*
	{ 

if (randhash (MyIndex,1.0)*20.0>clamp (ttime-52.0,0.0,10000.0))
{
	Positions[MyIndex].xyz+=(FlatPosition-Positions[MyIndex].xyz)*1.0;
Positions[MyIndex].w=0.0;
}
else
{
	Positions[MyIndex].xyz+=Disturb.xyz;
	Positions[MyIndex].w+=1.0*DeltaT;

}
	};

	*/






	Colors[MyIndex].x=0;
		//Positions[MyIndex].w=0;
	//	Positions[MyIndex].w+=(0.0+2.0*clamp (length (Disturb.xyz)/DeltaT*2.0,0.0,0.5))*clamp (ttime*0.1,0.0,1.0)*(1.0-fi);
	
	imageStore(destTexPos, storePos, Positions[MyIndex]);
	//imageStore(destTexCol, storePos, Colors[MyIndex]);
}
