
uniform float time;
uniform vec3 mouse;
uniform vec3 resolution;

uniform vec3 CamPos;
uniform vec3 CamDir;
uniform float PosY;
//uniform vec2 resolution;

// hash

float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

// noise

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);

    f = f*f*(3.0-2.0*f);
    float n = p.x + p.y*57.0 + 113.0*p.z;
    return mix(mix(mix( hash(n+  0.0), hash(n+  1.0),f.x),
                   mix( hash(n+ 57.0), hash(n+ 58.0),f.x),f.y),
               mix(mix( hash(n+113.0), hash(n+114.0),f.x),
                   mix( hash(n+170.0), hash(n+171.0),f.x),f.y),f.z);
}

// map


vec4 map( in vec3 p )
{
	//altitude
	float d = -0.005 - p.y + sin(time) / 4.0;
	d=0.05-p.y;
	//wind
	vec3 q = p - vec3(-0.4,0.0,sin(time)/1500.0 - 0.5) * time*0.1;
	 q = p - vec3(1.0,0.0,0.0) * time*-0.4;
	if (time>52)
	 q = p - vec3(1.0,0.0,0.0) * time*0.1;


	 float f;
	q*=4.8;
    f  = 0.5000*noise( q ); q = q*2.02;
    f += 0.2500*noise( q ); q = q*2.03;
    f += 0.1250*noise( q ); q = q*2.01;
    f += 0.0625*noise( q );
	//f=pow(f,1.2);
	//density
	d += 4.0 * f;

	d = clamp( d, 0.0, 1.0 );
	
	vec4 res = vec4( d );

	// diffuse is here actually
//	res.xyz = mix( 1.15*vec3(1.0,0.95,0.8), vec3(0.7,0.7,0.7), res.x );
	res.xyz = mix( 1.1*vec3(1.0,1.1,1.2), vec3(0.7,0.7,0.7), res.x );
	
	return res;
}

// sundir

vec3 sundir = vec3(-1.0,-1.0,0.0);

// raymarch
float steps=0.0;

vec4 raymarch( in vec3 ro, in vec3 rd )
{
	vec4 sum = vec4(0, 0, 0, 0);
		//ro.xy+=CamPos.xy*10.0;
	ro.x-=CamPos.z;
	float t = 0.0;
	for(int i=0; i<22; i++)
	{
		
		if( sum.a > 0.99 ) continue;
		steps+=0.1;
		vec3 pos = ro + t*rd;
		vec4 col = map( pos );
		
		#if 1
		float dif =  clamp((col.w - map(pos+0.3*sundir).w)/0.6, 0.0, 1.0 );
		float constrast = 0.5;
		//fake for now, but will change soon
		vec3 skylighting = vec3(0.4,0.48,1.2)*0.1 + 0.0 ;
		vec3 sunlighting = vec3(1.0,1.0,1.0)*0.7 + 0.0;
    
		
		vec3 lin = sunlighting + skylighting;
		col.xyz *= lin;
		col.xyz *= pow(col.xyz, vec3(constrast));
		#endif
		
		col.a *= 0.25;
		col.rgb *= col.a;

		sum = sum + col*(1.0 - sum.a);	

        #if 0
		t += 0.1;
		#else
		t += max(0.1,0.02*t)*1.0;
		#endif
	}

	sum.xyz /= (0.001+sum.w);

	return clamp( sum, 0.0, 1.0 );
}


void main( void ) {
	
	vec2 _resolution=vec2 (600)*1.5;
	//1920.0,1280.0);

					
					_resolution.x*=resolution.x/1280.0;
	_resolution.y*=resolution.y/720.0;


	vec2 q = gl_FragCoord.xy/ _resolution.xy;
	vec2 p = -1.0 + 2.0*q;
	p.x *= _resolution.x/ _resolution.y;
	vec2 mo = -1.0 + 2.0 / _resolution.xy;
	
	    // camera
    	vec3 ro = 4.0*normalize(vec3(cos(4.00-1.5*mo.x), 0.7+(mo.y+1.0), sin(2.75-3.0*mo.x)));
    	 ro = 2.2*normalize(vec3(mo.x+2.0, (mo.y+5), 4.0*mo.x));

		
		vec3 ta = vec3(0.0, 0.0, 1.0);
    	vec3 ww = normalize( ta - ro);
    	vec3 uu = normalize(cross( vec3(0.0,1.0,0.0), ww ));
    	vec3 vv = normalize(cross(ww,uu));
    	vec3 rd = normalize( p.x*uu*1.0 + p.y*vv*1.0 + 1.0*ww );
	
	vec4 res = raymarch( ro, rd );

	float sun = clamp( dot(sundir,rd), 0.0, 1.0 );
	vec3 col = vec3(0.6,0.63,0.7) - rd.y*0.2*vec3(0.5,0.5,1.0) + 0.1 * 0.8;
	col += vec3(1.3,1.22,0.65)*sun * 0.6;
	col *= 0.95;
	
	col = mix( col, res.xyz, res.w );
	if (time<36)
	col += 0.3*vec3(0.745,0.6,0.2)*pow( 0.5+sun, 1.0 );
	if (time>36)
	if (time<52)
		col += 0.2*vec3(0.4,1.2,0.8)*pow( 0.0+sun, 1.0 );
	


	
	//col += 0.4*vec3(0.4,0.4,0.4)*pow( 1.0-sun, 1.0 );
	col *= col;
	col = col;
	
	gl_FragColor = vec4( col, 1.0 );

	float fc=1.0-clamp (1.4*(steps-5.3),0.0,1.0);
	fc+=0.0;
	//fc=0.3;
fc=1.0;
if (steps<6.0) 
	fc=0.0;
fc=1.0-q.y-0.44;
fc=clamp (fc,0.0,1.0);

fc=1.0-1.0*pow(1.0-fc-gl_FragColor.x*0.5,1.0);


if (time>52) 
fc=1.0-1.0*q.y+gl_FragColor.x+PosY;

//gl_FragColor.xyz*=gl_FragColor.xyz;
//fc=1;
float fcc=0.15+clamp ((time-9-(1-q.x)*3.0)*0.2,0.0,1.0);
 fcc=clamp (fcc,0.0,1.0);
 fcc-=clamp ((time-16-(1-q.x)*3.0)*0.2,0.0,1.0);
 fcc+=clamp ((time-40)*0.2,0.0,1.0);
 fcc-=clamp ((time-46-(1-q.x)*0.0)*1.0,0.0,1.0);
 //c+=clamp ((time-52)*0.5,0.0,1.0);
 fcc=clamp (fcc,0.0,1.0);
 //fcc=1.0;
//fc=1.0;
gl_FragColor.w=fc*1.6*fcc;

gl_FragColor*=clamp (time*1.3,0.0,1.0);
	//gl_FragColor.w=clamp (1.0-steps*0.1,0.0,1.0);
}