


varying vec4 position;
uniform sampler2D PositionTexture; 
varying vec4 thecolor;
uniform sampler2D OriginalColorTexture; 
uniform sampler2D ColorTexture; 
uniform float DeltaT;
uniform float ttime;
uniform float ResolutionMultiplier;
uniform float alltime;

const float InverseMaxInt = 1.0 / 4294967295.0;


float randhash(uint seed, float b)
{
	uint i=(seed^12345391u)*2654435769u;
	i^=(i<<6u)^(i>>26u);
	i*=2654435769u;
	i+=(i<<5u)^(i>>12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3 (uint seed) { 
	float x=randhash (uint(seed),1.0)-0.5;
	float y=randhash (uint(seed+413),1.0)-0.5;
	float z=randhash (uint(seed*2+12),1.0)-0.5;
	return vec3(x,y,z);

};



void main()
{

	vec4 glVertex= gl_Vertex;
	int rnd=gl_VertexID;
	int MyIndex=rnd;
	int poss=int(rnd);
	int x=poss%1536;
	int y=poss/1536;

	// get current position from positionTexture
	glVertex.xyz=texture2D (PositionTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;


	vec3 GPUColors=texture2D (ColorTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;
	float SizeW=texture2D (PositionTexture,0.9999*vec2 (float(x),float(y))/1536.0).w;
	//SizeW=1.0;
	vec3 OriginalColors=texture2D (OriginalColorTexture,0.9999*vec2 (float(x),float(y))/1536.0).xyz;
	glVertex.w=1.0;
	gl_Position =  glVertex;
	position=gl_Position.xyzw;


	float fstop=clamp ((ttime-30)*0.12,0.0,1.0);



	gl_Position = gl_ModelViewProjectionMatrix *position;
	thecolor=vec4 (0.2,0.3,0.2,1.0);
	gl_PointSize=1.0;

	thecolor.xyz=OriginalColors.xyz*0.6*vec3 (0.2,0.4,0.5);

	thecolor.xyz=GPUColors;



	//if (ttime>1000)
	{ 


		if (poss%63111==0){
			gl_PointSize=clamp (SizeW*0.5,0.0,1.0)*randhash (MyIndex,1.0)*30.0*(0.5+0.5*sin(ttime*2.0*randhash (MyIndex*3,1.0)));;
			thecolor*=0;
			//			thecolor+=(2.0*vec4 (1.8,0.7,0.3,1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (MyIndex*3,1.0)));

		}


		if (poss%245==0){
			gl_PointSize=2.0+clamp (SizeW*0.5,0.0,1.0)*randhash (MyIndex,1.0)*100.0*(0.5+0.5*sin(ttime*2.0*randhash (MyIndex*3,1.0)));;
			thecolor+=thecolor*(4.0*vec4 (1.0)-thecolor)*clamp (SizeW,0.0,1.0)*(0.5+0.5*sin(ttime*5.0*randhash (MyIndex*3,1.0)));
		}
	}






	if (poss%23313==0){
		gl_PointSize*=5.0*randhash (MyIndex*42,1.0);
	}


	//thecolor=vec4 (1.0);
	thecolor*=vec4 (1.0-pow(gl_Position.z*0.07,1.0))*0.8*vec4 (1.0,1.1,1.2,1.0);
	//thecolor*=0.5+0.5*sin(float (MyIndex)*0.02);
	//thecolor*=vec4 (0.5+0.25*sin(15.0*(1.0-pow(gl_Position.z*0.07,1.0))));
	thecolor.w=texture2D (ColorTexture,0.9999*vec2 (float(x),float(y))/1536.0).w;



float fdsp3=sin (+0.0+0.25*0.5*2*3.1415926*alltime*100.0/60.0+float (MyIndex)*0.0000005);
fdsp3=clamp (fdsp3,0.0,1.0);
fdsp3=pow (fdsp3,1.0);

if (gl_PointSize>2.0)
gl_PointSize*=1+fdsp3*1.0;
if (ttime>5.0)
{ 
//gl_PointSize*=1+fdsp3*13.0;
//thecolor*=1+fdsp3*3.0*vec4 (0.3,0.6,1.0,1.0);
thecolor+=(thecolor.x*3.0*vec4 (1.0,0.6,0.4,1.0)-thecolor)*fdsp3;
//thecolor+=(thecolor.x*2.0*vec4 (0.6,0.9,0.8,1.0)-thecolor)*fdsp3;
}





thecolor*=0.4;



	gl_PointSize*=1+0.3*(1.0-pow(gl_Position.z*0.07,2.0));
		gl_PointSize *=ResolutionMultiplier;
gl_PointSize=clamp (gl_PointSize,1.0,3000.0);
		//thecolor=vec4 (1.0);
	//texture2D (PositionTexture,vec2 (float(x),float(y))/1024.0).w;
}