﻿//Variables related to audio
//This audio info is related to No Fear
var Music = function(){

  var m = {
    //beats per minute
    bpm : 140,
    //seconds per beat
    spb : 1/(140/60),
    //how many seconds per bar
    barLength : 4 * (1/(140/60)),
    beats_per_bar : 4,
    bars_total : 75,
    currentBeat : 0,
    
    tics_per_beat : 4,
  };
  m.duration = m.bars_total * m.barLength;
  
  m.syncPoints ={
    introStart  : m.barLength,
    verse1Start : m.barLength*9,
    fill        : m.barLength*25,
    chorusStart : m.barLength*26,
    chorusMiddle: m.barLength*34,
    verse2Start : m.barLength*42,
    modulation  : m.barLength*58,
    verse3Start : m.barLength*66,
    endingStart : m.barLength*70,
    lastBeat    : m.barLength*74,
    end         : m.barLength*74+m.barLength*0.5
  };
  
  var beats = new Array(m.bars_total*m.beats_per_bar);
  var tics = new Array(m.bars_total*m.beats_per_bar*m.tics_per_beat);
  
  var createBeats = function(){
    for(var i = 0; i < beats.length; ++i){
      beats[i] = i*m.spb;
    }
  };
  
  var createTics = function(){
    for(var j = 0; j < tics.length; ++j){
      tics[j] = j*(m.spb/m.tics_per_beat);
    }
  }
  createBeats();
  createTics();
  
  var currentTic = 0;
  var prevTic = 0;
  var onTic = function(time){
    if(currentTic < tics.length){
      if(time >= tics[currentTic]){
        prevTic = currentTic;
        currentTic++;
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return false;
    }
  };
  
  var currentBeat = 0;
  var prevBeat = 0;
  m.onBeat = function(time){
    if(currentBeat < beats.length){
      var tic = onTic(time);
      if(time >= beats[currentBeat]){
        prevBeat = currentBeat;
        currentBeat++;
        return {on: true, beat : prevBeat%4, count: prevBeat, onTic: tic, tic: prevTic%4};
      }
      else{
        return {on: false, beat : prevBeat%4, count: prevBeat, onTic : tic, tic: prevTic%4};
      }
    }
    else{
      return false;
    }
  };
  
  
  
  return m;
};

MUSIC = Music();