var Shadercubes = function(){
  PartBase.call(this);
  this.initScene();
};

Shadercubes.prototype = PartBase.prototype.inheritance();

Shadercubes.prototype.initScene = function(){
  PartBase.prototype.initScene.call(this);

  this.camera.position.set(0., 0., 200.);
  this.createThings();
//  this.shader2();


};

Shadercubes.prototype.animate = function(timeStep, elapsedTime){
  PartBase.prototype.animate.call(this, timeStep, elapsedTime);

  
  this.objcontainer.rotation.y += 0.02;

  if((this.elapsed > MUSIC.barLength*2 && this.elapsed< MUSIC.barLength*2+MUSIC.spb) ||(this.elapsed > MUSIC.barLength*4-MUSIC.spb && this.elapsed< MUSIC.barLength*4) 
  ||(this.elapsed > MUSIC.barLength*6-MUSIC.spb && this.elapsed< MUSIC.barLength*6+MUSIC.spb)) {
    
    for (var i = 0; i<this.cubearr.length; i++) {
       this.cubearr[i].position.x += Math.random()*20 - 10;
       this.cubearr[i].position.y += Math.random()*10 - 5;
       this.cubearr[i].position.z += Math.random()*10 - 5;  
       
    }
  }
  
  if(this.elapsed>MUSIC.barLength*14) { 
    for(var i = 0; i<this.cubearr.length; i++) {
    
      if(this.cubearr[i].position.x != this.cubepositions[i].x || 
      this.cubearr[i].position.y != this.cubepositions[i].y || 
      this.cubearr[i].position.z != this.cubepositions[i].z) {
        var xdiff = this.cubepositions[i].x - this.cubearr[i].position.x;
        var ydiff = this.cubepositions[i].y - this.cubearr[i].position.y;
        var zdiff = this.cubepositions[i].z - this.cubearr[i].position.z;

        this.cubearr[i].position.x += xdiff*0.06;
        this.cubearr[i].position.y += ydiff*0.06;
        this.cubearr[i].position.z += zdiff*0.06;
        

      } 
      
    }
  }
  
  this.uniforms.time.value = (1+(this.elapsed-timeStep)*0.75);
  this.uniforms.gtime.value = this.elapsed;
};


/*Shadercubes.prototype.shader2 = function() {
  this.uniforms =  {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)}
    
  };
  
  this.planeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniforms,
      vertexShader: document.getElementById( 'basic_vertex' ).textContent,
      fragmentShader: document.getElementById( 'circles_fragment' ).textContent,
      side : THREE.DoubleSide
  });
  
  this.plane = new THREE.Mesh(new THREE.PlaneGeometry(TDEMO.width, TDEMO.height), this.planeMaterial);  
  this.scene.add(this.plane);
  this.plane.position.z = -50;

}*/

Shadercubes.prototype.createThings = function() {

  
  this.cubepositions = [];
  
  this.uniforms =  {
    time : {type : "f", value: 0.0},
    resolution : {type : "v2", value: new THREE.Vector2(TDEMO.width, TDEMO.height)},
    gtime : {type : "f", value: 0.0},
    barLength : {type : "f", value: MUSIC.barLength}
  };
  
  this.planeMaterial = new THREE.ShaderMaterial({
      uniforms: this.uniforms,
      vertexShader: document.getElementById( 'basic_vertex' ).textContent,
      fragmentShader: document.getElementById( 'circles_fragment' ).textContent
//      side : THREE.DoubleSide
  });

  this.objcontainer = new THREE.Object3D()
  this.scene.add(this.objcontainer);

  var cubeSize = 21;

  this.cube2 = new THREE.Mesh(new THREE.BoxGeometry(cubeSize, cubeSize, cubeSize), this.planeMaterial);
  this.cubearr = [];

  var startx = -30;
  var starty = 30;
  var startz = -30;

  for(var i = 0; i<3; i++) {
    startx=-30;
    for(var j = 0; j<3; j++) {
      startz = -30;
      for(var k = 0; k<3; k++) {
        var c = this.cube2.clone();
        c.position.x = startx;
        c.position.y = starty;
        c.position.z = startz;

        this.objcontainer.add(c);
        this.cubearr.push(c);
        this.cubepositions.push({x : c.position.x, y : c.position.y, z : c.position.z})
        startz +=30;
      }

      startx +=30;
    }
    starty -=30;

  }

};


