
uniform float time;
#ifdef vertex

in vec4 position;

uniform mat4 object_to_clip;
out float age, depth;

void main() {
	age = position.w;
	vec3 worldpos = (object_to_clip*vec4(position.xyz, 1.0)).xyz;
	gl_PointSize = 30.0*(position.w+.1);
	
	if(time>150.0) {
		worldpos.y += worldpos.z*2.0+.6;
		worldpos.z += .95;
	}
	depth = worldpos.z;
	gl_Position = vec4(worldpos.xy, worldpos.z-.75, 1.0);
}

#endif

#ifdef fragment

out vec4 out_color;
in float age, depth;

void main() {
	vec2 r = gl_PointCoord.xy-vec2(.5);
	if(length(r)>.5) discard;
	vec3 col = vec3(1.5, .7, .4);
	vec3 br = vec3(.0);
	float nage = age;
	if(time>150.0) {
		col = vec3(.15, .1, .9)*.5;
		br = vec3(.3, .4, .9);
		nage *= 1.1;
	}
	out_color = vec4(mix(br, col, clamp(nage*nage*nage, .0, 1.0))*smoothstep(5.0, -1.0, depth), 1.0);
}

#endif
