
uniform float time;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;
out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1 && time>.0f) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	pos.x *= 2.0;
	uv.x *= 2.0;
	pos.xyz = (object_to_clip*pos).xyz;
	pos.z += .6;
	gl_Position = vec4(pos.xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, akkuna1, akkuna2, akkuna3;

out vec4 out_color;

void main() {
	vec2 nuv = uv;
	if(uv.x>1.0 && time<148.0)
		nuv.x += -.02+time*.07+.07*2.0*smoothstep(138.0, 142.0, 140.0)*float(time<=140.0)-.07*float(time>140.0)*smoothstep(138.0, 142.0, time)*(time-142.0);
	vec4 col = texture(image, nuv*2.0);

	vec2 mod_uv = nuv*9.0;

	vec4 akkunasample = float(int(floor(mod_uv.y))==4)*max(
		texture(akkuna1, mod_uv)*float(int(floor((mod_uv)))%6==0),
		max(
		texture(akkuna2, mod_uv)*float(int(floor((mod_uv.x)))%6==2),
		texture(akkuna3, mod_uv)*float(int(floor((mod_uv.x)))%6==4)
		));

	if(mod_uv.x>101.2 && mod_uv.x<103.4)
		akkunasample = float(int(floor(mod_uv.y))==4||int(floor(mod_uv.y))==5)*texture(akkuna1, mod_uv*.5+vec2(.3, .1));

	if(akkunasample.r>akkunasample.b+.1)
		discard;

	if(akkunasample.w>.5)
		out_color = vec4(akkunasample.xyz*.3, 1.0);
	else {
		float depth = smoothstep(.4, .35, uv.y);
		out_color = vec4(mix(col, vec4(col.x+col.y+col.z)/3.0, .6+.4*depth).xyz*.3*(1.0-.7*depth), 1.0);
	}

}

#endif
