
uniform float scale;
#ifdef vertex

in vec2 position;
out vec2 uv;

void main() {
	uv = position*.5+vec2(.5);
	gl_Position = vec4(position, .0, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D primary, secondary, primary_bloom, secondary_bloom, kori;

out vec4 out_color, out_bloom;

void main() {
	out_color = mix(texture(primary, uv), texture(secondary, uv), clamp(textureLod(kori, uv, 1.5).x*2.0+scale*4.0-3.0 + smoothstep(.0, 1.0, uv.x), .0, 1.0));
	out_bloom = mix(texture(primary_bloom, uv), texture(secondary_bloom, uv), clamp(textureLod(kori, uv, 1.5).x*2.0+scale*4.0-3.0 + smoothstep(.0, 1.0, uv.x), .0, 1.0));
}

#endif
