
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;

out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	//pos.z *= .0001;
	gl_Position = vec4((object_to_clip*pos).xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, z_depth;

out vec4 out_color;
uniform float time;

void main() {
	vec2 nuv = uv+vec2(time*.1+.1*2.0*smoothstep(138.0, 142.0, 140.0)*float(time<=140.0)-.1*float(time>140.0)*smoothstep(138.0, 142.0, time)*(time-142.0), .0);
	vec4 col = texture(image, nuv);
	vec4 modify = texture(z_depth, nuv);
	if(modify.g<modify.r-.8)
		gl_FragDepth = .0;
	else
		gl_FragDepth = .5;
	out_color = vec4(col.xyz*.3, 1.0);
}

#endif
