
uniform float time;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;
out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1 && time>.0f) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	pos.xyz = (object_to_clip*pos).xyz;
	pos.z += .9;
	gl_Position = vec4(pos.xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, avaruus;

out vec4 out_color;

void main() {
	out_color = 
		mix(
		vec4(texture(image, uv-vec2(time*.02)*float(time>90.0)).xyz*min(1.0, .4+.6*smoothstep(.1, .3, uv.y))*min(1.0, .1+.9*smoothstep(.8, min(.75,.30+exp(25.5-time)), uv.y)), 1.0),
		vec4(texture(avaruus, uv*(2.0+2.0*float(time>111.33))-vec2(time*.02, .04)).xyz*.2, 1.0),
		smoothstep(100.0, 103.0, time));
}

#endif
