
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;

out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	pos.xyz = (object_to_clip*pos).xyz;
	pos.z += .5;
	gl_Position = vec4(pos.xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, mask;

uniform float time;

out vec4 out_color;

void main() {

	vec4 col = texture(image, uv);
	vec4 modify = texture(mask, uv);
	modify.r = pow(modify.r, 1.0/2.2);
	out_color = (modify.g<.5 && (30+modify.r*9.0<(time+1.3) && 30.4+modify.r*9.0>(time+1.3)))?col:vec4(.0);
}

#endif
