
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;

out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	//pos.z *= .001;
	gl_Position = vec4((object_to_clip*pos).xyz, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image, mask, bloomio;

uniform float load, time;

out vec4 out_color, out_bloom;

void main() {

	vec4 col = texture(image, uv);
	vec4 modify = texture(mask, uv);
	vec4 bloomsample = texture(bloomio, uv);
	if(bloomsample.x>bloomsample.z+.8)
		out_bloom = col;
	else
		out_bloom = vec4(.0);
	float a = clamp(pow(time*.32f, 8.0f), .0, 1.0);
	out_color = col;
}

#endif
