/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXEXTImportContext {
    public static final int GLX_SHARE_CONTEXT_EXT = 32778;
    public static final int GLX_VISUAL_ID_EXT = 32779;
    public static final int GLX_SCREEN_EXT = 32780;
    public final long GetCurrentDisplayEXT;
    public final long QueryContextInfoEXT;
    public final long GetContextIDEXT;
    public final long ImportContextEXT;
    public final long FreeContextEXT;

    public GLXEXTImportContext(FunctionProvider provider) {
        this.GetCurrentDisplayEXT = provider.getFunctionAddress("glXGetCurrentDisplayEXT");
        this.QueryContextInfoEXT = provider.getFunctionAddress("glXQueryContextInfoEXT");
        this.GetContextIDEXT = provider.getFunctionAddress("glXGetContextIDEXT");
        this.ImportContextEXT = provider.getFunctionAddress("glXImportContextEXT");
        this.FreeContextEXT = provider.getFunctionAddress("glXFreeContextEXT");
    }

    public static GLXEXTImportContext getInstance() {
        return GL.getCapabilities().__GLXEXTImportContext;
    }

    static GLXEXTImportContext create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_EXT_import_context")) {
            return null;
        }
        GLXEXTImportContext funcs = new GLXEXTImportContext(provider);
        boolean supported = Checks.checkFunctions(funcs.GetCurrentDisplayEXT, funcs.QueryContextInfoEXT, funcs.GetContextIDEXT, funcs.ImportContextEXT, funcs.FreeContextEXT);
        return GL.checkExtension("GLX_EXT_import_context", funcs, supported);
    }

    public static native long nglXGetCurrentDisplayEXT(long var0);

    public static long glXGetCurrentDisplayEXT() {
        long __functionAddress = GLXEXTImportContext.getInstance().GetCurrentDisplayEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLXEXTImportContext.nglXGetCurrentDisplayEXT(__functionAddress);
    }

    public static native int nglXQueryContextInfoEXT(long var0, long var2, int var4, long var5, long var7);

    public static int nglXQueryContextInfoEXT(long display, long context, int attribute, long value) {
        long __functionAddress = GLXEXTImportContext.getInstance().QueryContextInfoEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(context);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, value, __functionAddress);
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, MemoryUtil.memAddress(value));
    }

    public static int glXQueryContextInfoEXT(long display, long context, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLXEXTImportContext.nglXQueryContextInfoEXT(display, context, attribute, MemoryUtil.memAddress(value));
    }

    public static native long nglXGetContextIDEXT(long var0, long var2);

    public static long glXGetContextIDEXT(long context) {
        long __functionAddress = GLXEXTImportContext.getInstance().GetContextIDEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return GLXEXTImportContext.nglXGetContextIDEXT(context, __functionAddress);
    }

    public static native long nglXImportContextEXT(long var0, long var2, long var4);

    public static long glXImportContextEXT(long display, long contextID) {
        long __functionAddress = GLXEXTImportContext.getInstance().ImportContextEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLXEXTImportContext.nglXImportContextEXT(display, contextID, __functionAddress);
    }

    public static native void nglXFreeContextEXT(long var0, long var2, long var4);

    public static void glXFreeContextEXT(long display, long context) {
        long __functionAddress = GLXEXTImportContext.getInstance().FreeContextEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(context);
        }
        GLXEXTImportContext.nglXFreeContextEXT(display, context, __functionAddress);
    }
}

