/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.MemoryUtil;

final class MemoryAccess {
    private MemoryAccess() {
    }

    static MemoryAccessor getInstance() {
        MemoryAccessor accessor;
        try {
            accessor = MemoryAccess.loadAccessor("org.lwjgl.system.MemoryAccessSun$MemoryAccessorUnsafe");
        }
        catch (Exception e0) {
            try {
                accessor = new MemoryAccessorReflect();
            }
            catch (Exception e1) {
                LWJGLUtil.log("Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
                accessor = new MemoryAccessorJNI();
            }
        }
        return accessor;
    }

    private static MemoryAccessor loadAccessor(String className) throws Exception {
        return (MemoryAccessor)Class.forName(className).newInstance();
    }

    static Field getDeclaredField(Class<?> root, String fieldName) throws NoSuchFieldException {
        Class<?> type = root;
        while (true) {
            try {
                Field field = type.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException e) {
                if ((type = type.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName + " does not exist in " + root.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    static Field getField(Buffer buffer, Object value) throws NoSuchFieldException {
        Class<?> type = buffer.getClass();
        do {
            for (Field field : type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(buffer);
                    if (fieldValue != value) continue;
                    return field;
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        } while ((type = type.getSuperclass()) != null);
        throw new NoSuchFieldException(String.format("The specified value does not exist as a field in %s or any of its superclasses.", buffer.getClass().getSimpleName()));
    }

    private static final class MemoryAccessorReflect
    extends MemoryAccessorJava {
        private final Field address;
        private final Field capacity;
        private final Field cleaner;
        private final Field byteBufferParent;
        private final Field shortBufferParent;
        private final Field charBufferParent;
        private final Field intBufferParent;
        private final Field longBufferParent;
        private final Field floatBufferParent;
        private final Field doubleBufferParent;

        MemoryAccessorReflect() {
            try {
                this.address = MemoryAccess.getDeclaredField(Buffer.class, "address");
                this.capacity = MemoryAccess.getDeclaredField(Buffer.class, "capacity");
                ByteBuffer buffer = ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
                this.cleaner = MemoryAccess.getDeclaredField(buffer.getClass(), "cleaner");
                this.byteBufferParent = MemoryAccess.getField(buffer.slice(), buffer);
                this.shortBufferParent = MemoryAccess.getField(buffer.asShortBuffer(), buffer);
                this.charBufferParent = MemoryAccess.getField(buffer.asCharBuffer(), buffer);
                this.intBufferParent = MemoryAccess.getField(buffer.asIntBuffer(), buffer);
                this.longBufferParent = MemoryAccess.getField(buffer.asLongBuffer(), buffer);
                this.floatBufferParent = MemoryAccess.getField(buffer.asFloatBuffer(), buffer);
                this.doubleBufferParent = MemoryAccess.getField(buffer.asDoubleBuffer(), buffer);
            }
            catch (Exception e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public long getAddress(Buffer buffer) {
            try {
                return this.address.getLong(buffer);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        ByteBuffer newByteBuffer(long address, int capacity) {
            ByteBuffer buffer = this.newByteBuffer();
            try {
                this.address.setLong(buffer, address);
                this.capacity.setInt(buffer, capacity);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
            buffer.clear();
            return buffer;
        }

        private <T extends Buffer> T setup(T buffer, long address, int capacity, Field parentField) {
            try {
                this.address.setLong(buffer, address);
                this.capacity.setInt(buffer, capacity);
                parentField.set(buffer, null);
            }
            catch (IllegalAccessException e) {
                throw new UnsupportedOperationException(e);
            }
            buffer.clear();
            return buffer;
        }

        @Override
        ByteBuffer setupBuffer(ByteBuffer buffer, long address, int capacity) {
            if (LWJGLUtil.DEBUG) {
                try {
                    if (this.cleaner.get(buffer) != null) {
                        throw new IllegalArgumentException("Instances created through ByteBuffer.allocateDirect cannot be modified.");
                    }
                }
                catch (IllegalAccessException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            return this.setup(buffer, address, capacity, this.byteBufferParent);
        }

        @Override
        ShortBuffer setupBuffer(ShortBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.shortBufferParent);
        }

        @Override
        CharBuffer setupBuffer(CharBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.charBufferParent);
        }

        @Override
        IntBuffer setupBuffer(IntBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.intBufferParent);
        }

        @Override
        LongBuffer setupBuffer(LongBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.longBufferParent);
        }

        @Override
        FloatBuffer setupBuffer(FloatBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.floatBufferParent);
        }

        @Override
        DoubleBuffer setupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return this.setup(buffer, address, capacity, this.doubleBufferParent);
        }
    }

    static abstract class MemoryAccessorJava
    extends MemoryAccessor {
        protected final ByteBuffer globalBuffer = ByteBuffer.allocateDirect(0);

        MemoryAccessorJava() {
        }

        protected ByteBuffer newByteBuffer() {
            return this.globalBuffer.duplicate().order(ByteOrder.nativeOrder());
        }
    }

    private static final class MemoryAccessorJNI
    extends MemoryAccessor {
        private MemoryAccessorJNI() {
        }

        @Override
        long getAddress(Buffer buffer) {
            return MemoryUtil.nGetAddress(buffer);
        }

        @Override
        ByteBuffer newByteBuffer(long address, int capacity) {
            return MemoryUtil.nNewBuffer(address, capacity).order(ByteOrder.nativeOrder());
        }

        @Override
        ByteBuffer setupBuffer(ByteBuffer buffer, long address, int capacity) {
            return this.newByteBuffer(address, capacity);
        }

        @Override
        ShortBuffer setupBuffer(ShortBuffer buffer, long address, int capacity) {
            return this.newShortBuffer(address, capacity);
        }

        @Override
        CharBuffer setupBuffer(CharBuffer buffer, long address, int capacity) {
            return this.newCharBuffer(address, capacity);
        }

        @Override
        IntBuffer setupBuffer(IntBuffer buffer, long address, int capacity) {
            return this.newIntBuffer(address, capacity);
        }

        @Override
        LongBuffer setupBuffer(LongBuffer buffer, long address, int capacity) {
            return this.newLongBuffer(address, capacity);
        }

        @Override
        FloatBuffer setupBuffer(FloatBuffer buffer, long address, int capacity) {
            return this.newFloatBuffer(address, capacity);
        }

        @Override
        DoubleBuffer setupBuffer(DoubleBuffer buffer, long address, int capacity) {
            return this.newDoubleBuffer(address, capacity);
        }
    }

    static abstract class MemoryAccessor {
        MemoryAccessor() {
        }

        int getPageSize() {
            return 4096;
        }

        int getCacheLineSize() {
            return 64;
        }

        abstract long getAddress(Buffer var1);

        abstract ByteBuffer newByteBuffer(long var1, int var3);

        final ShortBuffer newShortBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 1).asShortBuffer();
        }

        final CharBuffer newCharBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 1).asCharBuffer();
        }

        final IntBuffer newIntBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 2).asIntBuffer();
        }

        final LongBuffer newLongBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 3).asLongBuffer();
        }

        final FloatBuffer newFloatBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 2).asFloatBuffer();
        }

        final DoubleBuffer newDoubleBuffer(long address, int capacity) {
            return this.newByteBuffer(address, capacity << 3).asDoubleBuffer();
        }

        abstract ByteBuffer setupBuffer(ByteBuffer var1, long var2, int var4);

        abstract ShortBuffer setupBuffer(ShortBuffer var1, long var2, int var4);

        abstract CharBuffer setupBuffer(CharBuffer var1, long var2, int var4);

        abstract IntBuffer setupBuffer(IntBuffer var1, long var2, int var4);

        abstract LongBuffer setupBuffer(LongBuffer var1, long var2, int var4);

        abstract FloatBuffer setupBuffer(FloatBuffer var1, long var2, int var4);

        abstract DoubleBuffer setupBuffer(DoubleBuffer var1, long var2, int var4);

        void memSet(long dst, int value, int bytes) {
            MemoryUtil.nMemSet(dst, value, bytes);
        }

        void memCopy(long src, long dst, int bytes) {
            MemoryUtil.nMemCopy(dst, src, bytes);
        }

        byte memGetByte(long ptr) {
            return MemoryUtil.nMemGetByte(ptr);
        }

        short memGetShort(long ptr) {
            return MemoryUtil.nMemGetShort(ptr);
        }

        int memGetInt(long ptr) {
            return MemoryUtil.nMemGetInt(ptr);
        }

        long memGetLong(long ptr) {
            return MemoryUtil.nMemGetLong(ptr);
        }

        float memGetFloat(long ptr) {
            return MemoryUtil.nMemGetFloat(ptr);
        }

        double memGetDouble(long ptr) {
            return MemoryUtil.nMemGetDouble(ptr);
        }

        long memGetAddress(long ptr) {
            return MemoryUtil.nMemGetAddress(ptr);
        }

        void memPutByte(long ptr, byte value) {
            MemoryUtil.nMemPutByte(ptr, value);
        }

        void memPutShort(long ptr, short value) {
            MemoryUtil.nMemPutShort(ptr, value);
        }

        void memPutInt(long ptr, int value) {
            MemoryUtil.nMemPutInt(ptr, value);
        }

        void memPutLong(long ptr, long value) {
            MemoryUtil.nMemPutLong(ptr, value);
        }

        void memPutFloat(long ptr, float value) {
            MemoryUtil.nMemPutFloat(ptr, value);
        }

        void memPutDouble(long ptr, double value) {
            MemoryUtil.nMemPutDouble(ptr, value);
        }

        void memPutAddress(long ptr, long value) {
            MemoryUtil.nMemPutAddress(ptr, value);
        }
    }
}

