/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class JSEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TIME;
    public static final int VALUE;
    public static final int TYPE;
    public static final int NUMBER;
    private final ByteBuffer struct;

    public JSEvent() {
        this(JSEvent.malloc());
    }

    public JSEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setTime(int time) {
        JSEvent.time(this.struct, time);
    }

    public void setValue(int value) {
        JSEvent.value(this.struct, value);
    }

    public void setType(int type) {
        JSEvent.type(this.struct, type);
    }

    public void setNumber(int number) {
        JSEvent.number(this.struct, number);
    }

    public int getTime() {
        return JSEvent.time(this.struct);
    }

    public int getValue() {
        return JSEvent.value(this.struct);
    }

    public int getType() {
        return JSEvent.type(this.struct);
    }

    public int getNumber() {
        return JSEvent.number(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int time, int value, int type, int number) {
        ByteBuffer js_event = JSEvent.malloc();
        JSEvent.time(js_event, time);
        JSEvent.value(js_event, value);
        JSEvent.type(js_event, type);
        JSEvent.number(js_event, number);
        return js_event;
    }

    public static void time(ByteBuffer js_event, int time) {
        js_event.putInt(js_event.position() + TIME, time);
    }

    public static void value(ByteBuffer js_event, int value) {
        js_event.putShort(js_event.position() + VALUE, (short)value);
    }

    public static void type(ByteBuffer js_event, int type) {
        js_event.put(js_event.position() + TYPE, (byte)type);
    }

    public static void number(ByteBuffer js_event, int number) {
        js_event.put(js_event.position() + NUMBER, (byte)number);
    }

    public static int time(ByteBuffer js_event) {
        return js_event.getInt(js_event.position() + TIME);
    }

    public static int value(ByteBuffer js_event) {
        return js_event.getShort(js_event.position() + VALUE);
    }

    public static int type(ByteBuffer js_event) {
        return js_event.get(js_event.position() + TYPE) & 0xFF;
    }

    public static int number(ByteBuffer js_event) {
        return js_event.get(js_event.position() + NUMBER) & 0xFF;
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = JSEvent.offsets(MemoryUtil.memAddress(offsets));
        TIME = offsets.get(0);
        VALUE = offsets.get(1);
        TYPE = offsets.get(2);
        NUMBER = offsets.get(3);
    }
}

