/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XkbKeyAliasRec
implements Pointer {
    public static final int SIZEOF;
    public static final int REAL;
    public static final int ALIAS;
    private final ByteBuffer struct;

    public XkbKeyAliasRec() {
        this(XkbKeyAliasRec.malloc());
    }

    public XkbKeyAliasRec(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setReal(ByteBuffer real) {
        XkbKeyAliasRec.realSet(this.struct, real);
    }

    public void setReal(CharSequence real) {
        XkbKeyAliasRec.real(this.struct, real);
    }

    public void setAlias(ByteBuffer alias) {
        XkbKeyAliasRec.aliasSet(this.struct, alias);
    }

    public void setAlias(CharSequence alias) {
        XkbKeyAliasRec.alias(this.struct, alias);
    }

    public void getReal(ByteBuffer real) {
        XkbKeyAliasRec.realGet(this.struct, real);
    }

    public String getRealString() {
        return XkbKeyAliasRec.realString(this.struct);
    }

    public void getAlias(ByteBuffer alias) {
        XkbKeyAliasRec.aliasGet(this.struct, alias);
    }

    public String getAliasString() {
        return XkbKeyAliasRec.aliasString(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer real, ByteBuffer alias) {
        ByteBuffer xkbkeyaliasrec = XkbKeyAliasRec.malloc();
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, real);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, alias);
        return xkbkeyaliasrec;
    }

    public static ByteBuffer malloc(CharSequence real, CharSequence alias) {
        ByteBuffer xkbkeyaliasrec = XkbKeyAliasRec.malloc();
        XkbKeyAliasRec.real(xkbkeyaliasrec, real);
        XkbKeyAliasRec.alias(xkbkeyaliasrec, alias);
        return xkbkeyaliasrec;
    }

    public static void realSet(ByteBuffer xkbkeyaliasrec, ByteBuffer real) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(real);
            Checks.checkBufferGT(real, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(real), MemoryUtil.memAddress(xkbkeyaliasrec) + (long)REAL, real.remaining());
    }

    public static void real(ByteBuffer xkbkeyaliasrec, CharSequence real) {
        MemoryUtil.memEncodeASCII(real, false, xkbkeyaliasrec, REAL);
    }

    public static void aliasSet(ByteBuffer xkbkeyaliasrec, ByteBuffer alias) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(alias);
            Checks.checkBufferGT(alias, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(alias), MemoryUtil.memAddress(xkbkeyaliasrec) + (long)ALIAS, alias.remaining());
    }

    public static void alias(ByteBuffer xkbkeyaliasrec, CharSequence alias) {
        MemoryUtil.memEncodeASCII(alias, false, xkbkeyaliasrec, ALIAS);
    }

    public static void realGet(ByteBuffer xkbkeyaliasrec, ByteBuffer real) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(real, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeyaliasrec) + (long)REAL, MemoryUtil.memAddress(real), real.remaining());
    }

    public static String realString(ByteBuffer xkbkeyaliasrec) {
        return MemoryUtil.memDecodeASCII(xkbkeyaliasrec, 4, REAL);
    }

    public static void aliasGet(ByteBuffer xkbkeyaliasrec, ByteBuffer alias) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(alias, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeyaliasrec) + (long)ALIAS, MemoryUtil.memAddress(alias), alias.remaining());
    }

    public static String aliasString(ByteBuffer xkbkeyaliasrec) {
        return MemoryUtil.memDecodeASCII(xkbkeyaliasrec, 4, ALIAS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XkbKeyAliasRec.offsets(MemoryUtil.memAddress(offsets));
        REAL = offsets.get(0);
        ALIAS = offsets.get(1);
    }
}

