/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.Matrix4f;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.GL20;

public class GLSLProgram {
    public static final int VERTEX_ATTRIB = 0;
    public static final int UV_COORDS_ATTRIB = 1;
    public static final int NORMAL_COORDS_ATTRIB = 2;
    public static final int UV_COORDS_ATTRIB_2D = 1;
    private final int programID;
    private Map<String, Integer> locationCache = new HashMap<String, Integer>();

    public GLSLProgram(String vertex, String fragment) {
        this.programID = GLSLProgram.load(vertex, fragment);
    }

    public int getUniform(String name) {
        if (this.locationCache.containsKey(name)) {
            return this.locationCache.get(name);
        }
        int result = GL20.glGetUniformLocation(this.programID, name);
        if (result == -1) {
            System.err.println("Could not find uniform variable'" + name + "'!");
        } else {
            this.locationCache.put(name, result);
        }
        return GL20.glGetUniformLocation(this.programID, name);
    }

    public void setUniform1i(String name, int value) {
        GL20.glUniform1i(this.getUniform(name), value);
    }

    public void setUniform2f(String name, float x, float y) {
        GL20.glUniform2f(this.getUniform(name), x, y);
    }

    public void setUniform3f(String name, Vector3f vector) {
        GL20.glUniform3f(this.getUniform(name), vector.x, vector.y, vector.z);
    }

    public void setUniformMat4f(String name, Matrix4f matrix) {
        GL20.glUniformMatrix4fv(this.getUniform(name), false, matrix.toFloatBuffer());
    }

    public void enable() {
        GL20.glUseProgram(this.programID);
    }

    public void disable() {
        GL20.glUseProgram(0);
    }

    public void free() {
        GL20.glDeleteProgram(this.programID);
    }

    public static int load(String vertPath, String fragPath) {
        String vert = Utilities.loadAsString(vertPath);
        String frag = Utilities.loadAsString(fragPath);
        int program = GL20.glCreateProgram();
        int vertID = GL20.glCreateShader(35633);
        int fragID = GL20.glCreateShader(35632);
        GL20.glShaderSource(vertID, (CharSequence)vert);
        GL20.glShaderSource(fragID, (CharSequence)frag);
        GL20.glCompileShader(vertID);
        if (GL20.glGetShaderi(vertID, 35713) == 0) {
            System.err.println("Failed to compile vertexd shader!");
            System.err.println(GL20.glGetShaderInfoLog(vertID));
        }
        GL20.glCompileShader(fragID);
        if (GL20.glGetShaderi(fragID, 35713) == 0) {
            System.err.println("Failed to compile fragment shader!");
            System.err.println(GL20.glGetShaderInfoLog(fragID));
        }
        GL20.glAttachShader(program, vertID);
        GL20.glAttachShader(program, fragID);
        GL20.glLinkProgram(program);
        GL20.glValidateProgram(program);
        GL20.glDetachShader(program, vertID);
        GL20.glDetachShader(program, fragID);
        GL20.glDeleteShader(vertID);
        GL20.glDeleteShader(fragID);
        return program;
    }
}

