/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.Vec3;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.UnicodeFont;
import org.newdawn.slick.font.effects.ColorEffect;

public class OJ2D {
    private ArrayList<Save2D> save2D = new ArrayList();
    private HashMap<String, UnicodeFont> fonts = new HashMap();

    public void addFont(String name, Font font) {
        GL11.glDisable(3553);
        UnicodeFont unicodeFont = new UnicodeFont(font);
        unicodeFont.getEffects().add(new ColorEffect());
        unicodeFont.addAsciiGlyphs();
        try {
            unicodeFont.loadGlyphs();
        }
        catch (SlickException e) {
            JOptionPane.showMessageDialog(null, "OJ2D FONT : " + e.getMessage());
        }
        this.fonts.put(name, unicodeFont);
        GL11.glEnable(3553);
    }

    public void init() {
    }

    public void beginRender() {
        this.save2D.clear();
    }

    public void endRender() {
    }

    public void render() {
        int i = 0;
        while (i < this.save2D.size()) {
            Save2D s2D = this.save2D.get(i);
            switch (s2D.type) {
                case 1: {
                    this.fillRectRender(s2D.x, s2D.y, s2D.w, s2D.h, s2D.color);
                    break;
                }
                case 2: {
                    this.drawStringRender(s2D.x, s2D.y, s2D.s, s2D.uf, s2D.color);
                    break;
                }
                case 3: {
                    this.drawRectRender(s2D.x, s2D.y, s2D.w, s2D.h, s2D.color);
                    break;
                }
                case 4: {
                    this.drawLineRender(s2D.x, s2D.y, s2D.w, s2D.h, s2D.color);
                    break;
                }
                case 5: {
                    this.drawImageRender(s2D.x, s2D.y, s2D.w, s2D.h, s2D.texID);
                    break;
                }
                default: {
                    System.err.println("ogiltigt 2d render typ: " + s2D.type);
                }
            }
            ++i;
        }
    }

    public void drawString(int x, int y, String s, String font, Vec3 color) {
        UnicodeFont uf = this.fonts.get(font);
        if (uf != null) {
            this.save2D.add(new Save2D(2, x, y, s, uf, color));
        } else {
            System.err.println("fel font name");
        }
    }

    private void drawStringRender(int x, int y, String s, UnicodeFont uf, Vec3 color) {
        uf.drawString(x, y, s, new Color(color.x, color.y, color.z));
        GL11.glBindTexture(3553, 0);
    }

    public void fillRect(int x, int y, int w, int h, Vec3 color) {
        this.save2D.add(new Save2D(1, x, y, w, h, color));
    }

    private void fillRectRender(int x, int y, int w, int h, Vec3 color) {
        GL11.glColor3f(color.x, color.y, color.z);
        GL11.glBegin(7);
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x + w, y);
        GL11.glVertex2f(x + w, y + h);
        GL11.glVertex2f(x, y + h);
        GL11.glEnd();
    }

    public void drawRect(int x, int y, int w, int h, Vec3 color) {
        this.save2D.add(new Save2D(3, x, y, w, h, color));
    }

    private void drawRectRender(int x, int y, int w, int h, Vec3 color) {
        GL11.glColor3f(color.x, color.y, color.z);
        GL11.glBegin(1);
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(x + w, y);
        GL11.glVertex2f(x + w, y);
        GL11.glVertex2f(x + w, y + h);
        GL11.glVertex2f(x + w, y + h);
        GL11.glVertex2f(x, y + h);
        GL11.glVertex2f(x, y + h);
        GL11.glVertex2f(x, y);
        GL11.glEnd();
    }

    public void drawLine(int x, int y, int w, int h, Vec3 color) {
        this.save2D.add(new Save2D(4, x, y, w, h, color));
    }

    private void drawLineRender(int x, int y, int w, int h, Vec3 color) {
        GL11.glColor3f(color.x, color.y, color.z);
        GL11.glBegin(1);
        GL11.glVertex2f(x, y);
        GL11.glVertex2f(w, h);
        GL11.glEnd();
    }

    public void drawImage(int x, int y, int w, int h, int ID) {
        this.save2D.add(new Save2D(5, x, y, w, h, ID));
    }

    private void drawImageRender(int x, int y, int w, int h, int textureID) {
        GL11.glPushMatrix();
        Color.white.bind();
        GL11.glBindTexture(3553, textureID);
        GL11.glBegin(7);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex3f(x + w, y, 0.0f);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex3f(x, y, 0.0f);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex3f(x, y + h, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex3f(x + w, y + h, 0.0f);
        GL11.glEnd();
        GL11.glBindTexture(3553, 0);
        GL11.glPopMatrix();
    }

    private class Save2D {
        public static final int FILLRECT = 1;
        public static final int DRAWSTRING = 2;
        public static final int DRAWRECT = 3;
        public static final int DRAWLINE = 4;
        public static final int DRAWIMAGE = 5;
        public int type;
        public int x;
        public int y;
        public int w;
        public int h;
        public int texID;
        public Vec3 color;
        public String s;
        public UnicodeFont uf;

        public Save2D(int type, int x, int y, int w, int h, Vec3 color) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.color = color;
        }

        public Save2D(int type, int x, int y, String s, UnicodeFont uf, Vec3 color) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.s = s;
            this.uf = uf;
            this.color = color;
        }

        public Save2D(int type, int x, int y, int w, int h, int ID) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.texID = ID;
        }
    }
}

