/*
 * Decompiled with CFR 0.152.
 */
package editor;

import GLEngine.GLSLProgram;
import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.Texture;
import GLEngine.Vector3f;
import GLEngine.Window;
import editor.EntitiesPanel;
import editor.FileEntity;
import editor.FileHandler;
import editor.FileMap;
import editor.FileMapTile;
import editor.FileTile;
import editor.FileTileEntity;
import editor.MapPanel;
import editor.TilesPanel;
import game.Camera;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class Editor {
    private GLSLProgram activeProgram;
    private MeshBatch meshBatch;
    private Window window;
    private Camera camera = new Camera(null);
    private float fov = 70.0f;
    private State state = State.ENTITIES;
    private FileEntity selectedEntity = new FileEntity();
    private FileTile selectedTile = new FileTile();
    private FileHandler fileHandler;

    public Editor() {
        this.init();
        this.loop();
        this.free();
    }

    public void init() {
        this.window = new Window("Editor", 800, 800);
        this.window.init(900, 30, 1, false);
        this.activeProgram = new GLSLProgram("/shaders/vertex.vert", "/shaders/fragment.frag");
        this.initMeshBatch();
        this.camera.pos = new Vector3f(0.0f, 50.0f, 0.0f);
        this.camera.rot.x = -90.0f;
        this.fileHandler = new FileHandler();
        this.fileHandler.load();
        this.createFrame();
    }

    private void createFrame() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        JFrame frame = new JFrame();
        frame.setSize(1000, 1000);
        final JTabbedPane tab = new JTabbedPane();
        tab.addTab("Entities", new EntitiesPanel(this, this.fileHandler));
        tab.addTab("Tiles", new TilesPanel(this, this.fileHandler));
        tab.addTab("Map", new MapPanel(this, this.fileHandler));
        tab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (tab.getSelectedIndex() == 0) {
                    Editor.this.state = State.ENTITIES;
                } else if (tab.getSelectedIndex() == 1) {
                    Editor.this.state = State.TILES;
                } else if (tab.getSelectedIndex() == 2) {
                    Editor.this.state = State.MAP;
                }
            }
        });
        frame.add(tab);
        frame.setJMenuBar(this.createJFrameMenu());
        frame.setVisible(true);
    }

    private JMenuBar createJFrameMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        JMenuItem save = new JMenuItem("Save");
        save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        save.getAccessibleContext().setAccessibleDescription("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.print("Saving...");
                Editor.this.fileHandler.save();
                System.out.println("done");
            }
        });
        menu.add(save);
        menuBar.add(menu);
        return menuBar;
    }

    public void initMeshBatch() {
        this.meshBatch = new MeshBatch();
        this.meshBatch.init();
    }

    public void loop() {
        long tick = 0L;
        while (!this.window.shouldClose()) {
            long time0 = System.nanoTime();
            this.update(++tick);
            this.render(tick);
            long dt = System.nanoTime() - time0;
            if (tick % 60L != 0L) continue;
        }
    }

    private void update(long tick) {
        if (this.state != State.ENTITIES && this.state != State.TILES) {
        }
        this.updateInput();
    }

    private void updateInput() {
        InputHandler.update();
        this.window.pollEvents();
        if (InputHandler.down(256)) {
            this.window.setShouldClose(true);
        }
        float speed = 0.2f;
        if (InputHandler.down(264)) {
            this.camera.pos.x = (float)((double)this.camera.pos.x + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.z = (float)((double)this.camera.pos.z + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (InputHandler.down(265)) {
            this.camera.pos.x = (float)((double)this.camera.pos.x - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.z = (float)((double)this.camera.pos.z - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (InputHandler.down(262)) {
            this.camera.pos.z = (float)((double)this.camera.pos.z - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.x = (float)((double)this.camera.pos.x + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (InputHandler.down(263)) {
            this.camera.pos.z = (float)((double)this.camera.pos.z + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
            this.camera.pos.x = (float)((double)this.camera.pos.x - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
        }
        if (InputHandler.down(87)) {
            this.camera.rot.x += 1.0f;
        }
        if (InputHandler.down(83)) {
            this.camera.rot.x -= 1.0f;
        }
        if (InputHandler.down(65)) {
            this.camera.rot.y += 1.0f;
        }
        if (InputHandler.down(68)) {
            this.camera.rot.y -= 1.0f;
        }
        if (InputHandler.down(32)) {
            this.camera.pos.y += speed;
        }
        if (InputHandler.down(341)) {
            this.camera.pos.y -= speed;
        }
    }

    public void render(long tick) {
        GL11.glClear(16640);
        this.activeProgram.enable();
        GL13.glActiveTexture(33984);
        int textureUniform = this.activeProgram.getUniform("texSampler");
        GL20.glUniform1i(textureUniform, 0);
        int pv = this.activeProgram.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, this.getProjectionViewMatrix().toFloatBuffer());
        this.meshBatch.begin(this.activeProgram, this.camera, this.window);
        if (this.state == State.ENTITIES) {
            this.renderEntities();
        } else if (this.state == State.TILES) {
            this.renderTiles();
        } else if (this.state == State.MAP) {
            this.renderMap();
        }
        this.meshBatch.end();
        this.activeProgram.disable();
        this.window.swapBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap() {
        FileMap map = this.fileHandler.getMap();
        ArrayList<FileMapTile> arrayList = map.fileMapTiles;
        synchronized (arrayList) {
            for (FileMapTile fmt : map.fileMapTiles) {
                for (FileTileEntity fte : this.fileHandler.getFileTile((int)fmt.tileId).entities) {
                    FileEntity fe = this.fileHandler.getEntity(fte.entityId);
                    String objFile = "objfiles/" + fe.obj;
                    String texFile = "textures/" + fe.tex;
                    if (new File("src/" + objFile).exists() && new File("src/" + texFile).exists()) {
                        float tmp;
                        Vector3f pos = new Vector3f();
                        float centerx = (float)((double)this.fileHandler.getFileTile((int)fmt.tileId).sizeX / 2.0);
                        float centerz = (float)((double)this.fileHandler.getFileTile((int)fmt.tileId).sizeZ / 2.0);
                        float transx = (float)(fte.px - (double)centerx);
                        float transz = (float)(fte.pz - (double)centerz);
                        float a = fmt.rot * 90;
                        if (fmt.rot == 1) {
                            tmp = transz;
                            transz = transx;
                            transx = -tmp;
                        } else if (fmt.rot == 2) {
                            transx = -transx;
                            transz = -transz;
                        } else if (fmt.rot == 3) {
                            tmp = transz;
                            transz = -transx;
                            transx = tmp;
                        }
                        pos.x = (float)((double)(transx + centerx) + map.tileSize * (double)fmt.ix);
                        pos.z = (float)((double)(transz + centerz) + map.tileSize * (double)fmt.iz);
                        pos.y = (float)(fte.py + fmt.y);
                        this.meshBatch.render(Mesh.getMesh(objFile), new Texture((String)texFile).textureID, Matrix4f.translate(pos).multiply(Matrix4f.rotateY(a)));
                        continue;
                    }
                    System.err.println("Could not find files");
                }
            }
        }
    }

    private void renderTiles() {
        try {
            for (FileTileEntity fte : this.selectedTile.entities) {
                FileEntity fe = this.fileHandler.getEntity(fte.entityId);
                String objFile = "objfiles/" + fe.obj;
                String texFile = "textures/" + fe.tex;
                if (!new File("src/" + objFile).exists() || !new File("src/" + texFile).exists()) continue;
                this.meshBatch.render(Mesh.getMesh(objFile), new Texture((String)texFile).textureID, Matrix4f.translate(new Vector3f((float)fte.px, (float)fte.py, (float)fte.pz)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void renderEntities() {
        try {
            String objFile = "objfiles/" + this.selectedEntity.obj;
            String texFile = "textures/" + this.selectedEntity.tex;
            if (new File("src/" + objFile).exists() && new File("src/" + texFile).exists()) {
                this.meshBatch.render(Mesh.getMesh(objFile), new Texture((String)texFile).textureID, Matrix4f.identity());
            }
        }
        catch (Exception e) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void free() {
        this.activeProgram.free();
        this.meshBatch.free();
        this.window.destroy();
    }

    public Matrix4f getProjectionViewMatrix() {
        Matrix4f proj = Matrix4f.perspective(this.fov, this.window.getAspect(), 1.0f, 1000.0f);
        return proj.multiply(this.camera.getViewMatrix());
    }

    public static void main(String[] args) {
        new Editor();
    }

    public void setSelectedEntity(FileEntity entity) {
        this.selectedEntity = entity;
    }

    public void setSelectedTile(FileTile tile) {
        this.selectedTile = tile;
    }

    public void setCameraPositionXZ(int x, int z) {
        this.camera.pos.x = x;
        this.camera.pos.z = z;
        this.camera.rot.x = -90.0f;
        this.camera.rot.y = 0.0f;
        this.camera.rot.z = 0.0f;
    }

    public void zoomIn() {
        this.camera.pos.y -= 20.0f;
    }

    public void zoomOut() {
        this.camera.pos.y += 20.0f;
    }

    private static enum State {
        ENTITIES,
        TILES,
        MAP;

    }
}

