/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Editor;
import editor.FileEntity;
import editor.FileHandler;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EntitiesPanel
extends JPanel {
    public EntitiesPanel(final Editor editor, final FileHandler fileHandler) {
        final JList<FileEntity> entityList = new JList<FileEntity>();
        JLabel nameLabel = new JLabel("Name: ");
        this.add(nameLabel);
        final JTextField name = new JTextField("", 20);
        this.add(name);
        JLabel objLabel = new JLabel("OBJ File:");
        this.add(objLabel);
        final JTextField obj = new JTextField("", 20){

            @Override
            public void repaint() {
                if (this.getDocument() != null) {
                    this.setBackground(new File("src/objfiles/" + this.getText()).exists() ? Color.WHITE : Color.RED);
                }
                super.repaint();
            }
        };
        this.add(obj);
        JLabel texLabel = new JLabel("Texture File:");
        this.add(texLabel);
        final JTextField tex = new JTextField("", 20){

            @Override
            public void repaint() {
                if (this.getDocument() != null) {
                    this.setBackground(new File("src/textures/" + this.getText()).exists() ? Color.WHITE : Color.RED);
                }
                super.repaint();
            }
        };
        this.add(tex);
        JLabel colLabel = new JLabel("Collision (mesh, box, <meshFile>):");
        this.add(colLabel);
        final JTextField col = new JTextField("", 20);
        this.add(col);
        JLabel weightLabel = new JLabel("Weight (0 for static):");
        this.add(weightLabel);
        final JTextField weight = new JTextField("", 5);
        this.add(weight);
        JButton newButton = new JButton("New Entity");
        newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                fileHandler.addNewEmptyEntity();
                Vector<FileEntity> vec = fileHandler.getFileEntitiesCopy();
                entityList.setListData(vec);
                entityList.setSelectedIndex(vec.size() - 1);
            }
        });
        this.add(newButton);
        entityList.setListData(fileHandler.getFileEntitiesCopy());
        entityList.setSelectionMode(0);
        entityList.addListSelectionListener(new ListSelectionListener(){
            int prev = -1;

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                int sel = entityList.getSelectedIndex();
                if (this.prev != -1) {
                    FileEntity prevEntity = (FileEntity)entityList.getModel().getElementAt(this.prev);
                    prevEntity.name = name.getText();
                    prevEntity.obj = obj.getText();
                    prevEntity.tex = tex.getText();
                    try {
                        prevEntity.weight = Double.parseDouble(weight.getText());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    prevEntity.collision = col.getText();
                }
                name.setText(((FileEntity)entityList.getSelectedValue()).name);
                obj.setText(((FileEntity)entityList.getSelectedValue()).obj);
                tex.setText(((FileEntity)entityList.getSelectedValue()).tex);
                col.setText(((FileEntity)entityList.getSelectedValue()).collision);
                weight.setText("" + ((FileEntity)entityList.getSelectedValue()).weight);
                editor.setSelectedEntity((FileEntity)entityList.getSelectedValue());
                this.prev = sel;
            }
        });
        this.add(entityList);
    }
}

