/*
 * Decompiled with CFR 0.152.
 */
package editor;

import GLEngine.Mesh;
import GLEngine.Texture;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import editor.FileCustomerNode;
import editor.FileEntity;
import editor.FileMap;
import editor.FileMapTile;
import editor.FileTile;
import editor.FileTileEntity;
import editor.FileTrafficNode;
import entity.DynamicEntity;
import entity.Entity;
import game.TrafficInfo;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import javax.imageio.ImageIO;
import physics.Physics;

public class FileHandler {
    private ArrayList<FileEntity> fileEntities = new ArrayList();
    private ArrayList<FileTile> fileTiles = new ArrayList();
    private FileMap map = new FileMap();
    private boolean loaded = false;

    public synchronized void load() {
        this.loaded = true;
        InputStream in = Utilities.class.getResourceAsStream("/map/entities");
        Scanner s = new Scanner(in);
        s.useLocale(Locale.US);
        int id = 0;
        while (s.hasNext()) {
            FileEntity fe = new FileEntity();
            fe.name = this.nextLine(s);
            fe.obj = this.nextLine(s);
            fe.tex = this.nextLine(s);
            fe.collision = this.nextLine(s);
            fe.weight = Double.parseDouble(this.nextLine(s));
            fe.entityId = id++;
            this.fileEntities.add(fe);
        }
        s.close();
        in = Utilities.class.getResourceAsStream("/map/tiles");
        s = new Scanner(in);
        s.useLocale(Locale.US);
        id = 0;
        while (s.hasNext()) {
            FileTile ft = new FileTile();
            ft.name = this.nextLine(s);
            ft.sizeX = Integer.parseInt(this.nextLine(s));
            ft.sizeZ = Integer.parseInt(this.nextLine(s));
            int numNodes = Integer.parseInt(this.nextLine(s));
            int i = 0;
            while (i < numNodes) {
                String line = this.nextLine(s);
                String[] vals = line.split(" ");
                FileTrafficNode ftn = new FileTrafficNode(Float.parseFloat(vals[0]), Float.parseFloat(vals[1]), Integer.parseInt(vals[2]));
                ft.nodes.add(ftn);
                ++i;
            }
            int numEntities = Integer.parseInt(this.nextLine(s));
            int i2 = 0;
            while (i2 < numEntities) {
                FileTileEntity fte = new FileTileEntity(this);
                Scanner ls = new Scanner(this.nextLine(s));
                ls.useLocale(Locale.US);
                fte.entityId = ls.nextInt();
                fte.px = ls.nextDouble();
                fte.py = ls.nextDouble();
                fte.pz = ls.nextDouble();
                fte.rx = ls.nextDouble();
                fte.ry = ls.nextDouble();
                fte.rz = ls.nextDouble();
                fte.probability = ls.nextDouble();
                ls.close();
                ft.entities.add(fte);
                ++i2;
            }
            int numCustomerNodes = Integer.parseInt(this.nextLine(s));
            int i3 = 0;
            while (i3 < numCustomerNodes) {
                String line = this.nextLine(s);
                String[] vals = line.split(" ");
                FileCustomerNode fcn = new FileCustomerNode(Float.parseFloat(vals[0]), Float.parseFloat(vals[1]), Float.parseFloat(vals[2]));
                ft.customerNodes.add(fcn);
                ++i3;
            }
            ft.minimap = this.nextLine(s);
            ft.tileId = id++;
            this.fileTiles.add(ft);
        }
        s.close();
        in = Utilities.class.getResourceAsStream("/map/map");
        s = new Scanner(in);
        s.useLocale(Locale.US);
        this.map.tileSize = Double.parseDouble(this.nextLine(s));
        while (s.hasNext()) {
            String line = this.nextLine(s);
            Scanner ls = new Scanner(line);
            ls.useLocale(Locale.US);
            FileMapTile fmt = new FileMapTile();
            fmt.tileId = ls.nextInt();
            fmt.ix = ls.nextInt();
            fmt.iz = ls.nextInt();
            fmt.y = ls.nextDouble();
            fmt.rot = ls.nextInt();
            this.map.fileMapTiles.add(fmt);
            ls.close();
        }
    }

    public String getEntityName(int entityId) {
        return this.fileEntities.get((int)entityId).name;
    }

    public synchronized void save() {
        if (!this.loaded) {
            throw new RuntimeException("Load must be called before save");
        }
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter("src/map/entities", false)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saveEntities(pw);
        pw.close();
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter("src/map/tiles", false)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saveTiles(pw);
        pw.close();
        try {
            pw = new PrintWriter(new BufferedWriter(new FileWriter("src/map/map", false)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.saveMap(pw);
        pw.close();
    }

    private void saveEntities(PrintWriter pw) {
        for (FileEntity fe : this.fileEntities) {
            pw.println(fe.name);
            pw.println(fe.obj);
            pw.println(fe.tex);
            pw.println(fe.collision);
            pw.println(fe.weight);
            pw.println();
        }
    }

    private void saveTiles(PrintWriter pw) {
        for (FileTile ft : this.fileTiles) {
            pw.println(ft.name);
            pw.println(ft.sizeX);
            pw.println(ft.sizeZ);
            pw.println(ft.nodes.size());
            for (FileTrafficNode ftn : ft.nodes) {
                pw.print(String.valueOf(ftn.x) + " ");
                pw.print(String.valueOf(ftn.z) + " ");
                pw.print(ftn.prev);
                pw.println();
            }
            pw.println(ft.entities.size());
            for (FileTileEntity fte : ft.entities) {
                pw.print(String.valueOf(fte.entityId) + " ");
                pw.print(String.valueOf(fte.px) + " ");
                pw.print(String.valueOf(fte.py) + " ");
                pw.print(String.valueOf(fte.pz) + " ");
                pw.print(String.valueOf(fte.rx) + " ");
                pw.print(String.valueOf(fte.ry) + " ");
                pw.print(String.valueOf(fte.rz) + " ");
                pw.print(String.valueOf(fte.probability) + " ");
                pw.println();
            }
            pw.println(ft.customerNodes.size());
            for (FileCustomerNode fcn : ft.customerNodes) {
                pw.print(String.valueOf(fcn.px) + " ");
                pw.print(String.valueOf(fcn.py) + " ");
                pw.print(fcn.pz);
                pw.println();
            }
            pw.println(ft.minimap);
            pw.println();
        }
    }

    private void saveMap(PrintWriter pw) {
        pw.println(this.map.tileSize);
        for (FileMapTile fmt : this.map.fileMapTiles) {
            pw.print(String.valueOf(fmt.tileId) + " ");
            pw.print(String.valueOf(fmt.ix) + " ");
            pw.print(String.valueOf(fmt.iz) + " ");
            pw.print(String.valueOf(fmt.y) + " ");
            pw.print(String.valueOf(fmt.rot) + " ");
            pw.println();
        }
    }

    public synchronized BufferedImage createDynamicEntities(Physics physics, ArrayList<Entity> entities, TrafficInfo trafficInfo, ArrayList<Vector3f> customerNodes) {
        if (!this.loaded) {
            throw new RuntimeException("Load must be called before createDynamicEntities");
        }
        Random random = new Random(9365825L);
        double tileSize = this.map.tileSize;
        for (FileMapTile fmt : this.map.fileMapTiles) {
            javax.vecmath.Vector3f pos;
            int tileId = fmt.tileId;
            int ix = fmt.ix;
            int iz = fmt.iz;
            double y = fmt.y;
            int r = fmt.rot;
            for (FileTileEntity fte : this.fileTiles.get((int)tileId).entities) {
                if (random.nextDouble() > fte.probability) continue;
                FileEntity fe = this.fileEntities.get(fte.entityId);
                javax.vecmath.Vector3f pos2 = fte.getRotatedPos(fmt, this.fileTiles.get(tileId));
                pos2.x = (float)((double)pos2.x + (double)ix * tileSize);
                pos2.z = (float)((double)pos2.z + (double)iz * tileSize);
                pos2.y = (float)((double)pos2.y + fmt.y);
                javax.vecmath.Vector3f rot = new javax.vecmath.Vector3f(0.0f, 1.5707964f * (float)r, 0.0f);
                entities.add(new DynamicEntity(physics, pos2, rot, Mesh.getMesh("objfiles/" + fe.obj, 1.0f), fe.collision, new Texture((String)new StringBuilder((String)"textures/").append((String)fe.tex).toString()).textureID, fe.weight));
            }
            trafficInfo.newNodeBatch();
            for (FileTrafficNode ftn : this.fileTiles.get((int)tileId).nodes) {
                pos = ftn.getRotatedPos(fmt, this.fileTiles.get(tileId));
                pos.x = (float)((double)pos.x + (double)ix * tileSize);
                pos.z = (float)((double)pos.z + (double)iz * tileSize);
                trafficInfo.addIntermediateNode(pos, ftn.prev);
            }
            for (FileCustomerNode fcn : this.fileTiles.get((int)tileId).customerNodes) {
                pos = fcn.getRotatedPos(fmt, this.fileTiles.get(tileId));
                pos.x = (float)((double)pos.x + (double)ix * tileSize);
                pos.z = (float)((double)pos.z + (double)iz * tileSize);
                customerNodes.add(new Vector3f(pos.x, 1.0f, pos.z));
            }
        }
        int size = 16;
        for (FileMapTile fmt : this.map.fileMapTiles) {
            FileTile ft = this.fileTiles.get(fmt.tileId);
            int maxSize = Math.max(ft.sizeX, ft.sizeZ);
            size = Math.max(size, fmt.ix + maxSize);
            size = Math.max(size, fmt.iz + maxSize);
        }
        HashMap<String, BufferedImage> images = new HashMap<String, BufferedImage>();
        for (FileTile ft : this.fileTiles) {
            InputStream in = this.getClass().getResourceAsStream("/textures/minimap/" + ft.minimap);
            BufferedImage image = null;
            try {
                image = ImageIO.read(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            images.put(ft.minimap, image);
        }
        BufferedImage minimap = new BufferedImage(size, size, 2);
        Graphics g = minimap.getGraphics();
        for (FileMapTile fmt : this.map.fileMapTiles) {
            FileTile ft = this.fileTiles.get(fmt.tileId);
            BufferedImage img = (BufferedImage)images.get(ft.minimap);
            AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
            tx.translate(-img.getWidth(null), 0.0);
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            img = op.filter(img, null);
            AffineTransform identity = new AffineTransform();
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform trans = new AffineTransform();
            trans.setTransform(identity);
            trans.translate(fmt.iz, fmt.ix);
            trans.rotate(Math.toRadians(270 + 90 * fmt.rot), (double)img.getWidth() * 0.5, (double)img.getHeight() * 0.5);
            g2d.drawImage(img, trans, null);
        }
        return minimap;
    }

    private String nextLine(Scanner s) {
        while (s.hasNextLine()) {
            String c = s.nextLine();
            if (c.matches("\\s*") || c.matches("//.*")) continue;
            return c;
        }
        throw new RuntimeException("Could not find one more matching line");
    }

    public synchronized Vector<FileEntity> getFileEntitiesCopy() {
        Vector<FileEntity> vector = new Vector<FileEntity>();
        for (FileEntity fe : this.fileEntities) {
            vector.add(fe);
        }
        return vector;
    }

    public synchronized Vector<FileTile> getFileTilesCopy() {
        Vector<FileTile> vector = new Vector<FileTile>();
        for (FileTile ft : this.fileTiles) {
            vector.add(ft);
        }
        return vector;
    }

    public synchronized Vector<FileTileEntity> getFileTileEntitiesCopy(int tileId) {
        Vector<FileTileEntity> vector = new Vector<FileTileEntity>();
        for (FileTileEntity fte : this.fileTiles.get((int)tileId).entities) {
            vector.add(fte);
        }
        return vector;
    }

    public synchronized void addNewFileTileEntity(int selectedTile, int selectedEntity) {
        FileTileEntity fte = new FileTileEntity(this);
        fte.entityId = selectedEntity;
        this.fileTiles.get((int)selectedTile).entities.add(fte);
    }

    public synchronized void addNewEmptyTile() {
        FileTile fileTile = new FileTile();
        fileTile.tileId = this.fileTiles.size();
        this.fileTiles.add(fileTile);
    }

    public synchronized void addNewEmptyEntity() {
        FileEntity fileEntity = new FileEntity();
        this.fileEntities.add(fileEntity);
    }

    public synchronized FileEntity getEntity(int entityId) {
        return this.fileEntities.get(entityId);
    }

    public synchronized FileMap getMap() {
        return this.map;
    }

    public synchronized FileTile getFileTile(int tileId) {
        return this.fileTiles.get(tileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapTiles(Collection<FileMapTile> removedTiles) {
        ArrayList<FileMapTile> arrayList = this.map.fileMapTiles;
        synchronized (arrayList) {
            this.map.fileMapTiles.removeAll(removedTiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileMapTile(FileMapTile newTile) {
        ArrayList<FileMapTile> arrayList = this.map.fileMapTiles;
        synchronized (arrayList) {
            this.map.fileMapTiles.add(newTile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapTile(FileMapTile removedTile) {
        ArrayList<FileMapTile> arrayList = this.map.fileMapTiles;
        synchronized (arrayList) {
            this.map.fileMapTiles.remove(removedTile);
        }
    }

    public synchronized void clearNodes(FileTile fileTile) {
        if (fileTile != null) {
            fileTile.nodes.clear();
        }
    }
}

