/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.FileHandler;
import editor.FileMapTile;
import editor.FileTile;
import javax.vecmath.Vector3f;

class FileTileEntity {
    int entityId;
    double px;
    double py;
    double pz;
    double rx;
    double ry;
    double rz;
    double probability = 1.0;
    FileHandler fileHandler;

    public FileTileEntity(FileHandler fh) {
        this.fileHandler = fh;
    }

    public String toString() {
        return "TileEntity: " + (this.fileHandler == null ? "?" : this.fileHandler.getEntityName(this.entityId));
    }

    public Vector3f getRotatedPos(FileMapTile fmt, FileTile ft) {
        Vector3f pos = new Vector3f();
        float centerx = (float)((double)ft.sizeX / 2.0);
        float centerz = (float)((double)ft.sizeZ / 2.0);
        float transx = (float)(this.px - (double)centerx);
        float transz = (float)(this.pz - (double)centerz);
        if (fmt.rot == 1) {
            float tmp = transz;
            transz = transx;
            transx = -tmp;
        } else if (fmt.rot == 2) {
            transx = -transx;
            transz = -transz;
        } else if (fmt.rot == 3) {
            float tmp = transz;
            transz = -transx;
            transx = tmp;
        }
        pos.x = transx + centerx;
        pos.z = transz + centerz;
        pos.y = (float)this.py;
        return pos;
    }
}

