/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Editor;
import editor.FileHandler;
import editor.FileMapTile;
import editor.FileTile;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class MapPanel
extends JPanel {
    private Editor editor;
    private FileHandler fileHandler;
    private JPanel mapPanel;
    private JList<FileTile> tileList;
    private int mapSize = 1000;
    private int tileDrawSize = 7;
    private int camIndexX = 0;
    private int camIndexZ = 0;
    private int rot = 0;
    private FileMapTile[][] map = new FileMapTile[this.mapSize][this.mapSize];

    public MapPanel(Editor editor, FileHandler fileHandler) {
        this.editor = editor;
        this.fileHandler = fileHandler;
        this.add(this.createInfoPanel());
        this.mapPanel = this.createMapPanel();
        JButton focus = new JButton("Edit");
        focus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapPanel.this.mapPanel.requestFocusInWindow();
            }
        });
        this.add(focus);
        this.add(this.mapPanel);
    }

    private JPanel createInfoPanel() {
        JPanel panel = new JPanel();
        JLabel objLabel = new JLabel("Tile size:");
        panel.add(objLabel);
        JTextField obj = new JTextField("", 20);
        panel.add(obj);
        this.tileList = new JList();
        this.tileList.setListData(this.fileHandler.getFileTilesCopy());
        JScrollPane tileListScroller = new JScrollPane(this.tileList);
        tileListScroller.setPreferredSize(new Dimension(400, 300));
        this.add(tileListScroller);
        return panel;
    }

    private JPanel createMapPanel() {
        final JPanel map = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                MapPanel.this.paintMap(g);
            }
        };
        map.setPreferredSize(new Dimension(600, 600));
        map.setBackground(Color.BLACK);
        map.setFocusable(true);
        map.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int sel;
                if (e.getKeyCode() == 38) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.camIndexZ = mapPanel.camIndexZ - 1;
                }
                if (e.getKeyCode() == 40) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.camIndexZ = mapPanel.camIndexZ + 1;
                }
                if (e.getKeyCode() == 37) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.camIndexX = mapPanel.camIndexX - 1;
                }
                if (e.getKeyCode() == 39) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.camIndexX = mapPanel.camIndexX + 1;
                }
                if (e.getKeyCode() == 17 && MapPanel.this.tileDrawSize <= 20) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.tileDrawSize = mapPanel.tileDrawSize + 1;
                    MapPanel.this.editor.zoomIn();
                }
                if (e.getKeyCode() == 16 && MapPanel.this.tileDrawSize >= 3) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.tileDrawSize = mapPanel.tileDrawSize - 1;
                    MapPanel.this.editor.zoomOut();
                }
                if (e.getKeyCode() == 32) {
                    MapPanel.this.addSelectedTile();
                }
                if (e.getKeyCode() == 83) {
                    sel = MapPanel.this.tileList.getSelectedIndex();
                    MapPanel.this.tileList.setSelectedIndex((sel + 1) % MapPanel.this.tileList.getModel().getSize());
                    MapPanel.this.mapPanel.requestFocusInWindow();
                }
                if (e.getKeyCode() == 87) {
                    sel = MapPanel.this.tileList.getSelectedIndex();
                    int newIndex = sel - 1 == -1 ? MapPanel.this.tileList.getModel().getSize() - 1 : sel - 1;
                    MapPanel.this.tileList.setSelectedIndex(newIndex);
                    MapPanel.this.mapPanel.requestFocusInWindow();
                }
                if (e.getKeyCode() == 82) {
                    MapPanel mapPanel = MapPanel.this;
                    mapPanel.rot = mapPanel.rot + 1;
                    MapPanel mapPanel2 = MapPanel.this;
                    mapPanel2.rot = mapPanel2.rot % 4;
                }
                if (e.getKeyCode() == 68) {
                    MapPanel.this.deleteTile();
                }
                MapPanel.this.synchWithEditor();
            }
        });
        new Thread(){

            @Override
            public void run() {
                MapPanel.this.populateMap();
                while (true) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    map.repaint();
                }
            }
        }.start();
        return map;
    }

    private void deleteTile() {
        FileMapTile removedTile = this.map[this.camIndexX][this.camIndexZ];
        if (removedTile != null) {
            int removeRadius = 100;
            int x = this.camIndexX - removeRadius;
            while (x < this.camIndexX + 2 * removeRadius) {
                int z = this.camIndexZ - removeRadius;
                while (z < this.camIndexZ + 2 * removeRadius) {
                    if (x >= 0 && x < this.map.length && z >= 0 && z < this.map[0].length && this.map[x][z] != null && removedTile == this.map[x][z]) {
                        this.map[x][z] = null;
                    }
                    ++z;
                }
                ++x;
            }
            this.fileHandler.removeMapTile(removedTile);
        }
    }

    private void addSelectedTile() {
        int tmp;
        FileTile selectedTile = this.tileList.getSelectedValue();
        FileMapTile newTile = new FileMapTile();
        newTile.tileId = selectedTile.tileId;
        newTile.rot = this.rot;
        int hx1 = (int)Math.floor((double)selectedTile.sizeX / 2.0);
        int hx2 = (int)Math.ceil((double)selectedTile.sizeX / 2.0);
        int hz1 = (int)Math.floor((double)selectedTile.sizeZ / 2.0);
        int hz2 = (int)Math.ceil((double)selectedTile.sizeZ / 2.0);
        int x1 = -hx1;
        int z1 = -hz1;
        int x2 = hx2;
        int z2 = hz2;
        int rot = newTile.rot;
        if (rot == 1) {
            tmp = z1;
            z1 = x1;
            x1 = -tmp;
        } else if (rot == 2) {
            x1 = -x1;
            z1 = -z1;
        } else if (rot == 3) {
            tmp = z1;
            z1 = -x1;
            x1 = tmp;
        }
        if (rot == 1) {
            tmp = z2;
            z2 = x2;
            x2 = -tmp;
        } else if (rot == 2) {
            x2 = -x2;
            z2 = -z2;
        } else if (rot == 3) {
            tmp = z2;
            z2 = -x2;
            x2 = tmp;
        }
        int xStart = Math.min(x1 += this.camIndexX, x2 += this.camIndexX);
        int w = Math.max(x1, x2) - xStart;
        int zStart = Math.min(z1 += this.camIndexZ, z2 += this.camIndexZ);
        int h = Math.max(z1, z2) - zStart;
        newTile.ix = xStart;
        newTile.iz = zStart;
        HashSet<FileMapTile> removedTiles = new HashSet<FileMapTile>();
        int x = xStart;
        while (x < xStart + w) {
            int z = zStart;
            while (z < zStart + h) {
                removedTiles.add(this.map[x][z]);
                this.map[x][z] = newTile;
                ++z;
            }
            ++x;
        }
        int removeRadius = 100;
        int x3 = this.camIndexX - removeRadius;
        while (x3 < this.camIndexX + 2 * removeRadius) {
            int z = this.camIndexZ - removeRadius;
            while (z < this.camIndexZ + 2 * removeRadius) {
                if (x3 >= 0 && x3 < this.map.length && z >= 0 && z < this.map[0].length && this.map[x3][z] != null && removedTiles.contains(this.map[x3][z])) {
                    this.map[x3][z] = null;
                }
                ++z;
            }
            ++x3;
        }
        this.fileHandler.removeMapTiles(removedTiles);
        this.fileHandler.addFileMapTile(newTile);
    }

    private void synchWithEditor() {
        this.editor.setCameraPositionXZ(this.camIndexX, this.camIndexZ);
    }

    private void populateMap() {
        for (FileMapTile fmt : this.fileHandler.getMap().fileMapTiles) {
            FileTile ft = this.fileHandler.getFileTile(fmt.tileId);
            int w = ft.getWidth(fmt);
            int h = ft.getHeight(fmt);
            int x = fmt.ix;
            while (x < fmt.ix + w) {
                int z = fmt.iz;
                while (z < fmt.iz + h) {
                    this.map[x][z] = fmt;
                    ++z;
                }
                ++x;
            }
        }
    }

    private void paintMap(Graphics g) {
        int rz;
        int rx;
        int z;
        g.setColor(Color.CYAN);
        g.fillRect(0, 0, 1000, 1000);
        int camTransX = -this.camIndexX * this.tileDrawSize + 300;
        int camTransY = -this.camIndexZ * this.tileDrawSize + 300;
        g.translate(camTransX, camTransY);
        int halfNumTiles = 300 / this.tileDrawSize + 5;
        int startx = this.camIndexX - halfNumTiles;
        int endx = this.camIndexX + halfNumTiles;
        int startz = this.camIndexZ - halfNumTiles;
        int endz = this.camIndexZ + halfNumTiles;
        int x = startx;
        while (x < endx) {
            z = startz;
            while (z < endz) {
                if (x >= 0 && z >= 0 && x < this.map.length && z < this.map[0].length) {
                    rx = x * this.tileDrawSize;
                    rz = z * this.tileDrawSize;
                    if (this.map[x][z] != null) {
                        g.setColor(new Color(new Random(this.map[x][z].tileId).nextInt(16581375)));
                        g.fillRect(rx, rz, this.tileDrawSize, this.tileDrawSize);
                    } else {
                        g.setColor(Color.WHITE);
                        g.fillRect(rx, rz, this.tileDrawSize, this.tileDrawSize);
                    }
                    g.setColor(new Color(0, 0, 0, 30));
                    g.drawRect(rx, rz, this.tileDrawSize, this.tileDrawSize);
                    if (x == this.camIndexX && z == this.camIndexZ) {
                        g.setColor(Color.RED);
                        g.drawLine(rx, rz, rx + this.tileDrawSize, rz + this.tileDrawSize);
                        g.drawLine(rx + this.tileDrawSize, rz, rx, rz + this.tileDrawSize);
                    }
                }
                ++z;
            }
            ++x;
        }
        x = startx;
        while (x < endx) {
            z = startz;
            while (z < endz) {
                if (x >= 0 && z >= 0 && x < this.map.length && z < this.map[0].length) {
                    rx = x * this.tileDrawSize;
                    rz = z * this.tileDrawSize;
                    if (x + 1 < this.map.length && z < this.map[0].length && this.map[x + 1][z] != null && this.map[x + 1][z] != this.map[x][z]) {
                        g.setColor(Color.BLACK);
                        g.drawLine(rx + this.tileDrawSize, rz, rx + this.tileDrawSize, rz + this.tileDrawSize);
                    }
                    if (x < this.map.length && z + 1 < this.map[0].length && this.map[x][z + 1] != null && this.map[x][z + 1] != this.map[x][z]) {
                        g.setColor(Color.BLACK);
                        g.drawLine(rx, rz + this.tileDrawSize, rx + this.tileDrawSize, rz + this.tileDrawSize);
                    }
                }
                ++z;
            }
            ++x;
        }
        FileTile selectedTile = this.tileList.getSelectedValue();
        if (selectedTile != null) {
            int tmp;
            g.setColor(new Color(255, 0, 0, 128));
            int hx1 = (int)Math.floor((double)selectedTile.sizeX / 2.0);
            int hx2 = (int)Math.ceil((double)selectedTile.sizeX / 2.0);
            int hz1 = (int)Math.floor((double)selectedTile.sizeZ / 2.0);
            int hz2 = (int)Math.ceil((double)selectedTile.sizeZ / 2.0);
            int x1 = -hx1;
            int z1 = -hz1;
            int x2 = hx2;
            int z2 = hz2;
            if (this.rot == 1) {
                tmp = z1;
                z1 = x1;
                x1 = -tmp;
            } else if (this.rot == 2) {
                x1 = -x1;
                z1 = -z1;
            } else if (this.rot == 3) {
                tmp = z1;
                z1 = -x1;
                x1 = tmp;
            }
            if (this.rot == 1) {
                tmp = z2;
                z2 = x2;
                x2 = -tmp;
            } else if (this.rot == 2) {
                x2 = -x2;
                z2 = -z2;
            } else if (this.rot == 3) {
                tmp = z2;
                z2 = -x2;
                x2 = tmp;
            }
            x1 += this.camIndexX;
            x2 += this.camIndexX;
            z1 += this.camIndexZ;
            z2 += this.camIndexZ;
            int x3 = Math.min(x1 *= this.tileDrawSize, x2 *= this.tileDrawSize);
            int w = Math.max(x1, x2) - x3;
            int z3 = Math.min(z1 *= this.tileDrawSize, z2 *= this.tileDrawSize);
            int h = Math.max(z1, z2) - z3;
            g.fillRect(x3, z3, w, h);
        }
        g.translate(-camTransX, -camTransY);
        if (!this.mapPanel.hasFocus()) {
            g.setColor(new Color(0, 0, 0, 128));
            g.fillRect(0, 0, 600, 600);
        }
    }
}

