/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.Editor;
import editor.FileCustomerNode;
import editor.FileEntity;
import editor.FileHandler;
import editor.FileTile;
import editor.FileTileEntity;
import editor.FileTrafficNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TilesPanel
extends JPanel {
    JList<FileTile> tileList = new JList();
    JTextField posx;
    JTextField posy;
    JTextField posz;
    JTextField probability;
    ArrayList<FileCustomerNode> customerNodes = new ArrayList();
    ArrayList<Node> nodes = new ArrayList();
    int prevNode = -1;
    int prefferedSize = 500;
    double scale = 15.0;

    public TilesPanel(final Editor editor, final FileHandler fileHandler) {
        final JList tileEntitiesList = new JList();
        final JList<FileEntity> entityList = new JList<FileEntity>();
        JLabel posLabel = new JLabel("Pos x y z:");
        this.add(posLabel);
        this.posx = new JTextField("", 5);
        this.add(this.posx);
        this.posy = new JTextField("", 5);
        this.add(this.posy);
        this.posz = new JTextField("", 5);
        this.add(this.posz);
        JLabel probLabel = new JLabel("%:");
        this.add(probLabel);
        this.probability = new JTextField("", 5);
        this.add(this.probability);
        JLabel nameLabel = new JLabel("Tile name: ");
        this.add(nameLabel);
        final JTextField name = new JTextField("", 20);
        this.add(name);
        JLabel sizexLabel = new JLabel("Size x z: ");
        this.add(sizexLabel);
        final JTextField sizex = new JTextField("", 5);
        this.add(sizex);
        final JTextField sizez = new JTextField("", 5);
        this.add(sizez);
        JLabel minimapLabel = new JLabel("Minimap: ");
        this.add(minimapLabel);
        final JTextField minimap = new JTextField("", 20){

            @Override
            public void repaint() {
                if (this.getDocument() != null) {
                    this.setBackground(new File("src/textures/minimap/" + this.getText()).exists() ? Color.WHITE : Color.RED);
                }
                super.repaint();
            }
        };
        this.add(minimap);
        JButton newTile = new JButton("Create new tile");
        newTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                fileHandler.addNewEmptyTile();
                Vector<FileTile> newTiles = fileHandler.getFileTilesCopy();
                TilesPanel.this.tileList.setListData(newTiles);
                TilesPanel.this.tileList.setSelectedIndex(newTiles.size() - 1);
            }
        });
        this.add(newTile);
        JButton add = new JButton("Add selected entity");
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedTile = TilesPanel.this.tileList.getSelectedIndex();
                int selectedEntity = entityList.getSelectedIndex();
                if (selectedTile != -1 && selectedEntity != -1) {
                    fileHandler.addNewFileTileEntity(selectedTile, selectedEntity);
                    Vector<FileTileEntity> fileTileEntities = fileHandler.getFileTileEntitiesCopy(selectedTile);
                    tileEntitiesList.setListData(fileTileEntities);
                    tileEntitiesList.setSelectedIndex(fileTileEntities.size() - 1);
                }
            }
        });
        this.add(add);
        this.tileList.setListData(fileHandler.getFileTilesCopy());
        this.tileList.addListSelectionListener(new ListSelectionListener(){
            int prev = -1;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TilesPanel.this.saveTileEntity((FileTileEntity)tileEntitiesList.getSelectedValue());
                int sel = TilesPanel.this.tileList.getSelectedIndex();
                if (this.prev != -1) {
                    FileTile prevTile = TilesPanel.this.tileList.getModel().getElementAt(this.prev);
                    prevTile.name = name.getText();
                    try {
                        prevTile.sizeX = Integer.parseInt(sizex.getText());
                    }
                    catch (NumberFormatException exception) {
                        System.err.println("Tile size x could not be parsed");
                    }
                    try {
                        prevTile.sizeZ = Integer.parseInt(sizez.getText());
                    }
                    catch (NumberFormatException exception) {
                        System.err.println("Tile size z could not be parsed");
                    }
                    prevTile.minimap = minimap.getText();
                    if (prevTile != null) {
                        ArrayList<FileTrafficNode> newNodes = new ArrayList<FileTrafficNode>();
                        for (Node n : TilesPanel.this.nodes) {
                            newNodes.add(new FileTrafficNode(n.x, n.y, n.prev));
                        }
                        prevTile.nodes = newNodes;
                        prevTile.customerNodes = TilesPanel.this.customerNodes;
                        TilesPanel.this.customerNodes = new ArrayList();
                    }
                }
                if (sel != -1) {
                    tileEntitiesList.setListData(fileHandler.getFileTileEntitiesCopy(TilesPanel.this.tileList.getSelectedIndex()));
                    name.setText(TilesPanel.this.tileList.getSelectedValue().name);
                    sizex.setText("" + TilesPanel.this.tileList.getSelectedValue().sizeX);
                    sizez.setText("" + TilesPanel.this.tileList.getSelectedValue().sizeZ);
                    minimap.setText(TilesPanel.this.tileList.getSelectedValue().minimap);
                    editor.setSelectedTile(TilesPanel.this.tileList.getSelectedValue());
                    TilesPanel.this.nodes.clear();
                    for (FileTrafficNode n : TilesPanel.this.tileList.getSelectedValue().nodes) {
                        TilesPanel.this.nodes.add(new Node(n.x, n.z, n.prev));
                    }
                    TilesPanel.this.customerNodes = TilesPanel.this.tileList.getSelectedValue().customerNodes;
                    TilesPanel.this.prevNode = -1;
                }
                this.prev = sel;
            }
        });
        JScrollPane tileListScroller = new JScrollPane(this.tileList);
        tileListScroller.setPreferredSize(new Dimension(250, 80));
        this.add(tileListScroller);
        entityList.setListData(fileHandler.getFileEntitiesCopy());
        JScrollPane entityListScroller = new JScrollPane(entityList);
        entityListScroller.setPreferredSize(new Dimension(500, 200));
        this.add(entityListScroller);
        tileEntitiesList.addListSelectionListener(new ListSelectionListener(){
            int prev = -1;

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int sel = tileEntitiesList.getSelectedIndex();
                if (this.prev != -1 && sel != -1) {
                    TilesPanel.this.saveTileEntity((FileTileEntity)tileEntitiesList.getModel().getElementAt(this.prev));
                }
                FileTileEntity selected = (FileTileEntity)tileEntitiesList.getSelectedValue();
                if (sel != -1 && selected != null) {
                    TilesPanel.this.posx.setText("" + selected.px);
                    TilesPanel.this.posy.setText("" + selected.py);
                    TilesPanel.this.posz.setText("" + selected.pz);
                    TilesPanel.this.probability.setText("" + selected.probability);
                }
                this.prev = sel;
            }
        });
        JScrollPane tileEntitiesListScroller = new JScrollPane(tileEntitiesList);
        tileEntitiesListScroller.setPreferredSize(new Dimension(300, 200));
        this.add(tileEntitiesListScroller);
        final JPanel trafficPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                TilesPanel.this.trafficPaint(g);
            }
        };
        trafficPanel.setPreferredSize(new Dimension(this.prefferedSize, this.prefferedSize));
        trafficPanel.setBackground(Color.WHITE);
        JButton clearTI = new JButton("Clear TI");
        clearTI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TilesPanel.this.prevNode = -1;
                TilesPanel.this.nodes.clear();
                TilesPanel.this.customerNodes.clear();
                fileHandler.clearNodes(TilesPanel.this.tileList.getSelectedValue());
            }
        });
        this.add(clearTI);
        this.add(trafficPanel);
        trafficPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    TilesPanel.this.nodes.add(new Node((float)((double)e.getX() / TilesPanel.this.scale), (float)((double)e.getY() / TilesPanel.this.scale), TilesPanel.this.prevNode));
                    ++TilesPanel.this.prevNode;
                } else {
                    TilesPanel.this.customerNodes.add(new FileCustomerNode((float)((double)e.getX() / TilesPanel.this.scale), 0.0f, (float)((double)e.getY() / TilesPanel.this.scale)));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    trafficPanel.repaint();
                }
            }
        }.start();
        trafficPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                TilesPanel.this.prevNode = (int)((float)TilesPanel.this.prevNode + Math.signum(e.getWheelRotation()));
                if (TilesPanel.this.prevNode < -1) {
                    TilesPanel.this.prevNode = -1;
                }
                if (TilesPanel.this.prevNode >= TilesPanel.this.nodes.size()) {
                    TilesPanel.this.prevNode = TilesPanel.this.nodes.size() - 1;
                }
            }
        });
    }

    protected void saveTileEntity(FileTileEntity selectedEntity) {
        if (selectedEntity != null) {
            try {
                selectedEntity.px = Double.parseDouble(this.posx.getText());
            }
            catch (NumberFormatException exception) {
                System.err.println("TileEntity pos x could not be parsed");
            }
            try {
                selectedEntity.py = Double.parseDouble(this.posy.getText());
            }
            catch (NumberFormatException exception) {
                System.err.println("TileEntity pos y could not be parsed");
            }
            try {
                selectedEntity.pz = Double.parseDouble(this.posz.getText());
            }
            catch (NumberFormatException exception) {
                System.err.println("TileEntity pos z could not be parsed");
            }
            try {
                selectedEntity.probability = Double.parseDouble(this.probability.getText());
            }
            catch (NumberFormatException exception) {
                System.err.println("TileEntity probability could not be parsed");
            }
        }
    }

    private void trafficPaint(Graphics g) {
        FileTile tile = this.tileList.getSelectedValue();
        if (tile == null) {
            return;
        }
        g.setColor(Color.LIGHT_GRAY);
        g.fillRect(0, 0, (int)((double)tile.sizeX * this.scale), (int)((double)tile.sizeZ * this.scale));
        Iterator<Object> iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            Node n;
            Node p = n = iterator.next();
            do {
                g.setColor(new Color(new Random(p.prev * 100).nextInt(16581375)));
                if (p.prev == -1) continue;
                p = this.nodes.get(p.prev);
            } while (p.prev != -1);
            if (n.prev != -1) {
                g.fillRect((int)((double)n.x * this.scale), (int)((double)n.y * this.scale), 4, 4);
                g.drawLine((int)((double)n.x * this.scale), (int)((double)n.y * this.scale), (int)((double)this.nodes.get((int)n.prev).x * this.scale), (int)((double)this.nodes.get((int)n.prev).y * this.scale));
                continue;
            }
            g.fillOval((int)((double)n.x * this.scale), (int)((double)n.y * this.scale), 7, 7);
        }
        if (this.prevNode != -1 && System.currentTimeMillis() % 500L > 250L) {
            g.fillRect((int)((double)this.nodes.get((int)this.prevNode).x * this.scale), (int)((double)this.nodes.get((int)this.prevNode).y * this.scale), 8, 8);
        }
        g.setColor(Color.RED);
        for (FileCustomerNode fcn : this.customerNodes) {
            g.fillOval((int)(fcn.px * this.scale), (int)(fcn.pz * this.scale), 15, 15);
        }
    }

    class Node {
        float x;
        float y;
        int prev;

        public Node(float x, float y, int prev) {
            this.x = x;
            this.y = y;
            this.prev = prev;
        }
    }
}

