/*
 * Decompiled with CFR 0.152.
 */
package entity;

import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.Texture;
import entity.VehicleEntity;
import entity.VehicleInfo;
import game.Game;
import game.TrafficInfo;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import physics.Physics;

public class AIVehicle
extends VehicleEntity {
    private static int[] TEXTURE_IDS = new int[]{new Texture((String)"textures/cars/LP_Car2_2_MAP2.png").textureID, new Texture((String)"textures/cars/LP_Car2_2_MAP.png").textureID, new Texture((String)"textures/cars/LP_Car2_2_MAP3.png").textureID, new Texture((String)"textures/cars/LP_Car2_2_MAP4.png").textureID, new Texture((String)"textures/cars/LP_Car2_2_MAP5.png").textureID};
    private TrafficInfo.Node next;
    private TrafficInfo trafficInfo;
    private static VehicleInfo VEHICLE_INFO = new VehicleInfo();

    static {
        AIVehicle.VEHICLE_INFO.weight = 200.0f;
    }

    public AIVehicle(Physics physics, Vector3f position, TrafficInfo trafficInfo, TrafficInfo.Node next) {
        super(physics, position, new Vector3f(next.pos.x, 0.0f, next.pos.z), VEHICLE_INFO, TEXTURE_IDS[(int)(Math.random() * (double)TEXTURE_IDS.length)], Mesh.CAR_AI);
        this.setBodyUserPointer();
        this.next = next;
        this.trafficInfo = trafficInfo;
        maxEngineForce = 4000.0f;
        maxBreakingForce = 100.0f;
        this.gVehicleSteering = 0.0f;
        this.steeringIncrement = 0.05f;
        this.steeringClamp = 0.8f;
        trafficInfo.addVehicle(this);
    }

    @Override
    public void update() {
        if (this.next != null) {
            float dx = this.next.pos.x - this.getCenter().x;
            float dy = 0.0f;
            float dz = this.next.pos.z - this.getCenter().z;
            Vector3f target = new Vector3f(dx, 0.0f, dz);
            target.normalize();
            Vector3f forward = new Vector3f();
            this.vehicle.getForwardVector(forward);
            forward.normalize();
            double angle = Math.atan2(forward.x * target.z - forward.z * target.x, forward.x * target.x + forward.z * target.z);
            this.gVehicleSteering = (float)(-angle);
            if (this.gVehicleSteering > this.steeringClamp) {
                this.gVehicleSteering = this.steeringClamp;
            } else if (this.gVehicleSteering < -this.steeringClamp) {
                this.gVehicleSteering = -this.steeringClamp;
            }
            if (this.vehicle.getCurrentSpeedKmHour() > 0.0f && this.shouldBreak()) {
                this.backward();
            } else if (this.vehicle.getCurrentSpeedKmHour() < 30.0f && Math.abs(angle) < 0.1 || this.vehicle.getCurrentSpeedKmHour() < 10.0f) {
                this.forward();
            }
            double thres = 3.0;
            if (Math.sqrt(dx * dx + dy * dy + dz * dz) < thres) {
                this.next = this.next.getNext();
            }
        }
        super.update();
    }

    private boolean shouldBreak() {
        for (VehicleEntity v : this.trafficInfo.getCarsWithin(this, 7.0)) {
            float dx = v.getCenter().x - this.getCenter().x;
            float dz = v.getCenter().z - this.getCenter().z;
            Vector3f target = new Vector3f(dx, 0.0f, dz);
            target.normalize();
            Vector3f forward = new Vector3f();
            this.vehicle.getForwardVector(forward);
            forward.normalize();
            double angle = Math.atan2(forward.x * target.z - forward.z * target.x, forward.x * target.x + forward.z * target.z);
            if (!(Math.abs(angle) < Math.toRadians(20.0))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void render(MeshBatch meshBatch) {
        Matrix4f mat;
        this.renderChassi(meshBatch);
        this.renderWheels(meshBatch);
        this.renderShadow(meshBatch);
        if (Game.DEBUG_SHOW_VEHICLE_NEXT_NODE && this.next != null) {
            mat = new Matrix4f();
            mat.setIdentity();
            mat.setTranslation(new Vector3f(this.next.pos.x, this.next.pos.y, this.next.pos.z));
            meshBatch.render(Mesh.TEXTURED_BOX_TEST, Texture.RED, mat);
        }
        if (Game.DEBUG_SHOW_AI_BREAK && this.shouldBreak()) {
            mat = new Matrix4f();
            mat.setIdentity();
            Vector3f center = this.getCenter();
            center.y += 2.0f;
            mat.setTranslation(center);
            meshBatch.render(Mesh.TEXTURED_BOX_TEST, Texture.RED, mat);
        }
    }
}

