/*
 * Decompiled with CFR 0.152.
 */
package entity;

import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.Vector3f;
import com.bulletphysics.linearmath.Transform;
import entity.Entity;
import physics.Physics;

public class DynamicEntity
extends Entity {
    private javax.vecmath.Vector3f boxTranslation = new javax.vecmath.Vector3f();

    public DynamicEntity(Physics physics, javax.vecmath.Vector3f pos, javax.vecmath.Vector3f rot, Mesh mesh, String collision, int textureID, double weight) {
        super(physics);
        this.mesh = mesh;
        if (collision.equals("mesh")) {
            this.body = physics.createBodyFromMesh(mesh, pos, (float)weight, rot);
        } else if (collision.equals("box")) {
            javax.vecmath.Vector3f size = new javax.vecmath.Vector3f();
            javax.vecmath.Vector3f center = new javax.vecmath.Vector3f();
            mesh.getBounds(size, center);
            pos.x += center.x;
            pos.y += center.y;
            pos.z += center.z;
            this.boxTranslation = center;
            size.x *= 0.5f;
            size.y *= 0.5f;
            size.z *= 0.5f;
            this.body = physics.createBox(size, pos, (float)weight, rot);
        } else {
            this.body = physics.createBodyFromMesh(Mesh.getMesh(collision, 1.0f), pos, (float)weight, rot);
        }
        this.textureID = textureID;
        this.setBodyUserPointer();
    }

    @Override
    public void render(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix4f real = Matrix4f.identity();
        real.elements = new float[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
        Matrix4f fix = Matrix4f.translate(new Vector3f(-this.boxTranslation.x, -this.boxTranslation.y, -this.boxTranslation.z));
        real = real.multiply(fix);
        meshBatch.render(this.mesh, this.textureID, real);
    }
}

