/*
 * Decompiled with CFR 0.152.
 */
package entity;

import GLEngine.Mesh;
import GLEngine.MeshBatch;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import physics.Physics;

public abstract class Entity {
    protected RigidBody body;
    protected Physics physics;
    protected Mesh mesh;
    protected int textureID;
    protected State state = State.VISUAL_PHYSICS;

    public Entity(Physics physics) {
        this.physics = physics;
    }

    protected void setBodyUserPointer() {
        this.body.setUserPointer(this);
    }

    public void update() {
    }

    public void render(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        Matrix4f mat = new Matrix4f();
        trans.getMatrix(mat);
        meshBatch.render(this.mesh, this.textureID, mat);
    }

    public Vector3f getCenter() {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        return trans.origin;
    }

    public RigidBody getBody() {
        return this.body;
    }

    public void collidedWith(Entity entity) {
    }

    public State getState() {
        return this.state;
    }

    public void setState(State newState) {
        if (newState == State.HIDDEN || newState == State.VISUAL_ONLY) {
            if (this.state == State.VISUAL_PHYSICS) {
                this.physics.remove(this.body);
            }
        } else if (newState == State.VISUAL_PHYSICS && (this.state == State.HIDDEN || this.state == State.VISUAL_ONLY)) {
            this.physics.add(this.body);
        }
        this.state = newState;
    }

    public boolean isStatic() {
        return this.body.getInvMass() == 0.0f;
    }

    public void cleanUp() {
    }

    public static enum State {
        HIDDEN,
        VISUAL_ONLY,
        VISUAL_PHYSICS;

    }
}

