/*
 * Decompiled with CFR 0.152.
 */
package game;

import GLEngine.Matrix4f;
import GLEngine.Vector3f;
import entity.PlayerVehicle;
import java.util.ArrayList;
import physics.Physics;

public class Camera {
    public Vector3f pos = new Vector3f();
    public Vector3f rot = new Vector3f();
    public Vector3f target = new Vector3f();
    private PlayerVehicle pv;
    private boolean isFollowing;
    private Physics physics;
    private ArrayList<javax.vecmath.Vector3f> forwards = new ArrayList();
    private ArrayList<Float> rotys = new ArrayList();
    private int delayTicks = 15;
    private double minDistance = 10.0;
    private double maxDistance = 20.0;
    private double flexibleLength = this.maxDistance - this.minDistance;
    private double maxDistanceSpeedKmHour = 120.0;

    public Camera(Physics physics) {
        this.physics = physics;
    }

    public void follow(PlayerVehicle pv) {
        this.pv = pv;
        this.isFollowing = true;
    }

    public void stopFollowing() {
        this.isFollowing = false;
    }

    public Vector3f getPosition() {
        return this.pos;
    }

    public Matrix4f getViewMatrix() {
        if (this.isFollowing) {
            Vector3f c = new Vector3f(this.pv.getCenter().x, this.pv.getCenter().y, this.pv.getCenter().z);
            float length = (float)Math.abs(this.minDistance + Math.min(this.flexibleLength, this.flexibleLength * (double)Math.abs(this.pv.vehicle.getCurrentSpeedKmHour()) / this.maxDistanceSpeedKmHour));
            float height = length / 1.9f;
            javax.vecmath.Vector3f carUp = this.pv.getUpVec();
            carUp.normalize();
            javax.vecmath.Vector3f forward = this.pv.getForwardVec();
            this.forwards.add(forward);
            float roty = this.pv.getRotY();
            this.rotys.add(Float.valueOf(roty));
            if (this.forwards.size() == this.delayTicks) {
                forward = this.forwards.remove(0);
                roty = this.rotys.remove(0).floatValue();
            }
            forward.normalize();
            forward.x = -forward.x;
            forward.y = -forward.y;
            forward.z = -forward.z;
            this.pos.x = (float)((double)c.x + Math.cos((double)roty - Math.PI) * (double)length);
            this.pos.y = c.y + height;
            this.pos.z = (float)((double)c.z + Math.sin((double)roty - Math.PI) * (double)length);
            javax.vecmath.Vector3f from = this.pv.getCenter();
            from.y = from.y + (float)(c.y < 0.0f ? 2 : 4);
            javax.vecmath.Vector3f v = this.physics.rayTest(from, new javax.vecmath.Vector3f(this.pos.x, this.pos.y, this.pos.z));
            if (v != null) {
                this.pos.x = v.x;
                this.pos.y = v.y;
                this.pos.z = v.z;
            }
            this.target = c;
            return Matrix4f.lookAt(this.pos, c, new Vector3f(0.0f, 1.0f, 0.0f));
        }
        return Matrix4f.rotateX(-this.rot.x).multiply(Matrix4f.rotateY(-this.rot.y)).multiply(Matrix4f.translate(this.pos.multiply(-1.0f)));
    }
}

