/*
 * Decompiled with CFR 0.152.
 */
package game;

import GLEngine.GLSLProgram;
import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.SpriteBatch;
import GLEngine.Texture;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import GLEngine.Window;
import editor.FileHandler;
import entity.AIVehicle;
import entity.Entity;
import entity.PlayerVehicle;
import game.Camera;
import game.MissionHandler;
import game.Settings;
import game.TrafficInfo;
import highscore.Entry;
import highscore.HighScoreClient;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import physics.Physics;
import radio.Radio;
import sound.Sound;

public class Game {
    public static boolean DEBUG_KEYS = false;
    public static boolean DEBUG_SHOW_TRAFFIC_NODES = false;
    public static boolean DEBUG_SHOW_VEHICLE_NEXT_NODE = false;
    public static boolean DEBUG_SHOW_TRAFFIC_PATH = false;
    public static boolean DEBUG_SHOW_AI_BREAK = false;
    public static boolean DEBUG_SHOW_CAMERA_POS = false;
    public static boolean DEBUG_NO_TRAFFIC = false;
    public static boolean DEBUG_TEST_RESTART = false;
    public static boolean DEBUG_PRINT_HIGHSCORE = false;
    public static boolean DEBUG_SHORT_SPAWN_TIME = false;
    public static boolean DEBUG_WINDOW_SIZE = false;
    public static boolean DEBUG_SHOW_FPS = false;
    private Physics physics;
    private ArrayList<Entity> entities = new ArrayList();
    private PlayerVehicle playerCar;
    private Sound sound;
    private Radio radio;
    private GLSLProgram activeProgram;
    private GLSLProgram activeProgram2D;
    private GLSLProgram activeProgramMap;
    private MeshBatch meshBatch;
    private SpriteBatch spriteBatch;
    private Window window;
    private Camera camera;
    private FileHandler fileHandler;
    private HighScoreClient highScoreClient;
    private float fov = 70.0f;
    private float current_FPS = 0.0f;
    public static final int FPS = 60;
    private int mainMenuSelected = 0;
    private Entry[] lastHighScoreList = new Entry[0];
    private GameState state = GameState.MAIN_MENU;
    private Mode mode = Mode.DRIVE_CAR;
    private TrafficInfo trafficInfo;
    private MissionHandler missionHandler;
    private Settings settings;
    int i = 0;

    public Game(Settings settings) {
        this.settings = settings;
        this.oneTimeInit();
        this.loop();
        this.free();
        System.exit(0);
    }

    public void oneTimeInit() {
        this.window = new Window("Sten taxi", this.settings.width, this.settings.height);
        this.window.init(this.settings.aa, this.settings.full);
        this.activeProgram = new GLSLProgram("/shaders/vertex.vert", "/shaders/fragment.frag");
        this.activeProgram2D = new GLSLProgram("/shaders/vertex2D.vert", "/shaders/fragment2D.frag");
        this.activeProgramMap = new GLSLProgram("/shaders/vertMap.vert", "/shaders/fragMap.frag");
        this.spriteBatch = new SpriteBatch();
        this.spriteBatch.init();
        this.renderLoadingScreen();
        this.initMeshBatch();
        this.sound = new Sound(this.settings.volume, this.settings.volume);
        this.highScoreClient = new HighScoreClient();
    }

    public void initMeshBatch() {
        this.meshBatch = new MeshBatch();
        this.meshBatch.init();
        this.meshBatch.preAllocateVAO(Mesh.TRASHCAN);
        this.meshBatch.preAllocateVAO(Mesh.SKYSCRAPER);
    }

    private void newRound() {
        this.cleanUp();
        this.restart();
    }

    private void cleanUp() {
        for (Entity e : this.entities) {
            e.cleanUp();
        }
        this.entities.clear();
    }

    private void restart() {
        this.physics = new Physics();
        this.camera = new Camera(this.physics);
        this.camera.pos = new Vector3f(30.0f, 30.0f, 30.0f);
        this.camera.rot.x = -45.0f;
        this.trafficInfo = new TrafficInfo();
        this.fileHandler = new FileHandler();
        this.fileHandler.load();
        ArrayList<Vector3f> customerNodes = new ArrayList<Vector3f>();
        BufferedImage minimap = this.fileHandler.createDynamicEntities(this.physics, this.entities, this.trafficInfo, customerNodes);
        Texture.createMinimap(minimap);
        this.trafficInfo.createFinalInfo();
        this.createWorld();
        this.updateEntityStates();
        if (this.missionHandler != null) {
            this.missionHandler.free();
        }
        this.missionHandler = new MissionHandler(this.playerCar, customerNodes, this.sound);
        if (this.radio != null) {
            this.radio.close();
        }
        this.radio = new Radio(this.settings.radioVolume, true);
    }

    private void createWorld() {
        double thres = 500.0;
        double sum = 0.0;
        for (TrafficInfo.Node node : this.trafficInfo.getNodes()) {
            for (TrafficInfo.Node next : node.getAllNext()) {
                if (!((sum += (double)node.pos.distanceTo(next.pos)) > thres) || DEBUG_NO_TRAFFIC) continue;
                this.entities.add(new AIVehicle(this.physics, new javax.vecmath.Vector3f(node.pos.x, 0.5f, node.pos.z), this.trafficInfo, next));
                sum = 0.0;
            }
        }
        this.playerCar = new PlayerVehicle(this.physics, new javax.vecmath.Vector3f(20.0f, 5.0f, 20.0f), this.sound, this.camera);
        this.entities.add(this.playerCar);
        this.trafficInfo.addVehicle(this.playerCar);
    }

    public void loop() {
        long tick = 0L;
        while (!this.window.shouldClose()) {
            long time0 = System.nanoTime();
            ++tick;
            InputHandler.update();
            this.window.pollEvents();
            GL11.glClear(16640);
            if (this.state == GameState.INGAME) {
                this.update(tick);
                this.render(tick);
            } else if (this.state == GameState.MAIN_MENU) {
                this.updateMainMenu();
            } else if (this.state == GameState.HELP) {
                if (InputHandler.pressed(257)) {
                    this.state = GameState.MAIN_MENU;
                }
                this.renderHelp();
            } else if (this.state == GameState.SHOW_HIGHSCORE) {
                if (InputHandler.pressed(257)) {
                    this.state = GameState.MAIN_MENU;
                }
                this.renderHighscore(false);
            } else if (this.state == GameState.END) {
                if (InputHandler.pressed(257)) {
                    this.state = GameState.MAIN_MENU;
                }
                this.renderHighscore(true);
            }
            long dt = System.nanoTime() - time0;
            if (tick % 60L != 0L || dt == 0L) continue;
            this.current_FPS = (float)(1.0 / ((double)dt / 1.0E9));
        }
    }

    private void updateHighscore() {
        try {
            this.lastHighScoreList = this.highScoreClient.getList();
        }
        catch (IOException e) {
            this.lastHighScoreList = new Entry[]{new Entry("Could not connect to highscore server", 0L)};
        }
    }

    private void updateMainMenu() {
        boolean render = true;
        if (InputHandler.pressed(265)) {
            --this.mainMenuSelected;
            if (this.mainMenuSelected == -1) {
                this.mainMenuSelected = 3;
            }
        }
        if (InputHandler.pressed(264)) {
            ++this.mainMenuSelected;
            if (this.mainMenuSelected == 4) {
                this.mainMenuSelected = 0;
            }
        }
        if (InputHandler.pressed(257)) {
            if (this.mainMenuSelected == 0) {
                this.renderLoadingScreen();
                render = false;
                this.state = GameState.INGAME;
                this.newRound();
            } else if (this.mainMenuSelected == 1) {
                this.updateHighscore();
                this.state = GameState.SHOW_HIGHSCORE;
            } else if (this.mainMenuSelected == 2) {
                this.state = GameState.HELP;
            } else {
                this.window.setShouldClose(true);
            }
        }
        if (render) {
            this.renderMainMenu();
        }
    }

    public void update(long tick) {
        this.physics.update();
        for (Entity e : this.entities) {
            if (e.getState() != Entity.State.VISUAL_PHYSICS) continue;
            e.update();
        }
        this.updateEntityStates();
        this.updateInput(tick);
        if (this.mode == Mode.DRIVE_CAR) {
            this.camera.follow(this.playerCar);
        } else if (this.mode == Mode.FREE_ROAM) {
            this.camera.stopFollowing();
        }
        this.playerCar.updateStats(tick, this.missionHandler);
        boolean gameOver = this.missionHandler.update(tick);
        boolean escape = InputHandler.down(256);
        if (gameOver || escape || DEBUG_TEST_RESTART && InputHandler.pressed(82)) {
            if (!InputHandler.down(256)) {
                try {
                    this.highScoreClient.postNew(this.settings.name, this.missionHandler.getScore());
                    if (DEBUG_PRINT_HIGHSCORE) {
                        Entry[] topList = this.highScoreClient.getList();
                        int i = 0;
                        while (i < topList.length) {
                            System.out.println(i + 1 + ": " + topList[i].name + " : " + topList[i].score);
                            ++i;
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.updateHighscore();
            }
            this.sound.stopMusic();
            this.radio.close();
            this.state = escape ? GameState.MAIN_MENU : GameState.END;
        }
    }

    private void updateEntityStates() {
        for (Entity e : this.entities) {
            javax.vecmath.Vector3f b = e.getCenter();
            Vector3f ent = new Vector3f(e.getCenter().x, e.getCenter().y, e.getCenter().z);
            javax.vecmath.Vector3f a = this.playerCar.getCenter();
            Vector3f dir = this.camera.target.subtract(this.camera.pos).normalized();
            dir.y = 0.0f;
            Vector3f edif = ent.subtract(this.camera.pos).normalized();
            edif.y = 0.0f;
            double dx = a.x - b.x;
            double dy = a.y - b.y;
            double dz = a.z - b.z;
            double dis = Math.sqrt(dx * dx + dy * dy + dz * dz);
            if (dis < 75.0) {
                e.setState(Entity.State.VISUAL_PHYSICS);
                continue;
            }
            if (edif.dot(dir) < 0.0f) {
                if (dis < 75.0) {
                    e.setState(Entity.State.VISUAL_ONLY);
                    continue;
                }
                e.setState(Entity.State.HIDDEN);
                continue;
            }
            if (dis < 50.0 || Math.acos(edif.dot(dir)) < Math.toRadians(this.fov / 2.0f) && dis < 150.0) {
                e.setState(Entity.State.VISUAL_PHYSICS);
                continue;
            }
            if (dis < 500.0) {
                e.setState(Entity.State.VISUAL_ONLY);
                continue;
            }
            e.setState(Entity.State.HIDDEN);
        }
    }

    private void updateInput(long tick) {
        InputHandler.down(256);
        if (DEBUG_TEST_RESTART) {
            InputHandler.pressed(82);
        }
        if (InputHandler.pressed(77) && DEBUG_KEYS) {
            Mode mode = this.mode = this.mode == Mode.FREE_ROAM ? Mode.DRIVE_CAR : Mode.FREE_ROAM;
        }
        if (this.mode == Mode.FREE_ROAM) {
            float speed = 0.2f;
            if (InputHandler.down(264)) {
                this.camera.pos.x = (float)((double)this.camera.pos.x + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
                this.camera.pos.z = (float)((double)this.camera.pos.z + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
            }
            if (InputHandler.down(265)) {
                this.camera.pos.x = (float)((double)this.camera.pos.x - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
                this.camera.pos.z = (float)((double)this.camera.pos.z - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
            }
            if (InputHandler.down(262)) {
                this.camera.pos.z = (float)((double)this.camera.pos.z - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
                this.camera.pos.x = (float)((double)this.camera.pos.x + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
            }
            if (InputHandler.down(263)) {
                this.camera.pos.z = (float)((double)this.camera.pos.z + (double)speed * Math.sin(Math.toRadians(this.camera.rot.y)));
                this.camera.pos.x = (float)((double)this.camera.pos.x - (double)speed * Math.sin(Math.toRadians(this.camera.rot.y + 90.0f)));
            }
            if (InputHandler.down(87)) {
                this.camera.rot.x += 1.0f;
            }
            if (InputHandler.down(83)) {
                this.camera.rot.x -= 1.0f;
            }
            if (InputHandler.down(65)) {
                this.camera.rot.y += 1.0f;
            }
            if (InputHandler.down(68)) {
                this.camera.rot.y -= 1.0f;
            }
            if (InputHandler.down(32)) {
                this.camera.pos.y += speed;
            }
            if (InputHandler.down(341)) {
                this.camera.pos.y -= speed;
            }
        } else if (this.mode == Mode.DRIVE_CAR) {
            this.playerCar.updateInput();
            this.missionHandler.updateInput(tick);
        }
        if (InputHandler.pressed(81)) {
            this.radio.pressButton(Radio.RadioButton.ON_OFF);
        }
        if (InputHandler.pressed(83)) {
            this.radio.pressButton(Radio.RadioButton.STATION_PREVIOUS);
        }
        if (InputHandler.pressed(68)) {
            this.radio.pressButton(Radio.RadioButton.STATION_NEXT);
        }
        if (InputHandler.pressed(87)) {
            this.radio.pressButton(Radio.RadioButton.VOLUME_UP);
        }
        if (InputHandler.pressed(69)) {
            this.radio.pressButton(Radio.RadioButton.VOLUME_DOWN);
        }
    }

    public void shadowMapPass() {
    }

    public void renderPass() {
    }

    private void renderHighscore(boolean end) {
        GL11.glClear(16640);
        this.initOrtho();
        this.spriteBatch.begin(this.activeProgram2D);
        if (end) {
            this.spriteBatch.renderString("Game Over! You got: " + this.missionHandler.score, new Vector3f(Window.width / 2 - 400, this.settings.height / 2 - 300, 0.0f), 0.5f, new Vector3f(1.0f, 1.0f, 0.0f));
        }
        this.spriteBatch.renderString("Global highscore", new Vector3f(this.settings.width / 2 - 500, this.settings.height / 2 - 250, 0.0f), 0.8f, new Vector3f(1.0f, 1.0f, 0.0f));
        int i = 0;
        while (i < this.lastHighScoreList.length) {
            Entry e = this.lastHighScoreList[i];
            float x = this.settings.width / 2 - 500;
            float y = this.settings.height / 2 - 160 + i * 40;
            this.spriteBatch.renderString(i + 1 + ". " + e.score + " " + e.name, new Vector3f(x, y, 0.0f), 0.3f);
            ++i;
        }
        this.spriteBatch.renderString("Press enter to return to main menu", new Vector3f(this.settings.height / 2 - 150, this.settings.height / 2 + 300, 0.0f), 0.3f);
        this.spriteBatch.end();
        this.activeProgram2D.disable();
        this.window.swapBuffers();
    }

    private void renderHelp() {
        GL11.glClear(16640);
        this.initOrtho();
        this.spriteBatch.begin(this.activeProgram2D);
        Matrix4f scale = Matrix4f.scaleX(700.0f).multiply(Matrix4f.scaleY(700.0f));
        Matrix4f m = Matrix4f.translate(new Vector3f((this.settings.width - 700) / 2, (this.settings.height - 700) / 2, 0.0f)).multiply(scale);
        float x = this.settings.width / 2 - 210;
        float y = this.settings.height / 2 - 50;
        this.spriteBatch.renderString("Description", new Vector3f(x - 50.0f, y - 300.0f, 0.0f), 0.9f, new Vector3f(1.0f, 1.0f, 0.0f));
        this.spriteBatch.renderString("Get as many customers to their destination as possible.", new Vector3f(x - 300.0f, y - 200.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("You can have multiple customers in the taxi at the same time.", new Vector3f(x - 300.0f, y - 160.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("You drive faster and get more score for each waiting customer.", new Vector3f(x - 300.0f, y - 120.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Each customer have a personal timer.", new Vector3f(x - 300.0f, y - 80.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("If any timer runs to zero, game over.", new Vector3f(x - 300.0f, y - 40.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Controls", new Vector3f(x, y + 30.0f, 0.0f), 0.9f, new Vector3f(1.0f, 1.0f, 0.0f));
        this.spriteBatch.renderString("Key Up: Drive", new Vector3f(x - 100.0f, y + 130.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Key Left/Right: Turn", new Vector3f(x - 100.0f, y + 160.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Key Down: Brake", new Vector3f(x - 100.0f, y + 190.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Space: Accept customer", new Vector3f(x - 100.0f, y + 220.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("S/D: Change radio channel", new Vector3f(x - 100.0f, y + 250.0f, 0.0f), 0.3f);
        this.spriteBatch.renderString("Press enter to return to main menu", new Vector3f(x - 150.0f, y + 340.0f, 0.0f), 0.3f);
        this.spriteBatch.end();
        this.activeProgram2D.disable();
        this.window.swapBuffers();
    }

    private void renderMainMenu() {
        GL11.glClear(16640);
        this.initOrtho();
        this.spriteBatch.begin(this.activeProgram2D);
        Matrix4f scale = Matrix4f.scaleX(500.0f).multiply(Matrix4f.scaleY(100.0f));
        float x = this.settings.width / 2 - 80;
        float y = this.settings.height / 2 - 50;
        Vector3f white = new Vector3f(1.0f, 1.0f, 1.0f);
        Vector3f gray = new Vector3f(0.1254902f, 0.1254902f, 0.1254902f);
        Matrix4f rect = Matrix4f.translate(new Vector3f(x - 150.0f, y - 3.0f + (float)(60 * this.mainMenuSelected), 0.0f)).multiply(Matrix4f.scaleX(450.0f)).multiply(Matrix4f.scaleY(50.0f));
        this.spriteBatch.render(Texture.RECTANGLE, rect, new Vector3f(1.0f, 1.0f, 0.0f));
        this.spriteBatch.renderString("Tom Taxi", new Vector3f(x - 145.0f, y - 150.0f, 0.0f), 1.0f, new Vector3f(1.0f, 1.0f, 0.0f));
        this.spriteBatch.renderString("Start", new Vector3f(x, y, 0.0f), 0.5f, this.mainMenuSelected == 0 ? gray : white);
        this.spriteBatch.renderString("Highscore", new Vector3f(x - 60.0f, y + 60.0f, 0.0f), 0.5f, this.mainMenuSelected == 1 ? gray : white);
        this.spriteBatch.renderString("Help", new Vector3f(x + 10.0f, y + 120.0f, 0.0f), 0.5f, this.mainMenuSelected == 2 ? gray : white);
        this.spriteBatch.renderString("Exit", new Vector3f(x + 15.0f, y + 180.0f, 0.0f), 0.5f, this.mainMenuSelected == 3 ? gray : white);
        this.spriteBatch.end();
        this.activeProgram2D.disable();
        this.window.swapBuffers();
    }

    private void renderLoadingScreen() {
        GL11.glClear(16640);
        this.initOrtho();
        this.spriteBatch.begin(this.activeProgram2D);
        Matrix4f scale = Matrix4f.scaleX(this.settings.width).multiply(Matrix4f.scaleY(this.settings.height));
        Matrix4f m = Matrix4f.translate(new Vector3f(0.0f, 0.0f, 0.0f)).multiply(scale);
        String path = "textures/loadingscreen2.png";
        int width = 0;
        int height = 0;
        int[] pixels = null;
        try {
            InputStream in = Utilities.class.getResourceAsStream("/" + path);
            BufferedImage image = ImageIO.read(in);
            width = image.getWidth();
            height = image.getHeight();
            pixels = new int[width * height];
            image.getRGB(0, 0, width, height, pixels, 0, width);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int[] data = new int[width * height];
        int i = 0;
        while (i < width * height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL11.glBindTexture(3553, result);
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, Utilities.createIntBuffer(data));
        GL11.glBindTexture(3553, 0);
        this.spriteBatch.render(result, m);
        this.spriteBatch.end();
        this.activeProgram2D.disable();
        this.window.swapBuffers();
    }

    public void initOrtho() {
        this.activeProgram2D.enable();
        GL13.glActiveTexture(33984);
        int textureUniform = this.activeProgram2D.getUniform("texSampler");
        GL20.glUniform1i(textureUniform, 0);
        Matrix4f proj = Matrix4f.orthoProjection(this.window.getWidth(), 0.0f, 0.0f, this.window.getHeight(), 0.1f, 100.0f);
        int pv = this.activeProgram2D.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, proj.toFloatBuffer());
    }

    public void render(long tick) {
        javax.vecmath.Matrix4f mat;
        ++this.i;
        this.meshBatch.begin(this.activeProgram, this.camera, this.window);
        if (DEBUG_SHOW_TRAFFIC_NODES) {
            for (TrafficInfo.Node n : this.trafficInfo.getNodes()) {
                mat = new javax.vecmath.Matrix4f();
                mat.setIdentity();
                mat.setScale(0.5f);
                mat.setTranslation(new javax.vecmath.Vector3f(n.pos.x, 1.0f, n.pos.z));
                this.meshBatch.render(Mesh.TEXTURED_BOX_TEST, Texture.RED, mat);
            }
        }
        if (DEBUG_SHOW_TRAFFIC_PATH) {
            float p2 = (float)((double)System.currentTimeMillis() * 0.1 % 100.0 * 0.01);
            float p1 = 1.0f - p2;
            for (TrafficInfo.Node n1 : this.trafficInfo.getNodes()) {
                for (TrafficInfo.Node n2 : n1.next) {
                    javax.vecmath.Matrix4f mat2 = new javax.vecmath.Matrix4f();
                    mat2.setIdentity();
                    mat2.setScale(0.5f);
                    mat2.setTranslation(new javax.vecmath.Vector3f(n1.pos.x * p1 + n2.pos.x * p2, 1.0f, n1.pos.z * p1 + n2.pos.z * p2));
                    this.meshBatch.render(Mesh.TEXTURED_BOX_TEST, Texture.RED, mat2);
                }
            }
        }
        if (DEBUG_SHOW_CAMERA_POS) {
            javax.vecmath.Vector3f from = this.playerCar.getCenter();
            from.y += 3.0f;
            javax.vecmath.Vector3f v = this.physics.rayTest(from, new javax.vecmath.Vector3f(this.camera.pos.x, this.camera.pos.y, this.camera.pos.z));
            if (v != null) {
                mat = new javax.vecmath.Matrix4f();
                mat.setIdentity();
                mat.setScale(0.5f);
                mat.setTranslation(v);
                this.meshBatch.render(Mesh.TEXTURED_BOX_TEST, Texture.RED, mat);
            }
        }
        for (Entity e : this.entities) {
            if (e.getState() == Entity.State.HIDDEN) continue;
            e.render(this.meshBatch);
        }
        javax.vecmath.Matrix4f mat3 = new javax.vecmath.Matrix4f();
        mat3.setIdentity();
        mat3.setScale(8000.0f);
        this.meshBatch.render(Mesh.SKYBOX, Texture.SKYBOX, mat3);
        this.missionHandler.render3D(this.meshBatch);
        Matrix4f m = Matrix4f.translate(new Vector3f(-10.0f, 0.0f, 0.0f)).multiply(Matrix4f.scale(20.0f));
        this.meshBatch.end();
        this.spriteBatch.begin(this.activeProgram2D);
        this.initOrtho();
        this.missionHandler.renderMiniMap(this.spriteBatch, this.activeProgram2D, this.activeProgramMap, tick);
        if (DEBUG_SHOW_FPS) {
            this.spriteBatch.renderString("" + this.current_FPS, new Vector3f(this.window.getWidth() - 200.0f, this.window.getHeight() - 300.0f, 0.6f));
        }
        this.missionHandler.render2D(this.spriteBatch, tick);
        this.playerCar.render2D(this.spriteBatch);
        this.radio.render2D(this.spriteBatch, this.settings);
        this.spriteBatch.end();
        this.activeProgram2D.disable();
        this.window.swapBuffers();
    }

    public void free() {
        if (this.missionHandler != null) {
            this.missionHandler.free();
        }
        this.activeProgram.free();
        this.activeProgram2D.free();
        this.activeProgramMap.free();
        this.spriteBatch.free();
        this.meshBatch.free();
        this.window.destroy();
    }

    private static enum GameState {
        MAIN_MENU,
        INGAME,
        END,
        SHOW_HIGHSCORE,
        INTRO,
        HELP;

    }

    private static enum Mode {
        FREE_ROAM,
        DRIVE_CAR;

    }
}

