/*
 * Decompiled with CFR 0.152.
 */
package game;

import GLEngine.FBO;
import GLEngine.GLSLProgram;
import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.SpriteBatch;
import GLEngine.Texture;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import GLEngine.Window;
import entity.PlayerVehicle;
import game.Game;
import java.util.ArrayList;
import java.util.Collections;
import javax.sound.sampled.Clip;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import sound.Sound;

public class MissionHandler {
    private Sound sound;
    public long score = 0L;
    private ArrayList<WaitingCustomer> waitingCustomers = new ArrayList();
    private ArrayList<InCarCustomer> inCarCustomers = new ArrayList();
    private PlayerVehicle playerVehicle;
    private ArrayList<Vector3f> nodes;
    static FBO mapFBO;
    private static String[] names;
    private static Vector3f[] colors;
    private int currentColor = 0;
    private static final float TARGET_RADIUS = 6.0f;
    public ScorePopup scorePopup = new ScorePopup();
    private long nextCounter = 300L;
    private boolean hasPotentialCustomer = false;
    private long potentialCounter;
    private Clip phoneClip = null;

    static {
        names = new String[]{"Skalle-Per", "Bengt", "Lola", "Bosse", "Greta", "Anna", "Stenar", "Britt-Marie", "Sixten", "Hanna", "Ingrid", "Rudolf", "Anders", "T0rsteN", "Jocke", "Eva", "Cho", "Benny", "Lotta", "Johan", "Greger", "Fiolina", "Oskar", "Hans", "Ping", "Adam", "Lova", "Karin", "Georgios", "Milad", "Lina", "Tengil", "Erik", "Felix", "Rolf", "Gunnar", "Emma", "Maja", "Sofia", "Frida", "Cecilia", "Kim", "Lisa", "Kajsa", "Dimitrios", "Chi", "David", "Janis", "Per", "Elisabeth", "Linnea", "Klara", "Lille-Mor", "Berit", "Neo", "Tilda", "Ali", "Jasmine", "Markus"};
        colors = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.23137255f), new Vector3f(0.0f, 0.14901961f, 1.0f), new Vector3f(0.79607844f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.41568628f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.47843137f, 0.6156863f)};
    }

    public MissionHandler(PlayerVehicle playerVehicle, ArrayList<Vector3f> nodes, Sound sound) {
        this.playerVehicle = playerVehicle;
        this.nodes = nodes;
        mapFBO = new FBO(200, 200, true);
        this.sound = sound;
    }

    public long getDeadLine(long currentTick, float dist) {
        return currentTick + (long)((int)(15.0f + dist / 10.0f) * 60);
    }

    /*
     * WARNING - void declaration
     */
    public boolean update(long tick) {
        void var3_9;
        void var3_7;
        --this.potentialCounter;
        if (this.potentialCounter == 0L && this.hasPotentialCustomer) {
            this.score -= 50L;
            this.score = this.score < 0L ? 0L : this.score;
            this.scorePopup.change = -50;
            this.scorePopup.startTick = tick;
            this.sound.play(Sound.ERROR);
        }
        if (this.potentialCounter < 0L) {
            this.hasPotentialCustomer = false;
        }
        --this.nextCounter;
        if (this.nextCounter <= 0L && !this.hasPotentialCustomer) {
            this.hasPotentialCustomer = true;
            this.potentialCounter = 300L;
            this.nextCounter = Game.DEBUG_SHORT_SPAWN_TIME ? (long)(300.0 * Math.random()) + 300L : 900L;
            this.phoneClip = this.sound.play(Sound.PHONE);
        }
        for (WaitingCustomer waitingCustomer : this.waitingCustomers) {
            if (waitingCustomer.tooLate(tick)) {
                return true;
            }
            waitingCustomer.update(tick);
        }
        for (InCarCustomer inCarCustomer : this.inCarCustomers) {
            if (inCarCustomer.tooLate(tick)) {
                return true;
            }
            inCarCustomer.update(tick);
        }
        boolean bl = false;
        while (var3_7 < this.waitingCustomers.size()) {
            if (this.waitingCustomers.get((int)var3_7).shouldBeRemoved) {
                this.waitingCustomers.remove((int)var3_7);
                --var3_7;
            }
            ++var3_7;
        }
        boolean bl2 = false;
        while (var3_9 < this.inCarCustomers.size()) {
            if (this.inCarCustomers.get((int)var3_9).shouldBeRemoved) {
                this.inCarCustomers.remove((int)var3_9);
                --var3_9;
            }
            ++var3_9;
        }
        return false;
    }

    public void updateInput(long tick) {
        if (InputHandler.down(32) && this.hasPotentialCustomer) {
            WaitingCustomer wc = new WaitingCustomer(tick, colors[this.currentColor % colors.length]);
            ++this.currentColor;
            this.waitingCustomers.add(wc);
            this.hasPotentialCustomer = false;
            if (this.phoneClip != null) {
                this.phoneClip.close();
            }
        }
    }

    public void render2D(SpriteBatch spriteBatch, long tick) {
        Vector3f renderPos = new Vector3f(80.0f, 20.0f, 0.0f);
        spriteBatch.renderString("Score:" + this.score, renderPos, 0.6f);
        if (this.hasPotentialCustomer && (this.potentialCounter > 120L || this.potentialCounter % 20L > 10L)) {
            float xpos = Window.width / 2 + 120;
            float ypos = Window.height / 2 + 50;
            Matrix4f m = Matrix4f.translate(new Vector3f(xpos, ypos, 0.0f)).multiply(Matrix4f.scale(50.0f));
            spriteBatch.renderString("New customer!", new Vector3f(xpos - 320.0f, ypos + 50.0f, 0.0f), 0.6f, new Vector3f(1.0f, 1.0f, 1.0f));
            spriteBatch.renderString("Accept with Space", new Vector3f(xpos - 360.0f, ypos + 100.0f, 0.0f), 0.6f, new Vector3f(1.0f, 1.0f, 1.0f));
        }
        ArrayList<Customer> allCustomers = new ArrayList<Customer>();
        allCustomers.addAll(this.waitingCustomers);
        allCustomers.addAll(this.inCarCustomers);
        Collections.sort(allCustomers);
        int i = 0;
        while (i < allCustomers.size()) {
            Customer c = (Customer)allCustomers.get(i);
            float ypos = 150 + i * 100;
            float xpos = 20.0f;
            Matrix4f m = Matrix4f.translate(new Vector3f(10.0f, ypos, 0.0f)).multiply(Matrix4f.scale(50.0f));
            long timeLeft = (c.deadline - tick) / 60L;
            Vector3f white = new Vector3f(1.0f, 1.0f, 1.0f);
            Vector3f red = new Vector3f(1.0f, 0.0f, 0.0f);
            if (c instanceof WaitingCustomer) {
                spriteBatch.render(Texture.CIRCLE, m, c.color);
                spriteBatch.renderString("" + timeLeft, new Vector3f(xpos + 60.0f, ypos + -8.0f, 0.0f), 0.7f, timeLeft <= 10L ? red : white);
                spriteBatch.renderString("Get " + c.name, new Vector3f(xpos - 5.0f, ypos + 60.0f, 0.0f), 0.3f);
            } else {
                spriteBatch.render(Texture.RECTANGLE, m, c.color);
                spriteBatch.renderString("" + timeLeft, new Vector3f(xpos + 60.0f, ypos + -8.0f, 0.0f), 0.7f, timeLeft <= 10L ? red : white);
                spriteBatch.renderString("Leave " + c.name, new Vector3f(xpos - 5.0f, ypos + 60.0f, 0.0f), 0.3f);
            }
            ++i;
        }
        Vector3f green = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f red = new Vector3f(1.0f, 0.0f, 0.0f);
        if (tick - this.scorePopup.startTick <= 60L) {
            String pre = this.scorePopup.change >= 0 ? "+" : "  -";
            spriteBatch.renderString(String.valueOf(pre) + Math.abs(this.scorePopup.change), new Vector3f(Window.width / 2 - 100, Window.height / 2 - 150, 0.0f), 0.7f, this.scorePopup.change < 0 ? red : green);
        }
    }

    public void renderMiniMap(SpriteBatch spriteBatch, GLSLProgram shader, GLSLProgram activeProgramMap, long tick) {
        float[] color2;
        Matrix4f fix;
        Matrix4f trans;
        float cond;
        Vector3f wcp;
        float len;
        Vector3f dis;
        int text;
        int mapWidth = 300;
        float zoom = 0.75f;
        float scale = (float)Texture.MINIMAP_SIZE / (float)mapWidth * zoom;
        float iconSize = 20.0f;
        shader.disable();
        activeProgramMap.enable();
        GL30.glBindFramebuffer(36160, MissionHandler.mapFBO.fbo);
        GL11.glEnable(3042);
        Matrix4f proj = Matrix4f.orthoProjection(Texture.MINIMAP_SIZE, 0.0f, 0.0f, Texture.MINIMAP_SIZE, 0.1f, 100.0f);
        int pv = shader.getUniform("PV");
        int c = activeProgramMap.getUniform("color");
        GL20.glUniformMatrix4fv(pv, true, proj.toFloatBuffer());
        GL11.glViewport(0, 0, MissionHandler.mapFBO.width, MissionHandler.mapFBO.height);
        GL11.glClear(16640);
        float x = this.playerVehicle.getCenter().x;
        float z = this.playerVehicle.getCenter().z;
        float carRot = (float)Math.toDegrees(this.playerVehicle.getRotY());
        Matrix4f trans1 = Matrix4f.translate(new Vector3f(-0.5f, -0.5f, 0.0f));
        Matrix4f trans2 = Matrix4f.translate(new Vector3f(0.5f, 0.5f, 0.0f));
        Matrix4f view = Matrix4f.identity();
        Matrix4f mm = Matrix4f.identity();
        mm = Matrix4f.scale((float)Texture.MINIMAP_SIZE * scale);
        view = Matrix4f.translate(new Vector3f(-z * scale, -x * scale, 0.0f));
        view = Matrix4f.rotateZ(carRot).multiply(view);
        view = Matrix4f.translate(new Vector3f(Texture.MINIMAP_SIZE / 2, Texture.MINIMAP_SIZE / 2, 0.0f)).multiply(view);
        mm = view.multiply(mm);
        SpriteBatch.VAO vao = SpriteBatch.quadVAO;
        int m = activeProgramMap.getUniform("M");
        GL20.glUniformMatrix4fv(m, true, mm.toFloatBuffer());
        float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        GL20.glUniform4fv(c, Utilities.createFloatBuffer(color));
        GL11.glBindTexture(3553, Texture.MINIMAP);
        GL30.glBindVertexArray(vao.VAO);
        GL11.glDrawElements(4, 6, 5125, 0L);
        GL30.glBindVertexArray(0);
        GL11.glBindTexture(3553, 0);
        long tt = tick % 60L;
        for (WaitingCustomer waitingCustomer : this.waitingCustomers) {
            text = Texture.CIRCLE;
            dis = waitingCustomer.position.subtract(new Vector3f(x, this.playerVehicle.getCenter().y, z));
            dis.y = 0.0f;
            len = dis.length();
            wcp = new Vector3f(waitingCustomer.position.z * scale, waitingCustomer.position.x * scale, 0.0f);
            cond = (float)Texture.MINIMAP_SIZE * 0.5f / scale;
            if (len > cond * 0.88f) {
                dis = new Vector3f(dis.z, dis.x, 0.0f);
                wcp = new Vector3f(z, x, 0.0f).add(dis.normalized().multiply(cond * 0.93f));
                wcp = wcp.multiply(scale);
            }
            trans = Matrix4f.translate(wcp);
            fix = Matrix4f.translate(new Vector3f(-iconSize / 2.0f * scale, -iconSize / 2.0f * scale, 0.0f));
            mm = view.multiply(trans).multiply(fix).multiply(Matrix4f.scale(iconSize * scale));
            GL20.glUniformMatrix4fv(m, true, mm.toFloatBuffer());
            color2 = new float[]{waitingCustomer.color.x, waitingCustomer.color.y, waitingCustomer.color.z, 1.0f};
            GL20.glUniform4fv(c, Utilities.createFloatBuffer(color2));
            GL11.glBindTexture(3553, text);
            GL30.glBindVertexArray(vao.VAO);
            GL11.glDrawElements(4, 6, 5125, 0L);
            GL30.glBindVertexArray(0);
            GL11.glBindTexture(3553, 0);
        }
        for (InCarCustomer inCarCustomer : this.inCarCustomers) {
            text = Texture.RECTANGLE;
            dis = inCarCustomer.targetPosition.subtract(new Vector3f(x, this.playerVehicle.getCenter().y, z));
            dis.y = 0.0f;
            len = dis.length();
            wcp = new Vector3f(inCarCustomer.targetPosition.z * scale, inCarCustomer.targetPosition.x * scale, 0.0f);
            cond = (float)Texture.MINIMAP_SIZE * 0.5f / scale;
            if (len > cond * 0.94f) {
                dis = new Vector3f(dis.z, dis.x, 0.0f);
                wcp = new Vector3f(z, x, 0.0f).add(dis.normalized().multiply(cond * 0.93f));
                wcp = wcp.multiply(scale);
            }
            trans = Matrix4f.translate(wcp);
            fix = Matrix4f.translate(new Vector3f(-iconSize / 2.0f * scale, -iconSize / 2.0f * scale, 0.0f));
            mm = view.multiply(trans).multiply(fix).multiply(Matrix4f.scale(iconSize * scale));
            GL20.glUniformMatrix4fv(m, true, mm.toFloatBuffer());
            color2 = new float[]{inCarCustomer.color.x, inCarCustomer.color.y, inCarCustomer.color.z, 1.0f};
            GL20.glUniform4fv(c, Utilities.createFloatBuffer(color2));
            GL11.glBindTexture(3553, text);
            GL30.glBindVertexArray(vao.VAO);
            GL11.glDrawElements(4, 6, 5125, 0L);
            GL30.glBindVertexArray(0);
            GL11.glBindTexture(3553, 0);
        }
        activeProgramMap.disable();
        shader.enable();
        GL30.glBindFramebuffer(36160, 0);
        GL11.glViewport(0, 0, Window.width, Window.height);
        proj = Matrix4f.orthoProjection(Window.width, 0.0f, 0.0f, Window.height, 0.1f, 100.0f);
        pv = shader.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, proj.toFloatBuffer());
        Matrix4f matrix4f = Matrix4f.scale(mapWidth);
        trans1 = trans2.multiply(Matrix4f.rotateZ(-carRot)).multiply(trans1);
        Matrix4f t = Matrix4f.translate(new Vector3f(Window.width - mapWidth, 0.0f, 0.0f));
        Matrix4f m2 = t.multiply(matrix4f);
        spriteBatch.render(Texture.CIRCLE2, m2);
        spriteBatch.render(MissionHandler.mapFBO.shadowmap, m2);
        spriteBatch.render(Texture.MINIMAP_BORDER, m2);
        Matrix4f t2 = Matrix4f.translate(new Vector3f(mapWidth / 2 - 5, mapWidth / 2 - 5, 0.0f));
        Matrix4f large = t2.multiply(t).multiply(Matrix4f.scaleX(13.0f)).multiply(Matrix4f.scaleY(13.0f));
        Matrix4f small = t2.multiply(t).multiply(Matrix4f.scaleX(10.0f)).multiply(Matrix4f.scaleY(10.0f));
        spriteBatch.render(Texture.TRIANGLE, large, new Vector3f(1.0f, 1.0f, 0.0f));
    }

    public void render3D(MeshBatch meshBatch) {
        javax.vecmath.Matrix4f mat;
        for (WaitingCustomer waitingCustomer : this.waitingCustomers) {
            mat = new javax.vecmath.Matrix4f();
            mat.setIdentity();
            mat.setScale(1.0f);
            mat.rotY((float)(-Math.atan2(waitingCustomer.position.z - this.playerVehicle.getCenter().z, waitingCustomer.position.x - this.playerVehicle.getCenter().x) - Math.PI));
            mat.setTranslation(new javax.vecmath.Vector3f(waitingCustomer.position.x, waitingCustomer.position.y - 0.6f, waitingCustomer.position.z));
            meshBatch.render(Mesh.FOX, Texture.FOX, mat, new Vector3f(1.0f, 1.0f, 1.0f));
            mat.setIdentity();
            mat.setScale(1.0f);
            mat.setTranslation(new javax.vecmath.Vector3f(waitingCustomer.position.x, waitingCustomer.position.y + 6.0f, waitingCustomer.position.z));
            meshBatch.render(Mesh.ARROW, Texture.RECTANGLE, mat, waitingCustomer.color);
        }
        for (InCarCustomer inCarCustomer : this.inCarCustomers) {
            mat = new javax.vecmath.Matrix4f();
            mat.setIdentity();
            mat.setScale(1.0f);
            mat.setTranslation(new javax.vecmath.Vector3f(inCarCustomer.targetPosition.x, inCarCustomer.targetPosition.y + 2.0f, inCarCustomer.targetPosition.z));
            meshBatch.render(Mesh.ARROW, Texture.RECTANGLE, mat, inCarCustomer.color);
        }
    }

    public long getScore() {
        return this.score;
    }

    public int getCustomersInCar() {
        return this.inCarCustomers.size() + this.waitingCustomers.size();
    }

    public void free() {
        mapFBO.free();
    }

    abstract class Customer
    implements Comparable<Customer> {
        String name = "";
        long deadline;
        Vector3f targetPosition;
        boolean shouldBeRemoved = false;
        Vector3f color;

        public Customer(Vector3f color, String name) {
            this.color = color;
            this.name = name;
        }

        public boolean tooLate(long tick) {
            return tick > this.deadline;
        }

        @Override
        public int compareTo(Customer c) {
            if (this.deadline < c.deadline) {
                return -1;
            }
            if (this.deadline > c.deadline) {
                return 1;
            }
            return 0;
        }
    }

    class InCarCustomer
    extends Customer {
        public InCarCustomer(WaitingCustomer wc, long tick, PlayerVehicle pv) {
            super(wc.color, wc.name);
            this.targetPosition = wc.targetPosition;
            float dist = this.targetPosition.distanceTo(new Vector3f(pv.getCenter().x, pv.getCenter().y, pv.getCenter().z));
            this.deadline = MissionHandler.this.getDeadLine(tick, dist);
            pv.pickUpCustomer();
            MissionHandler.this.sound.play(Sound.PICK_UP);
        }

        public void update(long tick) {
            if (this.targetPosition.distanceTo(Vector3f.toVector(MissionHandler.this.playerVehicle.getCenter())) < 6.0f) {
                this.shouldBeRemoved = true;
                MissionHandler.this.score += (long)(100 * MissionHandler.this.getCustomersInCar());
                MissionHandler.this.scorePopup.change = 100 * MissionHandler.this.getCustomersInCar();
                MissionHandler.this.scorePopup.startTick = tick;
                MissionHandler.this.sound.play(Sound.SCORE);
            }
        }
    }

    class ScorePopup {
        public int change = 0;
        public long startTick = -1000L;

        ScorePopup() {
        }
    }

    class WaitingCustomer
    extends Customer {
        Vector3f position;

        public WaitingCustomer(long createdTick, Vector3f color) {
            int i;
            super(color, names[(int)(Math.random() * (double)names.length)]);
            this.position = (Vector3f)MissionHandler.this.nodes.get((int)(Math.random() * (double)MissionHandler.this.nodes.size()));
            int i0 = i = (int)(Math.random() * (double)MissionHandler.this.nodes.size());
            int minDis = 100;
            if (this.position.distanceTo((Vector3f)MissionHandler.this.nodes.get(i)) < (float)minDis) {
                int j = i;
                while (j < MissionHandler.this.nodes.size() * 2) {
                    if (((Vector3f)MissionHandler.this.nodes.get(i)).distanceTo((Vector3f)MissionHandler.this.nodes.get(j % MissionHandler.this.nodes.size())) > (float)minDis) {
                        i = j % MissionHandler.this.nodes.size();
                        break;
                    }
                    ++j;
                }
                if (i == i0) {
                    throw new RuntimeException("Can not find a good node");
                }
            }
            this.targetPosition = (Vector3f)MissionHandler.this.nodes.get(i);
            float dist = this.position.distanceTo(new Vector3f(((MissionHandler)MissionHandler.this).playerVehicle.getCenter().x, ((MissionHandler)MissionHandler.this).playerVehicle.getCenter().y, ((MissionHandler)MissionHandler.this).playerVehicle.getCenter().z));
            this.deadline = MissionHandler.this.getDeadLine(createdTick, dist);
        }

        public void update(long tick) {
            if (this.position.distanceTo(Vector3f.toVector(MissionHandler.this.playerVehicle.getCenter())) < 6.0f) {
                this.shouldBeRemoved = true;
                MissionHandler.this.inCarCustomers.add(new InCarCustomer(this, tick, MissionHandler.this.playerVehicle));
            }
        }
    }
}

