/*
 * Decompiled with CFR 0.152.
 */
package game;

import GLEngine.Vector3f;
import entity.VehicleEntity;
import java.util.ArrayList;

public class TrafficInfo {
    private ArrayList<VehicleEntity> vehicles = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private int nextBatchId = 0;
    ArrayList<Batch> batches = new ArrayList();

    public void addVehicle(VehicleEntity aiVehicle) {
        this.vehicles.add(aiVehicle);
    }

    public ArrayList<VehicleEntity> getCarsWithin(VehicleEntity vehicle, double max) {
        ArrayList<VehicleEntity> nearby = new ArrayList<VehicleEntity>();
        Vector3f pos = new Vector3f(vehicle.getCenter().x, vehicle.getCenter().y, vehicle.getCenter().z);
        for (VehicleEntity v : this.vehicles) {
            if (v == vehicle) continue;
            Vector3f vector3f = new Vector3f(v.getCenter().x, v.getCenter().y, v.getCenter().z);
            if (!((double)vector3f.distanceTo(pos) < max)) continue;
            nearby.add(v);
        }
        return nearby;
    }

    public ArrayList<Node> getNodes() {
        return this.nodes;
    }

    public void newNodeBatch() {
        if (this.batches.size() != 0) {
            for (IntermediateNode in : this.batches.get((int)(this.batches.size() - 1)).nodes) {
                if (in.prev == -1) continue;
                this.batches.get((int)(this.batches.size() - 1)).nodes.get((int)in.prev).last = false;
            }
        }
        this.batches.add(new Batch());
    }

    public void addIntermediateNode(javax.vecmath.Vector3f pos, int prev) {
        this.batches.get((int)(this.batches.size() - 1)).nodes.add(new IntermediateNode(pos.x, pos.z, prev));
    }

    public void createFinalInfo() {
        for (IntermediateNode in : this.batches.get((int)(this.batches.size() - 1)).nodes) {
            if (in.prev == -1) continue;
            this.batches.get((int)(this.batches.size() - 1)).nodes.get((int)in.prev).last = false;
        }
        ArrayList<Boolean> first = new ArrayList<Boolean>();
        ArrayList<Boolean> last = new ArrayList<Boolean>();
        ArrayList<Integer> batchNums = new ArrayList<Integer>();
        int bi = 0;
        for (Batch b : this.batches) {
            ArrayList<Node> batchNodes = new ArrayList<Node>();
            for (IntermediateNode in : b.nodes) {
                batchNodes.add(new Node(in.x, in.z));
                first.add(in.prev == -1);
                last.add(in.last);
                batchNums.add(bi);
            }
            int i = 0;
            while (i < b.nodes.size()) {
                if (b.nodes.get((int)i).prev != -1) {
                    ((Node)batchNodes.get((int)b.nodes.get((int)i).prev)).next.add((Node)batchNodes.get(i));
                }
                ++i;
            }
            this.nodes.addAll(batchNodes);
            ++bi;
        }
        int i = 0;
        for (Node p : this.nodes) {
            if (((Boolean)last.get(i)).booleanValue()) {
                int j = 0;
                for (Node n : this.nodes) {
                    if (batchNums.get(i) != batchNums.get(j) && p != n && ((Boolean)first.get(j)).booleanValue()) {
                        if (p.next.isEmpty()) {
                            p.next.add(n);
                        } else {
                            double dx = p.pos.x - n.pos.x;
                            double dz = p.pos.z - n.pos.z;
                            double dxCurrent = p.pos.x - p.next.get((int)0).pos.x;
                            double dzCurrent = p.pos.z - p.next.get((int)0).pos.z;
                            if (dx * dx + dz * dz < dxCurrent * dxCurrent + dzCurrent * dzCurrent) {
                                p.next.set(0, n);
                            }
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    class Batch {
        ArrayList<IntermediateNode> nodes = new ArrayList();

        Batch() {
        }
    }

    class IntermediateNode {
        float x;
        float z;
        int prev;
        boolean last = true;

        public IntermediateNode(float x, float z, int prev) {
            this.x = x;
            this.z = z;
            this.prev = prev;
        }
    }

    public class Node {
        public Vector3f pos = new Vector3f();
        ArrayList<Node> next = new ArrayList();

        public Node(float x, float z) {
            this.pos.x = x;
            this.pos.z = z;
        }

        public Node getNext() {
            if (this.next.size() == 0) {
                return null;
            }
            return this.next.get((int)(Math.random() * (double)this.next.size()));
        }

        public ArrayList<Node> getAllNext() {
            return this.next;
        }
    }
}

