/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryUtil;

public final class BufferUtils {
    private static final BufferAllocator BUFFER_ALLOCATOR = BufferUtils.getDefaultAllocator();

    private BufferUtils() {
    }

    private static BufferAllocator getDefaultAllocator() {
        String alignment = System.getProperty("org.lwjgl.util.BufferAlign", "default");
        if ("page".equals(alignment)) {
            return new BufferAllocator(){

                @Override
                public ByteBuffer malloc(int capacity) {
                    return BufferUtils.createAlignedByteBufferPage(capacity);
                }
            };
        }
        if ("cache-line".equals(alignment)) {
            return new BufferAllocator(){

                @Override
                public ByteBuffer malloc(int capacity) {
                    return BufferUtils.createAlignedByteBufferCacheLine(capacity);
                }
            };
        }
        if ("default".equals(alignment)) {
            return new BufferAllocator(){

                @Override
                public ByteBuffer malloc(int capacity) {
                    return BufferUtils.createUnalignedByteBuffer(capacity);
                }
            };
        }
        try {
            final int bytes = Integer.parseInt(alignment);
            if (MathUtil.mathIsPoT(bytes) && 8 < bytes) {
                return new BufferAllocator(){

                    @Override
                    public ByteBuffer malloc(int capacity) {
                        return BufferUtils.createAlignedByteBuffer(capacity, bytes);
                    }
                };
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException(String.format("Invalid org.lwjgl.util.BufferAlign value: \"%s\". It must be one of {page, cache-line, default} or a power-of-two integer > 8.", alignment));
    }

    public static ByteBuffer createByteBuffer(int capacity) {
        return BUFFER_ALLOCATOR.malloc(capacity).order(ByteOrder.nativeOrder());
    }

    public static ShortBuffer createShortBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 1).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 1).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 2).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 3).asLongBuffer();
    }

    public static FloatBuffer createFloatBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int capacity) {
        return BufferUtils.createByteBuffer(capacity << 3).asDoubleBuffer();
    }

    public static PointerBuffer createPointerBuffer(int capacity) {
        return PointerBuffer.allocateDirect(capacity);
    }

    public static ByteBuffer createUnalignedByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer createAlignedByteBuffer(int capacity, int alignment) {
        if (LWJGLUtil.DEBUG && !MathUtil.mathIsPoT(alignment)) {
            throw new IllegalArgumentException("The alignment value must be a power-of-two integer.");
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + alignment);
        buffer.position(alignment - (int)(MemoryUtil.memAddress(buffer) & (long)(alignment - 1)));
        buffer.limit(buffer.position() + capacity);
        return buffer.slice().order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer createAlignedByteBufferPage(int capacity) {
        return BufferUtils.createAlignedByteBuffer(capacity, MemoryUtil.PAGE_SIZE);
    }

    public static ByteBuffer createAlignedByteBufferCacheLine(int capacity) {
        return BufferUtils.createAlignedByteBuffer(capacity, 64);
    }

    public static void zeroBuffer(ByteBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining());
    }

    public static void zeroBuffer(ShortBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 1);
    }

    public static void zeroBuffer(CharBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 1);
    }

    public static void zeroBuffer(IntBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 2);
    }

    public static void zeroBuffer(FloatBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 2);
    }

    public static void zeroBuffer(LongBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 3);
    }

    public static void zeroBuffer(DoubleBuffer buffer) {
        MemoryUtil.memSet(MemoryUtil.memAddress(buffer), 0, buffer.remaining() << 3);
    }

    private static interface BufferAllocator {
        public ByteBuffer malloc(int var1);
    }
}

