/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLBusAddressAMD
implements Pointer {
    public static final int SIZEOF;
    public static final int SURFACE_BUS_ADDRESS;
    public static final int MARKER_BUS_ADDRESS;
    private final ByteBuffer struct;

    public CLBusAddressAMD() {
        this(CLBusAddressAMD.malloc());
    }

    public CLBusAddressAMD(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setSurfaceBusAddress(long surface_bus_address) {
        CLBusAddressAMD.surface_bus_address(this.struct, surface_bus_address);
    }

    public void setMarkerBusAddress(long marker_bus_address) {
        CLBusAddressAMD.marker_bus_address(this.struct, marker_bus_address);
    }

    public long getSurfaceBusAddress() {
        return CLBusAddressAMD.surface_bus_address(this.struct);
    }

    public long getMarkerBusAddress() {
        return CLBusAddressAMD.marker_bus_address(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long surface_bus_address, long marker_bus_address) {
        ByteBuffer cl_bus_address_amd = CLBusAddressAMD.malloc();
        CLBusAddressAMD.surface_bus_address(cl_bus_address_amd, surface_bus_address);
        CLBusAddressAMD.marker_bus_address(cl_bus_address_amd, marker_bus_address);
        return cl_bus_address_amd;
    }

    public static void surface_bus_address(ByteBuffer cl_bus_address_amd, long surface_bus_address) {
        cl_bus_address_amd.putLong(cl_bus_address_amd.position() + SURFACE_BUS_ADDRESS, surface_bus_address);
    }

    public static void marker_bus_address(ByteBuffer cl_bus_address_amd, long marker_bus_address) {
        cl_bus_address_amd.putLong(cl_bus_address_amd.position() + MARKER_BUS_ADDRESS, marker_bus_address);
    }

    public static long surface_bus_address(ByteBuffer cl_bus_address_amd) {
        return cl_bus_address_amd.getLong(cl_bus_address_amd.position() + SURFACE_BUS_ADDRESS);
    }

    public static long marker_bus_address(ByteBuffer cl_bus_address_amd) {
        return cl_bus_address_amd.getLong(cl_bus_address_amd.position() + MARKER_BUS_ADDRESS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = CLBusAddressAMD.offsets(MemoryUtil.memAddress(offsets));
        SURFACE_BUS_ADDRESS = offsets.get(0);
        MARKER_BUS_ADDRESS = offsets.get(1);
    }
}

