/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLDeviceTopologyAMD
implements Pointer {
    public static final int SIZEOF;
    public static final int RAW;
    public static final int RAW_TYPE;
    public static final int RAW_DATA;
    public static final int PCIE;
    public static final int PCIE_TYPE;
    public static final int PCIE_BUS;
    public static final int PCIE_DEVICE;
    public static final int PCIE_FUNCTION;
    private final ByteBuffer struct;

    public CLDeviceTopologyAMD() {
        this(CLDeviceTopologyAMD.malloc());
    }

    public CLDeviceTopologyAMD(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setRawType(int type) {
        CLDeviceTopologyAMD.rawType(this.struct, type);
    }

    public void setRawData(ByteBuffer data) {
        CLDeviceTopologyAMD.rawDataSet(this.struct, data);
    }

    public void setRawData(int index, int data) {
        CLDeviceTopologyAMD.rawData(this.struct, index, data);
    }

    public void setPcieType(int type) {
        CLDeviceTopologyAMD.pcieType(this.struct, type);
    }

    public void setPcieBus(int bus) {
        CLDeviceTopologyAMD.pcieBus(this.struct, bus);
    }

    public void setPcieDevice(int device) {
        CLDeviceTopologyAMD.pcieDevice(this.struct, device);
    }

    public void setPcieFunction(int function) {
        CLDeviceTopologyAMD.pcieFunction(this.struct, function);
    }

    public int getRawType() {
        return CLDeviceTopologyAMD.rawType(this.struct);
    }

    public void getRawData(ByteBuffer data) {
        CLDeviceTopologyAMD.rawDataGet(this.struct, data);
    }

    public int getPcieType() {
        return CLDeviceTopologyAMD.pcieType(this.struct);
    }

    public int getPcieBus() {
        return CLDeviceTopologyAMD.pcieBus(this.struct);
    }

    public int getPcieDevice() {
        return CLDeviceTopologyAMD.pcieDevice(this.struct);
    }

    public int getPcieFunction() {
        return CLDeviceTopologyAMD.pcieFunction(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int raw_type, ByteBuffer raw_data, int pcie_type, int pcie_bus, int pcie_device, int pcie_function) {
        ByteBuffer cl_device_topology_amd = CLDeviceTopologyAMD.malloc();
        CLDeviceTopologyAMD.rawType(cl_device_topology_amd, raw_type);
        CLDeviceTopologyAMD.rawDataSet(cl_device_topology_amd, raw_data);
        CLDeviceTopologyAMD.pcieType(cl_device_topology_amd, pcie_type);
        CLDeviceTopologyAMD.pcieBus(cl_device_topology_amd, pcie_bus);
        CLDeviceTopologyAMD.pcieDevice(cl_device_topology_amd, pcie_device);
        CLDeviceTopologyAMD.pcieFunction(cl_device_topology_amd, pcie_function);
        return cl_device_topology_amd;
    }

    public static void rawType(ByteBuffer cl_device_topology_amd, int type) {
        cl_device_topology_amd.putInt(cl_device_topology_amd.position() + RAW_TYPE, type);
    }

    public static void rawDataSet(ByteBuffer cl_device_topology_amd, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(data, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(data), MemoryUtil.memAddress(cl_device_topology_amd) + (long)RAW_DATA, data.remaining());
    }

    public static void rawData(ByteBuffer cl_device_topology_amd, int index, int data) {
        cl_device_topology_amd.putInt(RAW_DATA + index * 4, data);
    }

    public static void pcieType(ByteBuffer cl_device_topology_amd, int type) {
        cl_device_topology_amd.putInt(cl_device_topology_amd.position() + PCIE_TYPE, type);
    }

    public static void pcieBus(ByteBuffer cl_device_topology_amd, int bus) {
        cl_device_topology_amd.put(cl_device_topology_amd.position() + PCIE_BUS, (byte)bus);
    }

    public static void pcieDevice(ByteBuffer cl_device_topology_amd, int device) {
        cl_device_topology_amd.put(cl_device_topology_amd.position() + PCIE_DEVICE, (byte)device);
    }

    public static void pcieFunction(ByteBuffer cl_device_topology_amd, int function) {
        cl_device_topology_amd.put(cl_device_topology_amd.position() + PCIE_FUNCTION, (byte)function);
    }

    public static int rawType(ByteBuffer cl_device_topology_amd) {
        return cl_device_topology_amd.getInt(cl_device_topology_amd.position() + RAW_TYPE);
    }

    public static void rawDataGet(ByteBuffer cl_device_topology_amd, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(data, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(cl_device_topology_amd) + (long)RAW_DATA, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int rawData(ByteBuffer cl_device_topology_amd, int index) {
        return cl_device_topology_amd.getInt(RAW_DATA + index * 4);
    }

    public static int pcieType(ByteBuffer cl_device_topology_amd) {
        return cl_device_topology_amd.getInt(cl_device_topology_amd.position() + PCIE_TYPE);
    }

    public static int pcieBus(ByteBuffer cl_device_topology_amd) {
        return cl_device_topology_amd.get(cl_device_topology_amd.position() + PCIE_BUS);
    }

    public static int pcieDevice(ByteBuffer cl_device_topology_amd) {
        return cl_device_topology_amd.get(cl_device_topology_amd.position() + PCIE_DEVICE);
    }

    public static int pcieFunction(ByteBuffer cl_device_topology_amd) {
        return cl_device_topology_amd.get(cl_device_topology_amd.position() + PCIE_FUNCTION);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(8);
        SIZEOF = CLDeviceTopologyAMD.offsets(MemoryUtil.memAddress(offsets));
        RAW = offsets.get(0);
        RAW_TYPE = offsets.get(1);
        RAW_DATA = offsets.get(2);
        PCIE = offsets.get(3);
        PCIE_TYPE = offsets.get(4);
        PCIE_BUS = offsets.get(5);
        PCIE_DEVICE = offsets.get(6);
        PCIE_FUNCTION = offsets.get(7);
    }
}

