/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLImageDesc
implements Pointer {
    public static final int SIZEOF;
    public static final int IMAGE_TYPE;
    public static final int IMAGE_WIDTH;
    public static final int IMAGE_HEIGHT;
    public static final int IMAGE_DEPTH;
    public static final int IMAGE_ARRAY_SIZE;
    public static final int IMAGE_ROW_PITCH;
    public static final int IMAGE_SLICE_PITCH;
    public static final int NUM_MIP_LEVELS;
    public static final int NUM_SAMPLES;
    public static final int BUFFER;
    private final ByteBuffer struct;

    public CLImageDesc() {
        this(CLImageDesc.malloc());
    }

    public CLImageDesc(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setImageType(int image_type) {
        CLImageDesc.image_type(this.struct, image_type);
    }

    public void setImageWidth(long image_width) {
        CLImageDesc.image_width(this.struct, image_width);
    }

    public void setImageHeight(long image_height) {
        CLImageDesc.image_height(this.struct, image_height);
    }

    public void setImageDepth(long image_depth) {
        CLImageDesc.image_depth(this.struct, image_depth);
    }

    public void setImageArraySize(long image_array_size) {
        CLImageDesc.image_array_size(this.struct, image_array_size);
    }

    public void setImageRowPitch(long image_row_pitch) {
        CLImageDesc.image_row_pitch(this.struct, image_row_pitch);
    }

    public void setImageSlicePitch(long image_slice_pitch) {
        CLImageDesc.image_slice_pitch(this.struct, image_slice_pitch);
    }

    public void setNumMipLevels(int num_mip_levels) {
        CLImageDesc.num_mip_levels(this.struct, num_mip_levels);
    }

    public void setNumSamples(int num_samples) {
        CLImageDesc.num_samples(this.struct, num_samples);
    }

    public void setBuffer(long buffer) {
        CLImageDesc.buffer(this.struct, buffer);
    }

    public int getImageType() {
        return CLImageDesc.image_type(this.struct);
    }

    public long getImageWidth() {
        return CLImageDesc.image_width(this.struct);
    }

    public long getImageHeight() {
        return CLImageDesc.image_height(this.struct);
    }

    public long getImageDepth() {
        return CLImageDesc.image_depth(this.struct);
    }

    public long getImageArraySize() {
        return CLImageDesc.image_array_size(this.struct);
    }

    public long getImageRowPitch() {
        return CLImageDesc.image_row_pitch(this.struct);
    }

    public long getImageSlicePitch() {
        return CLImageDesc.image_slice_pitch(this.struct);
    }

    public int getNumMipLevels() {
        return CLImageDesc.num_mip_levels(this.struct);
    }

    public int getNumSamples() {
        return CLImageDesc.num_samples(this.struct);
    }

    public long getBuffer() {
        return CLImageDesc.buffer(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int image_type, long image_width, long image_height, long image_depth, long image_array_size, long image_row_pitch, long image_slice_pitch, int num_mip_levels, int num_samples, long buffer) {
        ByteBuffer cl_image_desc = CLImageDesc.malloc();
        CLImageDesc.image_type(cl_image_desc, image_type);
        CLImageDesc.image_width(cl_image_desc, image_width);
        CLImageDesc.image_height(cl_image_desc, image_height);
        CLImageDesc.image_depth(cl_image_desc, image_depth);
        CLImageDesc.image_array_size(cl_image_desc, image_array_size);
        CLImageDesc.image_row_pitch(cl_image_desc, image_row_pitch);
        CLImageDesc.image_slice_pitch(cl_image_desc, image_slice_pitch);
        CLImageDesc.num_mip_levels(cl_image_desc, num_mip_levels);
        CLImageDesc.num_samples(cl_image_desc, num_samples);
        CLImageDesc.buffer(cl_image_desc, buffer);
        return cl_image_desc;
    }

    public static void image_type(ByteBuffer cl_image_desc, int image_type) {
        cl_image_desc.putInt(cl_image_desc.position() + IMAGE_TYPE, image_type);
    }

    public static void image_width(ByteBuffer cl_image_desc, long image_width) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_WIDTH, image_width);
    }

    public static void image_height(ByteBuffer cl_image_desc, long image_height) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_HEIGHT, image_height);
    }

    public static void image_depth(ByteBuffer cl_image_desc, long image_depth) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_DEPTH, image_depth);
    }

    public static void image_array_size(ByteBuffer cl_image_desc, long image_array_size) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_ARRAY_SIZE, image_array_size);
    }

    public static void image_row_pitch(ByteBuffer cl_image_desc, long image_row_pitch) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_ROW_PITCH, image_row_pitch);
    }

    public static void image_slice_pitch(ByteBuffer cl_image_desc, long image_slice_pitch) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + IMAGE_SLICE_PITCH, image_slice_pitch);
    }

    public static void num_mip_levels(ByteBuffer cl_image_desc, int num_mip_levels) {
        cl_image_desc.putInt(cl_image_desc.position() + NUM_MIP_LEVELS, num_mip_levels);
    }

    public static void num_samples(ByteBuffer cl_image_desc, int num_samples) {
        cl_image_desc.putInt(cl_image_desc.position() + NUM_SAMPLES, num_samples);
    }

    public static void buffer(ByteBuffer cl_image_desc, long buffer) {
        PointerBuffer.put(cl_image_desc, cl_image_desc.position() + BUFFER, buffer);
    }

    public static int image_type(ByteBuffer cl_image_desc) {
        return cl_image_desc.getInt(cl_image_desc.position() + IMAGE_TYPE);
    }

    public static long image_width(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_WIDTH);
    }

    public static long image_height(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_HEIGHT);
    }

    public static long image_depth(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_DEPTH);
    }

    public static long image_array_size(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_ARRAY_SIZE);
    }

    public static long image_row_pitch(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_ROW_PITCH);
    }

    public static long image_slice_pitch(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + IMAGE_SLICE_PITCH);
    }

    public static int num_mip_levels(ByteBuffer cl_image_desc) {
        return cl_image_desc.getInt(cl_image_desc.position() + NUM_MIP_LEVELS);
    }

    public static int num_samples(ByteBuffer cl_image_desc) {
        return cl_image_desc.getInt(cl_image_desc.position() + NUM_SAMPLES);
    }

    public static long buffer(ByteBuffer cl_image_desc) {
        return PointerBuffer.get(cl_image_desc, cl_image_desc.position() + BUFFER);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(10);
        SIZEOF = CLImageDesc.offsets(MemoryUtil.memAddress(offsets));
        IMAGE_TYPE = offsets.get(0);
        IMAGE_WIDTH = offsets.get(1);
        IMAGE_HEIGHT = offsets.get(2);
        IMAGE_DEPTH = offsets.get(3);
        IMAGE_ARRAY_SIZE = offsets.get(4);
        IMAGE_ROW_PITCH = offsets.get(5);
        IMAGE_SLICE_PITCH = offsets.get(6);
        NUM_MIP_LEVELS = offsets.get(7);
        NUM_SAMPLES = offsets.get(8);
        BUFFER = offsets.get(9);
    }
}

