/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBTextureCompression {
    public static final int GL_COMPRESSED_ALPHA_ARB = 34025;
    public static final int GL_COMPRESSED_LUMINANCE_ARB = 34026;
    public static final int GL_COMPRESSED_LUMINANCE_ALPHA_ARB = 34027;
    public static final int GL_COMPRESSED_INTENSITY_ARB = 34028;
    public static final int GL_COMPRESSED_RGB_ARB = 34029;
    public static final int GL_COMPRESSED_RGBA_ARB = 34030;
    public static final int GL_TEXTURE_COMPRESSION_HINT_ARB = 34031;
    public static final int GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 34464;
    public static final int GL_TEXTURE_COMPRESSED_ARB = 34465;
    public static final int GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 34466;
    public static final int GL_COMPRESSED_TEXTURE_FORMATS_ARB = 34467;
    public final long CompressedTexImage3DARB;
    public final long CompressedTexImage2DARB;
    public final long CompressedTexImage1DARB;
    public final long CompressedTexSubImage3DARB;
    public final long CompressedTexSubImage2DARB;
    public final long CompressedTexSubImage1DARB;
    public final long GetCompressedTexImageARB;

    public ARBTextureCompression(FunctionProvider provider) {
        this.CompressedTexImage3DARB = provider.getFunctionAddress("glCompressedTexImage3DARB");
        this.CompressedTexImage2DARB = provider.getFunctionAddress("glCompressedTexImage2DARB");
        this.CompressedTexImage1DARB = provider.getFunctionAddress("glCompressedTexImage1DARB");
        this.CompressedTexSubImage3DARB = provider.getFunctionAddress("glCompressedTexSubImage3DARB");
        this.CompressedTexSubImage2DARB = provider.getFunctionAddress("glCompressedTexSubImage2DARB");
        this.CompressedTexSubImage1DARB = provider.getFunctionAddress("glCompressedTexSubImage1DARB");
        this.GetCompressedTexImageARB = provider.getFunctionAddress("glGetCompressedTexImageARB");
    }

    public static ARBTextureCompression getInstance() {
        return GL.getCapabilities().__ARBTextureCompression;
    }

    static ARBTextureCompression create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_texture_compression")) {
            return null;
        }
        ARBTextureCompression funcs = new ARBTextureCompression(provider);
        boolean supported = Checks.checkFunctions(funcs.CompressedTexImage3DARB, funcs.CompressedTexImage2DARB, funcs.CompressedTexImage1DARB, funcs.CompressedTexSubImage3DARB, funcs.CompressedTexSubImage2DARB, funcs.CompressedTexSubImage1DARB, funcs.GetCompressedTexImageARB);
        return GL.checkExtension("GL_ARB_texture_compression", funcs, supported);
    }

    public static native void nglCompressedTexImage3DARB(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void nglCompressedTexImage3DARB(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexImage3DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexImage3DARB(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexImage3DARB(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexImage3DARB(target, level, internalformat, width, height, depth, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage3DARB(int target, int level, int internalformat, int width, int height, int depth, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage3DARB(target, level, internalformat, width, height, depth, 0, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTexImage2DARB(int var0, int var1, int var2, int var3, int var4, int var5, int var6, long var7, long var9);

    public static void nglCompressedTexImage2DARB(int target, int level, int internalformat, int width, int height, int border, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexImage2DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexImage2DARB(int target, int level, int internalformat, int width, int height, int border, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexImage2DARB(int target, int level, int internalformat, int width, int height, int border, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexImage2DARB(target, level, internalformat, width, height, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage2DARB(int target, int level, int internalformat, int width, int height, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage2DARB(target, level, internalformat, width, height, 0, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTexImage1DARB(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void nglCompressedTexImage1DARB(int target, int level, int internalformat, int width, int border, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexImage1DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexImage1DARB(int target, int level, int internalformat, int width, int border, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexImage1DARB(int target, int level, int internalformat, int width, int border, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexImage1DARB(target, level, internalformat, width, border, imageSize, dataOffset);
    }

    public static void glCompressedTexImage1DARB(int target, int level, int internalformat, int width, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexImage1DARB(target, level, internalformat, width, 0, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTexSubImage3DARB(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void nglCompressedTexSubImage3DARB(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexSubImage3DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexSubImage3DARB(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage3DARB(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage3DARB(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage3DARB(target, level, xoffset, yoffset, zoffset, width, height, depth, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTexSubImage2DARB(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, long var8, long var10);

    public static void nglCompressedTexSubImage2DARB(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexSubImage2DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexSubImage2DARB(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage2DARB(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage2DARB(int target, int level, int xoffset, int yoffset, int width, int height, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage2DARB(target, level, xoffset, yoffset, width, height, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglCompressedTexSubImage1DARB(int var0, int var1, int var2, int var3, int var4, int var5, long var6, long var8);

    public static void nglCompressedTexSubImage1DARB(int target, int level, int xoffset, int width, int format, int imageSize, long data) {
        long __functionAddress = ARBTextureCompression.getInstance().CompressedTexSubImage1DARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, data, __functionAddress);
    }

    public static void glCompressedTexSubImage1DARB(int target, int level, int xoffset, int width, int format, int imageSize, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, imageSize);
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, MemoryUtil.memAddress(data));
    }

    public static void glCompressedTexSubImage1DARB(int target, int level, int xoffset, int width, int format, int imageSize, long dataOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        ARBTextureCompression.nglCompressedTexSubImage1DARB(target, level, xoffset, width, format, imageSize, dataOffset);
    }

    public static void glCompressedTexSubImage1DARB(int target, int level, int xoffset, int width, int format, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        ARBTextureCompression.nglCompressedTexSubImage1DARB(target, level, xoffset, width, format, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static native void nglGetCompressedTexImageARB(int var0, int var1, long var2, long var4);

    public static void nglGetCompressedTexImageARB(int target, int level, long pixels) {
        long __functionAddress = ARBTextureCompression.getInstance().GetCompressedTexImageARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBTextureCompression.nglGetCompressedTexImageARB(target, level, pixels, __functionAddress);
    }

    public static void glGetCompressedTexImageARB(int target, int level, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            if (LWJGLUtil.DEBUG) {
                Checks.checkBuffer((Buffer)pixels, GL11.glGetTexLevelParameteri(target, level, 34464));
            }
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBTextureCompression.nglGetCompressedTexImageARB(target, level, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTexImageARB(int target, int level, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBTextureCompression.nglGetCompressedTexImageARB(target, level, pixelsOffset);
    }
}

