/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class EXTPointParameters {
    public static final int GL_POINT_SIZE_MIN_EXT = 33062;
    public static final int GL_POINT_SIZE_MAX_EXT = 33063;
    public static final int GL_POINT_FADE_THRESHOLD_SIZE_EXT = 33064;
    public static final int GL_DISTANCE_ATTENUATION_EXT = 33065;
    public final long PointParameterfEXT;
    public final long PointParameterfvEXT;

    public EXTPointParameters(FunctionProvider provider) {
        this.PointParameterfEXT = provider.getFunctionAddress("glPointParameterfEXT");
        this.PointParameterfvEXT = provider.getFunctionAddress("glPointParameterfvEXT");
    }

    public static EXTPointParameters getInstance() {
        return GL.getCapabilities().__EXTPointParameters;
    }

    static EXTPointParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_point_parameters")) {
            return null;
        }
        EXTPointParameters funcs = new EXTPointParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.PointParameterfEXT, funcs.PointParameterfvEXT);
        return GL.checkExtension("GL_EXT_point_parameters", funcs, supported);
    }

    public static native void nglPointParameterfEXT(int var0, float var1, long var2);

    public static void glPointParameterfEXT(int pname, float param) {
        long __functionAddress = EXTPointParameters.getInstance().PointParameterfEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTPointParameters.nglPointParameterfEXT(pname, param, __functionAddress);
    }

    public static native void nglPointParameterfvEXT(int var0, long var1, long var3);

    public static void nglPointParameterfvEXT(int pname, long params) {
        long __functionAddress = EXTPointParameters.getInstance().PointParameterfvEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTPointParameters.nglPointParameterfvEXT(pname, params, __functionAddress);
    }

    public static void glPointParameterfvEXT(int pname, ByteBuffer params) {
        EXTPointParameters.nglPointParameterfvEXT(pname, MemoryUtil.memAddress(params));
    }

    public static void glPointParameterfvEXT(int pname, FloatBuffer params) {
        EXTPointParameters.nglPointParameterfvEXT(pname, MemoryUtil.memAddress(params));
    }
}

