/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLX;
import org.lwjgl.opengl.GLX12;
import org.lwjgl.opengl.GLX13;
import org.lwjgl.opengl.GLXSGIMakeCurrentRead;
import org.lwjgl.opengl.OpenGLException;

public class GLContextLinux
extends GLContext {
    private final long display;
    private final long ctx;
    private final MakeCurrentAction makeCurrentAction;

    public GLContextLinux(ContextCapabilities capabilities, long display, long ctx) {
        super(capabilities);
        this.display = display;
        this.ctx = ctx;
        this.makeCurrentAction = capabilities.GLX_13 ? new MakeCurrentActionARB() : (capabilities.GLX_SGI_make_current_read ? new MakeCurrentActionSGI() : null);
    }

    @Override
    public long getPointer() {
        return this.ctx;
    }

    @Override
    protected void makeCurrentImpl(long target) {
        if (GLX.glXMakeCurrent(this.display, target, this.ctx) == 0) {
            throw new RuntimeException("Failed to make the OpenGL context current.");
        }
    }

    @Override
    protected void makeCurrentImpl(long targetDraw, long targetRead) {
        if (this.makeCurrentAction.invoke(this.display, targetDraw, targetRead, this.ctx) == 0) {
            throw new RuntimeException("Failed to make the OpenGL context current.");
        }
    }

    @Override
    public boolean isCurrent() {
        return GLX.glXGetCurrentContext() == this.ctx;
    }

    public static GLContextLinux createFromCurrent() {
        long glXGetCurrentDisplay = GL.getFunctionProvider().getFunctionAddress("glXGetCurrentDisplay");
        if (glXGetCurrentDisplay == 0L) {
            throw new OpenGLException("Failed to retrieve glXGetCurrentDisplay function address.");
        }
        return GLContextLinux.createFromCurrent(GLX12.nglXGetCurrentDisplay(glXGetCurrentDisplay));
    }

    public static GLContextLinux createFromCurrent(long display) {
        if (display == 0L) {
            throw new IllegalStateException("Invalid X server connection specified.");
        }
        long ctx = GLX.glXGetCurrentContext();
        if (ctx == 0L) {
            throw new IllegalStateException("No OpenGL context is current in the current thread.");
        }
        ContextCapabilities capabilities = GL.createCapabilities(false);
        return new GLContextLinux(capabilities, display, ctx);
    }

    @Override
    protected void destroyImpl() {
        GLX.glXDestroyContext(this.display, this.ctx);
    }

    private static class MakeCurrentActionARB
    implements MakeCurrentAction {
        private MakeCurrentActionARB() {
        }

        @Override
        public int invoke(long display, long draw, long read, long ctx) {
            return GLX13.glXMakeContextCurrent(display, draw, read, ctx);
        }
    }

    private static class MakeCurrentActionSGI
    implements MakeCurrentAction {
        private MakeCurrentActionSGI() {
        }

        @Override
        public int invoke(long display, long draw, long read, long ctx) {
            return GLXSGIMakeCurrentRead.glXMakeCurrentReadSGI(display, draw, read, ctx);
        }
    }

    private static interface MakeCurrentAction {
        public int invoke(long var1, long var3, long var5, long var7);
    }
}

