/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXARBCreateContext {
    public static final int GLX_CONTEXT_MAJOR_VERSION_ARB = 8337;
    public static final int GLX_CONTEXT_MINOR_VERSION_ARB = 8338;
    public static final int GLX_CONTEXT_FLAGS_ARB = 8340;
    public static final int GLX_CONTEXT_DEBUG_BIT_ARB = 1;
    public static final int GLX_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 2;
    public final long CreateContextAttribsARB;

    public GLXARBCreateContext(FunctionProvider provider) {
        this.CreateContextAttribsARB = provider.getFunctionAddress("glXCreateContextAttribsARB");
    }

    public static GLXARBCreateContext getInstance() {
        return GL.getCapabilities().__GLXARBCreateContext;
    }

    static GLXARBCreateContext create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_ARB_create_context")) {
            return null;
        }
        GLXARBCreateContext funcs = new GLXARBCreateContext(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateContextAttribsARB);
        return GL.checkExtension("GLX_ARB_create_context", funcs, supported);
    }

    public static native long nglXCreateContextAttribsARB(long var0, long var2, long var4, int var6, long var7, long var9);

    public static long nglXCreateContextAttribsARB(long display, long config, long share_context, int direct, long attrib_list) {
        long __functionAddress = GLXARBCreateContext.getInstance().CreateContextAttribsARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLXARBCreateContext.nglXCreateContextAttribsARB(display, config, share_context, direct, attrib_list, __functionAddress);
    }

    public static long glXCreateContextAttribsARB(long display, long config, long share_context, int direct, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLXARBCreateContext.nglXCreateContextAttribsARB(display, config, share_context, direct, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreateContextAttribsARB(long display, long config, long share_context, int direct, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLXARBCreateContext.nglXCreateContextAttribsARB(display, config, share_context, direct, MemoryUtil.memAddressSafe(attrib_list));
    }
}

